/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.impl;

import java.util.concurrent.CompletionStage;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.EntityUpdateAction;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.spi.EventSource;
import org.hibernate.generator.values.GeneratedValues;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.reactive.engine.ReactiveExecutable;
import org.hibernate.reactive.persister.entity.impl.ReactiveEntityPersister;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;

public class ReactiveEntityUpdateAction
extends EntityUpdateAction
implements ReactiveExecutable {
    public ReactiveEntityUpdateAction(Object id, Object[] state, int[] dirtyProperties, boolean hasDirtyCollection, Object[] previousState, Object previousVersion, Object nextVersion, Object instance, Object rowId, EntityPersister persister, EventSource session) {
        super(id, state, dirtyProperties, hasDirtyCollection, previousState, previousVersion, nextVersion, instance, rowId, persister, session);
    }

    @Override
    public CompletionStage<Void> reactiveExecute() throws HibernateException {
        if (this.preUpdate()) {
            return CompletionStages.voidFuture();
        }
        Object id = this.getId();
        EntityPersister persister = this.getPersister();
        EventSource session = this.getSession();
        Object instance = this.getInstance();
        Object previousVersion = this.getPreviousVersion();
        Object ck = this.lockCacheItem(previousVersion);
        ReactiveEntityPersister reactivePersister = (ReactiveEntityPersister)persister;
        return reactivePersister.updateReactive(id, this.getState(), this.getDirtyFields(), this.hasDirtyCollection(), this.getPreviousState(), previousVersion, instance, this.getRowId(), (SharedSessionContractImplementor)session).thenCompose(arg_0 -> this.lambda$reactiveExecute$1((SharedSessionContractImplementor)session, instance, persister, ck, id, arg_0));
    }

    private CompletionStage<Void> reactiveHandleGeneratedProperties(EntityEntry entry, GeneratedValues generatedValues) {
        EntityPersister persister = this.getPersister();
        if (entry.getStatus() == Status.MANAGED || persister.isVersionPropertyGenerated()) {
            EventSource session = this.getSession();
            Object instance = this.getInstance();
            Object id = this.getId();
            TypeHelper.deepCopy((Object[])this.getState(), (Type[])persister.getPropertyTypes(), (boolean[])persister.getPropertyCheckability(), (Object[])this.getState(), (SharedSessionContractImplementor)session);
            ReactiveEntityPersister reactivePersister = (ReactiveEntityPersister)persister;
            return this.processGeneratedProperties(id, reactivePersister, (SharedSessionContractImplementor)session, generatedValues, instance).thenAccept(v -> entry.postUpdate(instance, this.getState(), this.getNextVersion()));
        }
        return CompletionStages.voidFuture();
    }

    private CompletionStage<Void> processGeneratedProperties(Object id, ReactiveEntityPersister persister, SharedSessionContractImplementor session, GeneratedValues generatedValues, Object instance) {
        if (persister.hasUpdateGeneratedProperties()) {
            if (persister.isVersionPropertyGenerated()) {
                throw new UnsupportedOperationException("generated version attribute not supported in Hibernate Reactive");
            }
            return persister.reactiveProcessUpdateGenerated(id, instance, this.getState(), generatedValues, session);
        }
        return CompletionStages.voidFuture();
    }

    public void execute() throws HibernateException {
        throw new UnsupportedOperationException("This action only support reactive functions calls");
    }

    private /* synthetic */ CompletionStage lambda$reactiveExecute$1(SharedSessionContractImplementor session, Object instance, EntityPersister persister, Object ck, Object id, GeneratedValues generatedValues) {
        EntityEntry entry = session.getPersistenceContextInternal().getEntry(instance);
        if (entry == null) {
            throw new AssertionFailure("possible non-threadsafe access to session");
        }
        return this.reactiveHandleGeneratedProperties(entry, generatedValues).thenAccept(v -> {
            this.handleDeleted(entry);
            this.updateCacheItem(persister, ck, entry);
            this.handleNaturalIdResolutions(persister, session, id);
            this.postUpdate();
            StatisticsImplementor statistics = session.getFactory().getStatistics();
            if (statistics.isStatisticsEnabled()) {
                statistics.updateEntity(this.getPersister().getEntityName());
            }
        });
    }
}

