/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.jdbc.dialect.internal;

import org.hibernate.dialect.CockroachDialect;
import org.hibernate.dialect.Database;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DialectDelegateWrapper;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolver;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.reactive.dialect.ReactiveOracleSqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.internal.OptionalTableUpdate;

public class ReactiveStandardDialectResolver
implements DialectResolver {
    public Dialect resolveDialect(DialectResolutionInfo info) {
        if (info.getDatabaseName().startsWith("Cockroach")) {
            return new CockroachDialect(CockroachDialect.parseVersion((String)info.getDatabaseVersion()));
        }
        for (Database database : Database.values()) {
            if (!database.matchesResolutionInfo(info)) continue;
            Dialect dialect = database.createDialect(info);
            if (info.getDatabaseName().toUpperCase().startsWith("ORACLE")) {
                return new DialectDelegateWrapper(dialect){

                    public MutationOperation createOptionalTableUpdateOperation(EntityMutationTarget mutationTarget, OptionalTableUpdate optionalTableUpdate, SessionFactoryImplementor factory) {
                        return new ReactiveOracleSqlAstTranslator(factory, (Statement)optionalTableUpdate).createMergeOperation(optionalTableUpdate);
                    }

                    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
                        return new StandardSqlAstTranslatorFactory(){

                            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                                return new ReactiveOracleSqlAstTranslator(sessionFactory, statement);
                            }
                        };
                    }
                };
            }
            return dialect;
        }
        return null;
    }
}

