/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.engine.jdbc.mutation.internal;

import java.util.concurrent.CompletionStage;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MariaDBDialect;
import org.hibernate.engine.jdbc.mutation.OperationResultChecker;
import org.hibernate.engine.jdbc.mutation.TableInclusionChecker;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.mutation.internal.MutationExecutorSingleNonBatched;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.values.GeneratedValues;
import org.hibernate.generator.values.GeneratedValuesMutationDelegate;
import org.hibernate.reactive.engine.jdbc.env.internal.ReactiveMutationExecutor;
import org.hibernate.reactive.generator.values.ReactiveGeneratedValuesMutationDelegate;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.model.PreparableMutationOperation;
import org.hibernate.sql.model.ValuesAnalysis;

public class ReactiveMutationExecutorSingleNonBatched
extends MutationExecutorSingleNonBatched
implements ReactiveMutationExecutor {
    private final ReactiveGeneratedValuesMutationDelegate generatedValuesDelegate;

    public ReactiveMutationExecutorSingleNonBatched(PreparableMutationOperation mutationOperation, GeneratedValuesMutationDelegate generatedValuesDelegate, SharedSessionContractImplementor session) {
        super(mutationOperation, generatedValuesDelegate, session);
        this.generatedValuesDelegate = (ReactiveGeneratedValuesMutationDelegate)generatedValuesDelegate;
    }

    @Override
    public CompletionStage<GeneratedValues> performReactiveNonBatchedOperations(Object modelReference, ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session, boolean isIdentityInsert, String[] identifierColumnsNames) {
        PreparedStatementDetails singleStatementDetails = this.getStatementGroup().getSingleStatementDetails();
        if (this.generatedValuesDelegate != null && !this.isRegularInsertWithMariaDb(session, isIdentityInsert)) {
            return this.generatedValuesDelegate.reactivePerformMutation(singleStatementDetails, this.getJdbcValueBindings(), modelReference, session);
        }
        return this.performReactiveNonBatchedMutation(singleStatementDetails, null, this.getJdbcValueBindings(), inclusionChecker, resultChecker, session, identifierColumnsNames).thenCompose(CompletionStages::nullFuture);
    }

    private boolean isRegularInsertWithMariaDb(SharedSessionContractImplementor session, boolean isIdentityInsert) {
        if (isIdentityInsert) {
            return false;
        }
        Dialect dialect = session.getJdbcServices().getDialect();
        return dialect instanceof MariaDBDialect;
    }

    public void release() {
    }
}

