/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.event.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.PersistentObjectException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.internal.CascadePoint;
import org.hibernate.engine.spi.ActionQueue;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.internal.EvictVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.RefreshContext;
import org.hibernate.event.spi.RefreshEvent;
import org.hibernate.event.spi.RefreshEventListener;
import org.hibernate.loader.ast.spi.CascadingFetchProfile;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.reactive.engine.impl.Cascade;
import org.hibernate.reactive.engine.impl.CascadingActions;
import org.hibernate.reactive.event.ReactiveRefreshEventListener;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.persister.entity.impl.ReactiveAbstractEntityPersister;
import org.hibernate.reactive.session.ReactiveSession;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;

public class DefaultReactiveRefreshEventListener
implements RefreshEventListener,
ReactiveRefreshEventListener {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    @Override
    public CompletionStage<Void> reactiveOnRefresh(RefreshEvent event) throws HibernateException {
        return this.reactiveOnRefresh(event, RefreshContext.create());
    }

    public void onRefresh(RefreshEvent event) throws HibernateException {
        throw LOG.nonReactiveMethodCall("reactiveOnRefresh");
    }

    public void onRefresh(RefreshEvent event, RefreshContext refreshedAlready) throws HibernateException {
        throw LOG.nonReactiveMethodCall("reactiveOnRefresh");
    }

    @Override
    public CompletionStage<Void> reactiveOnRefresh(RefreshEvent event, RefreshContext refreshedAlready) {
        boolean detached;
        EventSource source = event.getSession();
        boolean bl = event.getEntityName() != null ? !source.contains(event.getEntityName(), event.getObject()) : (detached = !source.contains(event.getObject()));
        if (detached) {
            throw new IllegalArgumentException("Unmanaged instance passed to refresh()");
        }
        return ((ReactiveSession)source).reactiveFetch(event.getObject(), true).thenCompose(entity -> this.reactiveOnRefresh(event, refreshedAlready, entity));
    }

    private CompletionStage<Void> reactiveOnRefresh(RefreshEvent event, RefreshContext refreshedAlready, Object object) {
        Object id;
        EntityPersister persister;
        EventSource source = event.getSession();
        PersistenceContext persistenceContext = source.getPersistenceContextInternal();
        if (persistenceContext.reassociateIfUninitializedProxy(object)) {
            if (DefaultReactiveRefreshEventListener.isTransient(event, source, object)) {
                source.setReadOnly(object, source.isDefaultReadOnly());
            }
            return CompletionStages.voidFuture();
        }
        Object entity = persistenceContext.unproxyAndReassociate(object);
        if (!refreshedAlready.add(entity)) {
            LOG.trace("Already refreshed");
            return CompletionStages.voidFuture();
        }
        EntityEntry entry = persistenceContext.getEntry(entity);
        if (entry == null) {
            persister = source.getEntityPersister(event.getEntityName(), entity);
            id = persister.getIdentifier(entity, (SharedSessionContractImplementor)event.getSession());
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Refreshing transient {0}", MessageHelper.infoString((EntityPersister)persister, (Object)id, (SessionFactoryImplementor)source.getFactory()));
            }
            if (persistenceContext.getEntry((Object)source.generateEntityKey(id, persister)) != null) {
                throw new PersistentObjectException("attempted to refresh transient instance when persistent instance was already associated with the session: " + MessageHelper.infoString((EntityPersister)persister, (Object)id, (SessionFactoryImplementor)source.getFactory()));
            }
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Refreshing ", MessageHelper.infoString((EntityPersister)entry.getPersister(), (Object)entry.getId(), (SessionFactoryImplementor)source.getFactory()));
            }
            if (!entry.isExistsInDatabase()) {
                throw new UnresolvableObjectException(entry.getId(), "this instance does not yet exist as a row in the database");
            }
            persister = entry.getPersister();
            id = entry.getId();
        }
        return this.cascadeRefresh(source, persister, entity, refreshedAlready).thenCompose(v -> {
            if (entry != null) {
                persistenceContext.removeEntityHolder(entry.getEntityKey());
                if (persister.hasCollections()) {
                    new EvictVisitor(source, object).process(object, persister);
                }
                persistenceContext.removeEntry(object);
            }
            DefaultReactiveRefreshEventListener.evictEntity(entity, persister, id, source);
            this.evictCachedCollections(persister, id, source);
            CompletableFuture refresh = new CompletableFuture();
            source.getLoadQueryInfluencers().fromInternalFetchProfile(CascadingFetchProfile.REFRESH, () -> DefaultReactiveRefreshEventListener.doRefresh(event, source, entity, entry, persister, id, persistenceContext).whenComplete((unused, throwable) -> {
                if (throwable == null) {
                    refresh.complete(null);
                } else {
                    refresh.completeExceptionally((Throwable)throwable);
                }
            }));
            return refresh;
        });
    }

    private static boolean isTransient(RefreshEvent event, EventSource source, Object object) {
        String entityName = event.getEntityName();
        return entityName != null ? !source.contains(entityName, object) : !source.contains(object);
    }

    private static void evictEntity(Object entity, EntityPersister persister, Object id, EventSource source) {
        if (persister.canWriteToCache()) {
            Object previousVersion = null;
            if (persister.isVersionPropertyGenerated()) {
                previousVersion = persister.getVersion(entity);
            }
            EntityDataAccess cache = persister.getCacheAccessStrategy();
            Object ck = cache.generateCacheKey(id, persister, source.getFactory(), source.getTenantIdentifier());
            SoftLock lock = cache.lockItem((SharedSessionContractImplementor)source, ck, previousVersion);
            cache.remove((SharedSessionContractImplementor)source, ck);
            source.getActionQueue().registerProcess((success, session) -> cache.unlockItem(session, ck, lock));
        }
    }

    private static CompletionStage<Void> doRefresh(RefreshEvent event, EventSource source, Object entity, EntityEntry entry, EntityPersister persister, Object id, PersistenceContext persistenceContext) {
        LockMode postRefreshLockMode;
        LockOptions lockOptionsToUse = event.getLockOptions();
        LockMode requestedLockMode = lockOptionsToUse.getLockMode();
        if (entry != null) {
            LockMode currentLockMode = entry.getLockMode();
            if (currentLockMode.greaterThan(requestedLockMode)) {
                lockOptionsToUse = event.getLockOptions().makeCopy();
                if (currentLockMode == LockMode.WRITE || currentLockMode == LockMode.PESSIMISTIC_WRITE || currentLockMode == LockMode.PESSIMISTIC_READ) {
                    lockOptionsToUse.setLockMode(LockMode.READ);
                    postRefreshLockMode = currentLockMode;
                } else {
                    lockOptionsToUse.setLockMode(currentLockMode);
                    postRefreshLockMode = null;
                }
            } else {
                postRefreshLockMode = null;
            }
        } else {
            postRefreshLockMode = null;
        }
        return ((ReactiveAbstractEntityPersister)persister).reactiveLoad(id, entity, lockOptionsToUse, (SharedSessionContractImplementor)source).thenAccept(result -> {
            if (result != null) {
                if (postRefreshLockMode != null) {
                    persistenceContext.getEntry(result).setLockMode(postRefreshLockMode);
                }
                if (!persister.isMutable()) {
                    source.setReadOnly(result, true);
                } else {
                    source.setReadOnly(result, entry == null ? source.isDefaultReadOnly() : entry.isReadOnly());
                }
            }
            UnresolvableObjectException.throwIfNull((Object)result, (Object)id, (String)persister.getEntityName());
        });
    }

    private CompletionStage<Void> cascadeRefresh(EventSource source, EntityPersister persister, Object object, RefreshContext refreshedAlready) {
        return Cascade.cascade(CascadingActions.REFRESH, CascadePoint.BEFORE_REFRESH, source, persister, object, refreshedAlready);
    }

    private void evictCachedCollections(EntityPersister persister, Object id, EventSource source) {
        this.evictCachedCollections(persister.getPropertyTypes(), id, source);
    }

    private void evictCachedCollections(Type[] types, Object id, EventSource source) throws HibernateException {
        ActionQueue actionQueue = source.getActionQueue();
        SessionFactoryImplementor factory = source.getFactory();
        MappingMetamodelImplementor metamodel = factory.getRuntimeMetamodels().getMappingMetamodel();
        for (Type type : types) {
            if (type.isCollectionType()) {
                String role = ((CollectionType)type).getRole();
                CollectionPersister collectionPersister = metamodel.getCollectionDescriptor(role);
                if (!collectionPersister.hasCache()) continue;
                CollectionDataAccess cache = collectionPersister.getCacheAccessStrategy();
                Object ck = cache.generateCacheKey(id, collectionPersister, factory, source.getTenantIdentifier());
                SoftLock lock = cache.lockItem((SharedSessionContractImplementor)source, ck, null);
                cache.remove((SharedSessionContractImplementor)source, ck);
                actionQueue.registerProcess((success, session) -> cache.unlockItem(session, ck, lock));
                continue;
            }
            if (!type.isComponentType()) continue;
            CompositeType compositeType = (CompositeType)type;
            this.evictCachedCollections(compositeType.getSubtypes(), id, source);
        }
    }
}

