/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.id.impl;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.net.impl.pool.CombinerExecutor;
import io.vertx.core.net.impl.pool.Executor;
import io.vertx.core.net.impl.pool.Task;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hibernate.reactive.id.ReactiveIdentifierGenerator;
import org.hibernate.reactive.session.ReactiveConnectionSupplier;
import org.hibernate.reactive.util.impl.CompletionStages;

public abstract class BlockingIdentifierGenerator
implements ReactiveIdentifierGenerator<Long> {
    private final GeneratorState state = new GeneratorState();
    private final CombinerExecutor executor = new CombinerExecutor((Object)this.state);

    protected abstract int getBlockSize();

    protected abstract CompletionStage<Long> nextHiValue(ReactiveConnectionSupplier var1);

    private synchronized long next() {
        return this.state.loValue > 0 && this.state.loValue < this.getBlockSize() ? this.state.hiValue + (long)this.state.loValue++ : -1L;
    }

    private synchronized long next(long hi) {
        this.state.hiValue = hi;
        this.state.loValue = 1;
        return hi;
    }

    @Override
    public CompletionStage<Long> generate(ReactiveConnectionSupplier connectionSupplier, Object ignored) {
        Objects.requireNonNull(connectionSupplier);
        long next = this.next();
        if (next != -1L) {
            return CompletionStages.completedFuture(next);
        }
        if (this.getBlockSize() <= 1) {
            return this.nextHiValue(connectionSupplier).thenApply(this::next);
        }
        CompletableFuture<Long> resultForThisEventLoop = new CompletableFuture<Long>();
        CompletableFuture<Long> result = new CompletableFuture<Long>();
        Context context = Vertx.currentContext();
        this.executor.submit((Executor.Action)new GenerateIdAction(connectionSupplier, result));
        result.whenComplete((id, t) -> {
            Context newContext = Vertx.currentContext();
            if (newContext != context) {
                if (t != null) {
                    context.runOnContext(v -> resultForThisEventLoop.completeExceptionally((Throwable)t));
                } else {
                    context.runOnContext(v -> resultForThisEventLoop.complete((Long)id));
                }
            } else if (t != null) {
                resultForThisEventLoop.completeExceptionally((Throwable)t);
            } else {
                resultForThisEventLoop.complete((Long)id);
            }
        });
        return resultForThisEventLoop;
    }

    private final class GenerateIdAction
    implements Executor.Action<GeneratorState> {
        private final ReactiveConnectionSupplier connectionSupplier;
        private final CompletableFuture<Long> result;

        public GenerateIdAction(ReactiveConnectionSupplier connectionSupplier, CompletableFuture<Long> result) {
            this.connectionSupplier = Objects.requireNonNull(connectionSupplier);
            this.result = Objects.requireNonNull(result);
        }

        public Task execute(GeneratorState state) {
            long local = BlockingIdentifierGenerator.this.next();
            if (local >= 0L) {
                CompletionStages.completedFuture(local).whenComplete(this::acceptAsReturnValue);
                return null;
            }
            BlockingIdentifierGenerator.this.nextHiValue(this.connectionSupplier).whenComplete((newlyGeneratedHi, throwable) -> {
                if (throwable != null) {
                    this.result.completeExceptionally((Throwable)throwable);
                } else {
                    BlockingIdentifierGenerator.this.executor.submit(stateIgnored -> {
                        this.result.complete(BlockingIdentifierGenerator.this.next((long)newlyGeneratedHi));
                        return null;
                    });
                }
            });
            return null;
        }

        private void acceptAsReturnValue(Long aLong, Throwable throwable) {
            if (throwable != null) {
                this.result.completeExceptionally(throwable);
            } else {
                this.result.complete(aLong);
            }
        }
    }

    private static class GeneratorState {
        private int loValue;
        private long hiValue;

        private GeneratorState() {
        }
    }
}

