/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.ast.internal;

import java.lang.reflect.Array;
import java.util.concurrent.CompletionStage;
import org.hibernate.LockOptions;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.BatchFetchQueue;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.MultiKeyLoadHelper;
import org.hibernate.loader.ast.internal.MultiKeyLoadLogging;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.loader.ast.spi.SqlArrayMultiKeyLoader;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.internal.SimpleForeignKeyDescriptor;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.reactive.loader.ast.internal.ReactiveAbstractCollectionBatchLoader;
import org.hibernate.reactive.loader.ast.internal.SingleIdExecutionContext;
import org.hibernate.reactive.sql.exec.internal.StandardReactiveSelectExecutor;
import org.hibernate.reactive.sql.results.spi.ReactiveListResultsConsumer;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;
import org.hibernate.type.BasicType;

public class ReactiveCollectionBatchLoaderArrayParam
extends ReactiveAbstractCollectionBatchLoader
implements SqlArrayMultiKeyLoader {
    private final Class<?> arrayElementType;
    private final JdbcMapping arrayJdbcMapping;
    private final JdbcParameter jdbcParameter;
    private final SelectStatement sqlSelect;
    private final JdbcOperationQuerySelect jdbcSelectOperation;

    public ReactiveCollectionBatchLoaderArrayParam(int domainBatchSize, LoadQueryInfluencers loadQueryInfluencers, PluralAttributeMapping attributeMapping, SessionFactoryImplementor sessionFactory) {
        super(domainBatchSize, loadQueryInfluencers, attributeMapping, sessionFactory);
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isDebugEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.debugf("Using ARRAY batch fetching strategy for collection `%s` : %s", (Object)attributeMapping.getNavigableRole().getFullPath(), (Object)domainBatchSize);
        }
        SimpleForeignKeyDescriptor keyDescriptor = (SimpleForeignKeyDescriptor)this.getLoadable().getKeyDescriptor();
        this.arrayElementType = keyDescriptor.getJavaType().getJavaTypeClass();
        Class<?> arrayClass = Array.newInstance(this.arrayElementType, 0).getClass();
        BasicType arrayBasicType = this.getSessionFactory().getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(arrayClass);
        this.arrayJdbcMapping = MultiKeyLoadHelper.resolveArrayJdbcMapping((BasicType)arrayBasicType, (JdbcMapping)keyDescriptor.getJdbcMapping(), arrayClass, (SessionFactoryImplementor)this.getSessionFactory());
        this.jdbcParameter = new JdbcParameterImpl(this.arrayJdbcMapping);
        this.sqlSelect = LoaderSelectBuilder.createSelectBySingleArrayParameter((Loadable)this.getLoadable(), (ValuedModelPart)keyDescriptor.getKeyPart(), (LoadQueryInfluencers)this.getInfluencers(), (LockOptions)LockOptions.NONE, (JdbcParameter)this.jdbcParameter, (SessionFactoryImplementor)this.getSessionFactory());
        this.jdbcSelectOperation = (JdbcOperationQuerySelect)this.getSessionFactory().getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(this.getSessionFactory(), this.sqlSelect).translate(JdbcParameterBindings.NO_BINDINGS, QueryOptions.NONE);
    }

    @Override
    public CompletionStage<PersistentCollection<?>> reactiveLoad(Object key, SharedSessionContractImplementor session) {
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isDebugEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.debugf("Batch loading entity `%s#%s`", (Object)this.getLoadable().getNavigableRole().getFullPath(), key);
        }
        Object[] keysToInitialize = this.resolveKeysToInitialize(key, session);
        return this.initializeKeys(keysToInitialize, session).thenApply(v -> {
            for (int i = 0; i < keysToInitialize.length; ++i) {
                this.finishInitializingKey(keysToInitialize[i], session);
            }
            CollectionKey collectionKey = new CollectionKey(this.getLoadable().getCollectionDescriptor(), key);
            return session.getPersistenceContext().getCollection(collectionKey);
        });
    }

    private Object[] resolveKeysToInitialize(Object keyBeingLoaded, SharedSessionContractImplementor session) {
        Object[] keysToInitialize = (Object[])Array.newInstance(this.arrayElementType, this.getDomainBatchSize());
        session.getPersistenceContextInternal().getBatchFetchQueue().collectBatchLoadableCollectionKeys(this.getDomainBatchSize(), (index, value) -> {
            keysToInitialize[index] = value;
        }, keyBeingLoaded, this.getLoadable());
        return keysToInitialize;
    }

    private CompletionStage<Void> initializeKeys(Object[] keysToInitialize, SharedSessionContractImplementor session) {
        assert (this.jdbcSelectOperation != null);
        assert (this.jdbcParameter != null);
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(1);
        jdbcParameterBindings.addBinding(this.jdbcParameter, (JdbcParameterBinding)new JdbcParameterBindingImpl(this.arrayJdbcMapping, (Object)keysToInitialize));
        SubselectFetch.RegistrationHandler subSelectFetchableKeysHandler = SubselectFetch.createRegistrationHandler((BatchFetchQueue)session.getPersistenceContext().getBatchFetchQueue(), (SelectStatement)this.sqlSelect, (JdbcParametersList)JdbcParametersList.singleton((JdbcParameter)this.jdbcParameter), (JdbcParameterBindings)jdbcParameterBindings);
        return StandardReactiveSelectExecutor.INSTANCE.list(this.jdbcSelectOperation, (JdbcParameterBindings)jdbcParameterBindings, (ExecutionContext)new SingleIdExecutionContext(null, null, null, LockOptions.NONE, subSelectFetchableKeysHandler, session), RowTransformerStandardImpl.instance(), ReactiveListResultsConsumer.UniqueSemantic.FILTER).thenCompose(CompletionStages::voidFuture);
    }

    public void prepare() {
    }
}

