/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.ast.internal;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.BatchFetchQueue;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.reactive.loader.ast.internal.SingleIdExecutionContext;
import org.hibernate.reactive.sql.exec.internal.StandardReactiveSelectExecutor;
import org.hibernate.reactive.sql.results.spi.ReactiveListResultsConsumer;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;

public class ReactiveLoaderHelper {
    public static <X> X[] createTypedArray(Class<X> elementClass, int length) {
        return (Object[])Array.newInstance(elementClass, length);
    }

    public static <R, K> CompletionStage<List<R>> loadByArrayParameter(K[] idsToInitialize, SelectStatement sqlAst, JdbcOperationQuerySelect jdbcOperation, JdbcParameter jdbcParameter, JdbcMapping arrayJdbcMapping, Object entityId, Object entityInstance, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        Objects.requireNonNull(jdbcOperation);
        Objects.requireNonNull(jdbcParameter);
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(1);
        jdbcParameterBindings.addBinding(jdbcParameter, (JdbcParameterBinding)new JdbcParameterBindingImpl(arrayJdbcMapping, idsToInitialize));
        SubselectFetch.RegistrationHandler subSelectFetchableKeysHandler = SubselectFetch.createRegistrationHandler((BatchFetchQueue)session.getPersistenceContext().getBatchFetchQueue(), (SelectStatement)sqlAst, (JdbcParametersList)JdbcParametersList.singleton((JdbcParameter)jdbcParameter), (JdbcParameterBindings)jdbcParameterBindings);
        return StandardReactiveSelectExecutor.INSTANCE.list(jdbcOperation, (JdbcParameterBindings)jdbcParameterBindings, (ExecutionContext)new SingleIdExecutionContext(entityId, entityInstance, readOnly, lockOptions, subSelectFetchableKeysHandler, session), RowTransformerStandardImpl.instance(), ReactiveListResultsConsumer.UniqueSemantic.FILTER);
    }
}

