/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.ast.internal;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.BatchFetchQueue;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.LoadEvent;
import org.hibernate.event.spi.LoadEventListener;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.loader.ast.internal.CacheEntityLoaderHelper;
import org.hibernate.loader.ast.internal.LoaderHelper;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.loader.ast.spi.MultiIdLoadOptions;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.reactive.loader.ast.internal.ExecutionContextWithSubselectFetchHandler;
import org.hibernate.reactive.loader.ast.internal.ReactiveAbstractMultiIdEntityLoader;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.persister.entity.impl.ReactiveEntityPersister;
import org.hibernate.reactive.sql.exec.internal.StandardReactiveSelectExecutor;
import org.hibernate.reactive.sql.results.spi.ReactiveListResultsConsumer;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;
import org.hibernate.type.descriptor.java.JavaType;

public class ReactiveMultiIdEntityLoaderStandard<T>
extends ReactiveAbstractMultiIdEntityLoader<T> {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final int idJdbcTypeCount;

    public ReactiveMultiIdEntityLoaderStandard(EntityPersister entityDescriptor, PersistentClass bootDescriptor, SessionFactoryImplementor sessionFactory) {
        super((EntityMappingType)entityDescriptor, sessionFactory);
        this.idJdbcTypeCount = bootDescriptor.getIdentifier().getColumnSpan();
        assert (this.idJdbcTypeCount > 0);
    }

    @Override
    protected CompletionStage<List<T>> performOrderedMultiLoad(Object[] ids, MultiIdLoadOptions loadOptions, EventSource session) {
        if (LOG.isTraceEnabled()) {
            LOG.tracef("#performOrderedMultiLoad(`%s`, ..)", this.getEntityDescriptor().getEntityName());
        }
        assert (loadOptions.isOrderReturnEnabled());
        JdbcEnvironment jdbcEnvironment = this.getSessionFactory().getJdbcServices().getJdbcEnvironment();
        Dialect dialect = jdbcEnvironment.getDialect();
        ArrayList result = CollectionHelper.arrayList((int)ids.length);
        LockOptions lockOptions = loadOptions.getLockOptions() == null ? new LockOptions(LockMode.NONE) : loadOptions.getLockOptions();
        int maxBatchSize = loadOptions.getBatchSize() != null && loadOptions.getBatchSize() > 0 ? loadOptions.getBatchSize().intValue() : dialect.getBatchLoadSizingStrategy().determineOptimalBatchLoadSize(this.idJdbcTypeCount, ids.length, this.getSessionFactory().getSessionFactoryOptions().inClauseParameterPaddingEnabled());
        ArrayList idsInBatch = new ArrayList();
        ArrayList elementPositionsLoadedByBatch = new ArrayList();
        boolean coerce = !this.getSessionFactory().getJpaMetamodel().getJpaCompliance().isLoadByIdComplianceEnabled();
        return CompletionStages.loop(0, ids.length, i -> {
            Object id = coerce ? this.getEntityDescriptor().getIdentifierMapping().getJavaType().coerce(ids[i], (JavaType.CoercionContext)session) : ids[i];
            EntityKey entityKey = new EntityKey(id, this.getLoadable().getEntityPersister());
            if (loadOptions.isSessionCheckingEnabled() || loadOptions.isSecondLevelCacheCheckingEnabled()) {
                CacheEntityLoaderHelper.PersistenceContextEntry persistenceContextEntry;
                LoadEvent loadEvent = new LoadEvent(id, this.getLoadable().getJavaType().getJavaTypeClass().getName(), lockOptions, session, LoaderHelper.getReadOnlyFromLoadQueryInfluencers((SharedSessionContractImplementor)session));
                Object managedEntity = null;
                if (loadOptions.isSessionCheckingEnabled() && (managedEntity = (persistenceContextEntry = CacheEntityLoaderHelper.INSTANCE.loadFromSessionCache(loadEvent, entityKey, LoadEventListener.GET)).getEntity()) != null && !loadOptions.isReturnOfDeletedEntitiesEnabled() && !persistenceContextEntry.isManaged()) {
                    result.add(i, null);
                    return CompletionStages.voidFuture();
                }
                if (managedEntity == null && loadOptions.isSecondLevelCacheCheckingEnabled()) {
                    managedEntity = CacheEntityLoaderHelper.INSTANCE.loadFromSecondLevelCache(loadEvent, this.getLoadable().getEntityPersister(), entityKey);
                }
                if (managedEntity != null) {
                    result.add(i, managedEntity);
                    return CompletionStages.voidFuture();
                }
            }
            idsInBatch.add(id);
            CompletionStage<Void> loopResult = CompletionStages.voidFuture();
            if (idsInBatch.size() >= maxBatchSize) {
                loopResult = this.loadEntitiesById(idsInBatch, lockOptions, (SharedSessionContractImplementor)session).thenAccept(v -> idsInBatch.clear());
            }
            return loopResult.thenAccept(v -> {
                result.add(i, entityKey);
                elementPositionsLoadedByBatch.add(i);
            });
        }).thenCompose(v -> {
            if (!idsInBatch.isEmpty()) {
                return this.loadEntitiesById(idsInBatch, lockOptions, (SharedSessionContractImplementor)session).thenCompose(CompletionStages::voidFuture);
            }
            return CompletionStages.voidFuture();
        }).thenApply(v -> {
            PersistenceContext persistenceContext = session.getPersistenceContextInternal();
            for (Integer position : elementPositionsLoadedByBatch) {
                EntityEntry entry;
                EntityKey entityKey = (EntityKey)result.get(position);
                Object entity = persistenceContext.getEntity(entityKey);
                if (entity != null && !loadOptions.isReturnOfDeletedEntitiesEnabled() && (entry = persistenceContext.getEntry(entity)).getStatus().isDeletedOrGone()) {
                    entity = null;
                }
                result.set(position, entity);
            }
            return result;
        });
    }

    private CompletionStage<List<T>> loadEntitiesById(List<Object> idsInBatch, LockOptions lockOptions, SharedSessionContractImplementor session) {
        assert (idsInBatch != null);
        assert (!idsInBatch.isEmpty());
        int numberOfIdsInBatch = idsInBatch.size();
        if (numberOfIdsInBatch == 1) {
            return this.performSingleMultiLoad(idsInBatch.get(0), lockOptions, session);
        }
        if (LOG.isTraceEnabled()) {
            LOG.tracef("#loadEntitiesById(`%s`, `%s`, ..)", this.getEntityDescriptor().getEntityName(), numberOfIdsInBatch);
        }
        JdbcParametersList.Builder jdbcParametersListBuilder = JdbcParametersList.newBuilder((int)(numberOfIdsInBatch * this.idJdbcTypeCount));
        SelectStatement sqlAst = LoaderSelectBuilder.createSelect((Loadable)this.getLoadable(), null, (ModelPart)this.getLoadable().getIdentifierMapping(), null, (int)numberOfIdsInBatch, (LoadQueryInfluencers)session.getLoadQueryInfluencers(), (LockOptions)lockOptions, arg_0 -> ((JdbcParametersList.Builder)jdbcParametersListBuilder).add(arg_0), (SessionFactoryImplementor)this.getSessionFactory());
        JdbcParametersList jdbcParameters = jdbcParametersListBuilder.build();
        JdbcServices jdbcServices = this.getSessionFactory().getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(jdbcParameters.size());
        int offset = 0;
        for (int i = 0; i < numberOfIdsInBatch; ++i) {
            Object id = idsInBatch.get(i);
            offset += jdbcParameterBindings.registerParametersForEachJdbcValue(id, offset, (Bindable)this.getEntityDescriptor().getIdentifierMapping(), jdbcParameters, session);
        }
        assert (offset == jdbcParameters.size());
        JdbcOperationQuerySelect jdbcSelect = (JdbcOperationQuerySelect)sqlAstTranslatorFactory.buildSelectTranslator(this.getSessionFactory(), sqlAst).translate((JdbcParameterBindings)jdbcParameterBindings, QueryOptions.NONE);
        SubselectFetch.RegistrationHandler subSelectFetchableKeysHandler = this.getLoadable().getEntityPersister().hasSubselectLoadableCollections() ? SubselectFetch.createRegistrationHandler((BatchFetchQueue)session.getPersistenceContext().getBatchFetchQueue(), (SelectStatement)sqlAst, (JdbcParametersList)jdbcParameters, (JdbcParameterBindings)jdbcParameterBindings) : null;
        return StandardReactiveSelectExecutor.INSTANCE.list(jdbcSelect, (JdbcParameterBindings)jdbcParameterBindings, (ExecutionContext)new ExecutionContextWithSubselectFetchHandler(session, subSelectFetchableKeysHandler), RowTransformerStandardImpl.instance(), ReactiveListResultsConsumer.UniqueSemantic.FILTER);
    }

    private CompletionStage<List<T>> performSingleMultiLoad(Object id, LockOptions lockOptions, SharedSessionContractImplementor session) {
        return ((ReactiveEntityPersister)this.getEntityDescriptor()).reactiveLoad(id, null, lockOptions, session).thenApply(ReactiveMultiIdEntityLoaderStandard::singletonList);
    }

    private static <T> List<T> singletonList(Object loaded) {
        return Collections.singletonList(loaded);
    }

    @Override
    protected CompletionStage<List<T>> performUnorderedMultiLoad(Object[] ids, MultiIdLoadOptions loadOptions, EventSource session) {
        LockOptions lockOptions;
        assert (!loadOptions.isOrderReturnEnabled());
        assert (ids != null);
        if (LOG.isTraceEnabled()) {
            LOG.tracef("#performUnorderedMultiLoad(`%s`, ..)", this.getEntityDescriptor().getEntityName());
        }
        ArrayList result = CollectionHelper.arrayList((int)ids.length);
        LockOptions lockOptions2 = lockOptions = loadOptions.getLockOptions() == null ? new LockOptions(LockMode.NONE) : loadOptions.getLockOptions();
        if (loadOptions.isSessionCheckingEnabled() || loadOptions.isSecondLevelCacheCheckingEnabled()) {
            boolean foundAnyManagedEntities = false;
            ArrayList<Object> nonManagedIds = new ArrayList<Object>();
            boolean coerce = !this.getSessionFactory().getJpaMetamodel().getJpaCompliance().isLoadByIdComplianceEnabled();
            for (int i = 0; i < ids.length; ++i) {
                Object id = coerce ? this.getEntityDescriptor().getIdentifierMapping().getJavaType().coerce(ids[i], (JavaType.CoercionContext)session) : ids[i];
                EntityKey entityKey = new EntityKey(id, this.getLoadable().getEntityPersister());
                LoadEvent loadEvent = new LoadEvent(id, this.getLoadable().getJavaType().getJavaTypeClass().getName(), lockOptions, session, this.getReadOnlyFromLoadQueryInfluencers((SharedSessionContractImplementor)session));
                Object managedEntity = null;
                CacheEntityLoaderHelper.PersistenceContextEntry persistenceContextEntry = CacheEntityLoaderHelper.INSTANCE.loadFromSessionCache(loadEvent, entityKey, LoadEventListener.GET);
                if (loadOptions.isSessionCheckingEnabled() && (managedEntity = persistenceContextEntry.getEntity()) != null && !loadOptions.isReturnOfDeletedEntitiesEnabled() && !persistenceContextEntry.isManaged()) {
                    foundAnyManagedEntities = true;
                    result.add(null);
                    continue;
                }
                if (managedEntity == null && loadOptions.isSecondLevelCacheCheckingEnabled()) {
                    managedEntity = CacheEntityLoaderHelper.INSTANCE.loadFromSecondLevelCache(loadEvent, this.getLoadable().getEntityPersister(), entityKey);
                }
                if (managedEntity != null) {
                    foundAnyManagedEntities = true;
                    result.add(managedEntity);
                    continue;
                }
                nonManagedIds.add(id);
            }
            if (foundAnyManagedEntities) {
                if (nonManagedIds.isEmpty()) {
                    return CompletionStages.completedFuture(result);
                }
                ids = nonManagedIds.toArray((Object[])Array.newInstance(ids.getClass().getComponentType(), nonManagedIds.size()));
            }
        }
        Object[] identifiers = ids;
        int[] numberOfIdsLeft = new int[]{ids.length};
        int maxBatchSize = loadOptions.getBatchSize() != null && loadOptions.getBatchSize() > 0 ? loadOptions.getBatchSize().intValue() : session.getJdbcServices().getJdbcEnvironment().getDialect().getBatchLoadSizingStrategy().determineOptimalBatchLoadSize(this.getIdentifierMapping().getJdbcTypeCount(), numberOfIdsLeft[0], this.getSessionFactory().getSessionFactoryOptions().inClauseParameterPaddingEnabled());
        int[] idPosition = new int[]{0};
        return CompletionStages.whileLoop(() -> numberOfIdsLeft[0] > 0, () -> {
            int batchSize = Math.min(numberOfIdsLeft[0], maxBatchSize);
            Object[] idsInBatch = new Object[batchSize];
            System.arraycopy(identifiers, idPosition[0], idsInBatch, 0, batchSize);
            return this.loadEntitiesById(Arrays.asList(idsInBatch), lockOptions, (SharedSessionContractImplementor)session).thenAccept(result::addAll).thenAccept(v -> {
                numberOfIdsLeft[0] = numberOfIdsLeft[0] - batchSize;
                idPosition[0] = idPosition[0] + batchSize;
            });
        }).thenApply(v -> result);
    }

    private Boolean getReadOnlyFromLoadQueryInfluencers(SharedSessionContractImplementor session) {
        Boolean readOnly = null;
        LoadQueryInfluencers loadQueryInfluencers = session.getLoadQueryInfluencers();
        if (loadQueryInfluencers != null) {
            readOnly = loadQueryInfluencers.getReadOnly();
        }
        return readOnly;
    }
}

