/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.ast.internal;

import java.util.List;
import java.util.concurrent.CompletionStage;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.SingleIdLoadPlan;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.internal.SimpleQueryOptions;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.reactive.sql.exec.internal.StandardReactiveSelectExecutor;
import org.hibernate.reactive.sql.results.spi.ReactiveListResultsConsumer;
import org.hibernate.resource.jdbc.spi.LogicalConnectionImplementor;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.CallbackImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;

public class ReactiveSingleIdLoadPlan<T>
extends SingleIdLoadPlan<CompletionStage<T>> {
    public ReactiveSingleIdLoadPlan(EntityMappingType entityMappingType, ModelPart restrictivePart, SelectStatement sqlAst, JdbcParametersList jdbcParameters, LockOptions lockOptions, SessionFactoryImplementor sessionFactory) {
        super(entityMappingType, restrictivePart, sqlAst, jdbcParameters, lockOptions, sessionFactory);
    }

    public CompletionStage<T> load(Object restrictedValue, Object entityInstance, Boolean readOnly, Boolean singleResultExpected, SharedSessionContractImplementor session) {
        int offset;
        int jdbcTypeCount = this.getRestrictivePart().getJdbcTypeCount();
        assert (this.getJdbcParameters().size() % jdbcTypeCount == 0);
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(jdbcTypeCount);
        for (offset = 0; offset < this.getJdbcParameters().size(); offset += jdbcParameterBindings.registerParametersForEachJdbcValue(restrictedValue, offset, (Bindable)this.getRestrictivePart(), this.getJdbcParameters(), session)) {
        }
        assert (offset == this.getJdbcParameters().size());
        SimpleQueryOptions queryOptions = new SimpleQueryOptions(this.getLockOptions(), readOnly);
        CallbackImpl callback = new CallbackImpl();
        EntityMappingType loadable = (EntityMappingType)this.getLoadable();
        ExecutionContext executionContext = ReactiveSingleIdLoadPlan.executionContext(restrictedValue, entityInstance, session, loadable.getRootEntityDescriptor(), (QueryOptions)queryOptions, (Callback)callback);
        return StandardReactiveSelectExecutor.INSTANCE.list(this.getJdbcSelect(), (JdbcParameterBindings)jdbcParameterBindings, executionContext, this.getRowTransformer(), ReactiveSingleIdLoadPlan.resultConsumer(singleResultExpected)).thenApply(this::extractEntity).thenApply(arg_0 -> this.lambda$load$0((Callback)callback, session, arg_0));
    }

    private <T> void invokeAfterLoadActions(Callback callback, SharedSessionContractImplementor session, T entity) {
        if (entity != null && this.getLoadable() != null) {
            callback.invokeAfterLoadActions(entity, (EntityMappingType)this.getLoadable(), session);
        }
    }

    private Object extractEntity(List<?> list) {
        return list.isEmpty() ? null : list.get(0);
    }

    private static ExecutionContext executionContext(final Object restrictedValue, final Object entityInstance, final SharedSessionContractImplementor session, final EntityMappingType rootEntityDescriptor, final QueryOptions queryOptions, final Callback callback) {
        return new ExecutionContext(){

            public boolean isScrollResult() {
                return super.isScrollResult();
            }

            public SharedSessionContractImplementor getSession() {
                return session;
            }

            public Object getEntityInstance() {
                return entityInstance;
            }

            public Object getEntityId() {
                return restrictedValue;
            }

            public void registerLoadingEntityHolder(EntityHolder holder) {
                super.registerLoadingEntityHolder(holder);
            }

            public void afterStatement(LogicalConnectionImplementor logicalConnection) {
                super.afterStatement(logicalConnection);
            }

            public boolean hasQueryExecutionToBeAddedToStatistics() {
                return super.hasQueryExecutionToBeAddedToStatistics();
            }

            public QueryOptions getQueryOptions() {
                return queryOptions;
            }

            public LoadQueryInfluencers getLoadQueryInfluencers() {
                return null;
            }

            public String getQueryIdentifier(String sql) {
                return sql;
            }

            public CollectionKey getCollectionKey() {
                return super.getCollectionKey();
            }

            public QueryParameterBindings getQueryParameterBindings() {
                return QueryParameterBindings.NO_PARAM_BINDINGS;
            }

            public EntityMappingType getRootEntityDescriptor() {
                return rootEntityDescriptor;
            }

            public Callback getCallback() {
                return callback;
            }
        };
    }

    private static ReactiveListResultsConsumer.UniqueSemantic resultConsumer(Boolean singleResultExpected) {
        return singleResultExpected != false ? ReactiveListResultsConsumer.UniqueSemantic.ASSERT : ReactiveListResultsConsumer.UniqueSemantic.FILTER;
    }

    private /* synthetic */ Object lambda$load$0(Callback callback, SharedSessionContractImplementor session, Object entity) {
        this.invokeAfterLoadActions(callback, session, entity);
        return entity;
    }
}

