/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.loader.ast.internal;

import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.ast.internal.MultiKeyLoadHelper;
import org.hibernate.loader.ast.spi.BatchLoaderFactory;
import org.hibernate.loader.ast.spi.CollectionBatchLoader;
import org.hibernate.loader.ast.spi.EntityBatchLoader;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.reactive.loader.ast.internal.ReactiveCollectionBatchLoaderArrayParam;
import org.hibernate.reactive.loader.ast.internal.ReactiveCollectionBatchLoaderInPredicate;
import org.hibernate.reactive.loader.ast.internal.ReactiveEntityBatchLoaderArrayParam;
import org.hibernate.reactive.loader.ast.internal.ReactiveEntityBatchLoaderInPredicate;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;

public class ReactiveStandardBatchLoaderFactory
implements BatchLoaderFactory {
    public <T> EntityBatchLoader<T> createEntityBatchLoader(int domainBatchSize, EntityMappingType entityDescriptor, LoadQueryInfluencers loadQueryInfluencers) {
        SessionFactoryImplementor factory = loadQueryInfluencers.getSessionFactory();
        Dialect dialect = factory.getJdbcServices().getDialect();
        Type identifierType = entityDescriptor.getEntityPersister().getIdentifierType();
        int idColumnCount = identifierType.getColumnSpan((Mapping)factory);
        if (idColumnCount == 1 && MultiKeyLoadHelper.supportsSqlArrayType((Dialect)dialect) && identifierType instanceof BasicType) {
            return new ReactiveEntityBatchLoaderArrayParam(domainBatchSize, entityDescriptor, factory);
        }
        int optimalBatchSize = dialect.getBatchLoadSizingStrategy().determineOptimalBatchLoadSize(idColumnCount, domainBatchSize, false);
        return new ReactiveEntityBatchLoaderInPredicate(domainBatchSize, optimalBatchSize, entityDescriptor, factory);
    }

    public CollectionBatchLoader createCollectionBatchLoader(int domainBatchSize, LoadQueryInfluencers influencers, PluralAttributeMapping attributeMapping, SessionFactoryImplementor factory) {
        Dialect dialect = factory.getJdbcServices().getDialect();
        int columnCount = attributeMapping.getKeyDescriptor().getJdbcTypeCount();
        if (columnCount == 1 && dialect.supportsStandardArrays() && dialect.getPreferredSqlTypeCodeForArray() == 2003) {
            return new ReactiveCollectionBatchLoaderArrayParam(domainBatchSize, influencers, attributeMapping, factory);
        }
        return new ReactiveCollectionBatchLoaderInPredicate(domainBatchSize, influencers, attributeMapping, factory);
    }
}

