/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.metamodel.mapping.internal;

import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.metamodel.mapping.AssociationKey;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.PluralAttributeMappingImpl;
import org.hibernate.metamodel.mapping.internal.SimpleForeignKeyDescriptor;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.reactive.sql.results.graph.collection.internal.ReactiveCollectionDomainResult;
import org.hibernate.reactive.sql.results.graph.collection.internal.ReactiveEagerCollectionFetch;
import org.hibernate.reactive.sql.results.graph.embeddable.internal.ReactiveEmbeddableForeignKeyResultImpl;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableForeignKeyResultImpl;
import org.hibernate.type.descriptor.java.JavaType;

public class ReactivePluralAttributeMapping
extends PluralAttributeMappingImpl
implements PluralAttributeMapping {
    public ReactivePluralAttributeMapping(PluralAttributeMappingImpl original) {
        super(original);
    }

    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        TableGroup collectionTableGroup = creationState.getSqlAstCreationState().getFromClauseAccess().getTableGroup(navigablePath);
        assert (collectionTableGroup != null);
        creationState.registerVisitedAssociationKey(this.getKeyDescriptor().getAssociationKey());
        return new ReactiveCollectionDomainResult(navigablePath, this, resultVariable, tableGroup, creationState);
    }

    protected Fetch buildEagerCollectionFetch(NavigablePath fetchedPath, PluralAttributeMapping fetchedAttribute, TableGroup collectionTableGroup, boolean needsCollectionKeyResult, FetchParent fetchParent, DomainResultCreationState creationState) {
        return new ReactiveEagerCollectionFetch(fetchedPath, fetchedAttribute, collectionTableGroup, needsCollectionKeyResult, fetchParent, creationState);
    }

    public ForeignKeyDescriptor getKeyDescriptor() {
        if (!super.getKeyDescriptor().isEmbedded()) {
            return new ReactiveSimpleForeignKeyDescriptor((SimpleForeignKeyDescriptor)super.getKeyDescriptor());
        }
        return new ReactiveForeignKeyDescriptor(super.getKeyDescriptor());
    }

    private static DomainResult<?> convert(DomainResult<?> keyDomainResult) {
        if (keyDomainResult instanceof EmbeddableForeignKeyResultImpl) {
            return new ReactiveEmbeddableForeignKeyResultImpl((EmbeddableForeignKeyResultImpl)keyDomainResult);
        }
        return keyDomainResult;
    }

    private static class ReactiveForeignKeyDescriptor
    implements ForeignKeyDescriptor {
        private final ForeignKeyDescriptor delegate;

        public ReactiveForeignKeyDescriptor(ForeignKeyDescriptor delegate) {
            this.delegate = delegate;
        }

        public String getPartName() {
            return this.delegate.getPartName();
        }

        public String getKeyTable() {
            return this.delegate.getKeyTable();
        }

        public String getTargetTable() {
            return this.delegate.getTargetTable();
        }

        public ValuedModelPart getKeyPart() {
            return this.delegate.getKeyPart();
        }

        public ValuedModelPart getTargetPart() {
            return this.delegate.getTargetPart();
        }

        public boolean isKeyPart(ValuedModelPart modelPart) {
            return this.delegate.isKeyPart(modelPart);
        }

        public ValuedModelPart getPart(ForeignKeyDescriptor.Nature nature) {
            return this.delegate.getPart(nature);
        }

        public ForeignKeyDescriptor.Side getKeySide() {
            return this.delegate.getKeySide();
        }

        public ForeignKeyDescriptor.Side getTargetSide() {
            return this.delegate.getTargetSide();
        }

        public ForeignKeyDescriptor.Side getSide(ForeignKeyDescriptor.Nature nature) {
            return this.delegate.getSide(nature);
        }

        public String getContainingTableExpression() {
            return this.delegate.getContainingTableExpression();
        }

        public int compare(Object key1, Object key2) {
            return this.delegate.compare(key1, key2);
        }

        public DomainResult<?> createKeyDomainResult(NavigablePath navigablePath, TableGroup targetTableGroup, FetchParent fetchParent, DomainResultCreationState creationState) {
            return ReactivePluralAttributeMapping.convert(this.delegate.createKeyDomainResult(navigablePath, targetTableGroup, fetchParent, creationState));
        }

        public DomainResult<?> createKeyDomainResult(NavigablePath navigablePath, TableGroup targetTableGroup, ForeignKeyDescriptor.Nature fromSide, FetchParent fetchParent, DomainResultCreationState creationState) {
            return ReactivePluralAttributeMapping.convert(this.delegate.createKeyDomainResult(navigablePath, targetTableGroup, fromSide, fetchParent, creationState));
        }

        public DomainResult<?> createTargetDomainResult(NavigablePath navigablePath, TableGroup targetTableGroup, FetchParent fetchParent, DomainResultCreationState creationState) {
            return this.delegate.createTargetDomainResult(navigablePath, targetTableGroup, fetchParent, creationState);
        }

        public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup targetTableGroup, String resultVariable, DomainResultCreationState creationState) {
            return this.delegate.createDomainResult(navigablePath, targetTableGroup, resultVariable, creationState);
        }

        public Predicate generateJoinPredicate(TableGroup targetSideTableGroup, TableGroup keySideTableGroup, SqlAstCreationState creationState) {
            return this.delegate.generateJoinPredicate(targetSideTableGroup, keySideTableGroup, creationState);
        }

        public Predicate generateJoinPredicate(TableReference targetSideReference, TableReference keySideReference, SqlAstCreationState creationState) {
            return this.delegate.generateJoinPredicate(targetSideReference, keySideReference, creationState);
        }

        public boolean isSimpleJoinPredicate(Predicate predicate) {
            return this.delegate.isSimpleJoinPredicate(predicate);
        }

        public SelectableMapping getSelectable(int columnIndex) {
            return this.delegate.getSelectable(columnIndex);
        }

        public int forEachSelectable(int offset, SelectableConsumer consumer) {
            return this.delegate.forEachSelectable(offset, consumer);
        }

        public Object getAssociationKeyFromSide(Object targetObject, ForeignKeyDescriptor.Nature nature, SharedSessionContractImplementor session) {
            return this.delegate.getAssociationKeyFromSide(targetObject, nature, session);
        }

        public Object getAssociationKeyFromSide(Object targetObject, ForeignKeyDescriptor.Side side, SharedSessionContractImplementor session) {
            return this.delegate.getAssociationKeyFromSide(targetObject, side, session);
        }

        public int visitKeySelectables(int offset, SelectableConsumer consumer) {
            return this.delegate.visitKeySelectables(offset, consumer);
        }

        public int visitKeySelectables(SelectableConsumer consumer) {
            return this.delegate.visitKeySelectables(consumer);
        }

        public int visitTargetSelectables(int offset, SelectableConsumer consumer) {
            return this.delegate.visitTargetSelectables(offset, consumer);
        }

        public int visitTargetSelectables(SelectableConsumer consumer) {
            return this.delegate.visitTargetSelectables(consumer);
        }

        public ForeignKeyDescriptor withKeySelectionMapping(ManagedMappingType declaringType, TableGroupProducer declaringTableGroupProducer, IntFunction<SelectableMapping> selectableMappingAccess, MappingModelCreationProcess creationProcess) {
            return this.delegate.withKeySelectionMapping(declaringType, declaringTableGroupProducer, selectableMappingAccess, creationProcess);
        }

        public ForeignKeyDescriptor withTargetPart(ValuedModelPart targetPart) {
            return this.delegate.withTargetPart(targetPart);
        }

        public AssociationKey getAssociationKey() {
            return this.delegate.getAssociationKey();
        }

        public boolean hasConstraint() {
            return this.delegate.hasConstraint();
        }

        public boolean isEmbedded() {
            return this.delegate.isEmbedded();
        }

        public boolean isVirtual() {
            return this.delegate.isVirtual();
        }

        public NavigableRole getNavigableRole() {
            return this.delegate.getNavigableRole();
        }

        public MappingType getPartMappingType() {
            return this.delegate.getPartMappingType();
        }

        public JavaType<?> getJavaType() {
            return this.delegate.getJavaType();
        }

        public boolean isEntityIdentifierMapping() {
            return this.delegate.isEntityIdentifierMapping();
        }

        public boolean hasPartitionedSelectionMapping() {
            return this.delegate.hasPartitionedSelectionMapping();
        }

        public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
            this.delegate.applySqlSelections(navigablePath, tableGroup, creationState);
        }

        public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
            this.delegate.applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer);
        }

        public int forEachSelectable(SelectableConsumer consumer) {
            return this.delegate.forEachSelectable(consumer);
        }

        public AttributeMapping asAttributeMapping() {
            return this.delegate.asAttributeMapping();
        }

        public EntityMappingType asEntityMappingType() {
            return this.delegate.asEntityMappingType();
        }

        public BasicValuedModelPart asBasicValuedModelPart() {
            return this.delegate.asBasicValuedModelPart();
        }

        public int breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
            return this.delegate.breakDownJdbcValues(domainValue, valueConsumer, session);
        }

        public <X, Y> int breakDownJdbcValues(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
            return this.delegate.breakDownJdbcValues(domainValue, offset, x, y, valueConsumer, session);
        }

        public int decompose(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
            return this.delegate.decompose(domainValue, valueConsumer, session);
        }

        public <X, Y> int decompose(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
            return this.delegate.decompose(domainValue, offset, x, y, valueConsumer, session);
        }

        public EntityMappingType findContainingEntityMapping() {
            return this.delegate.findContainingEntityMapping();
        }

        public boolean areEqual(Object one, Object other, SharedSessionContractImplementor session) {
            return this.delegate.areEqual(one, other, session);
        }

        public int getJdbcTypeCount() {
            return this.delegate.getJdbcTypeCount();
        }

        public int forEachJdbcType(IndexedConsumer<JdbcMapping> action) {
            return this.delegate.forEachJdbcType(action);
        }

        public Object disassemble(Object value, SharedSessionContractImplementor session) {
            return this.delegate.disassemble(value, session);
        }

        public void addToCacheKey(MutableCacheKeyBuilder cacheKey, Object value, SharedSessionContractImplementor session) {
            this.delegate.addToCacheKey(cacheKey, value, session);
        }

        public <X, Y> int forEachDisassembledJdbcValue(Object value, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
            return this.delegate.forEachDisassembledJdbcValue(value, x, y, valuesConsumer, session);
        }

        public <X, Y> int forEachDisassembledJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
            return this.delegate.forEachDisassembledJdbcValue(value, offset, x, y, valuesConsumer, session);
        }

        public int forEachDisassembledJdbcValue(Object value, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
            return this.delegate.forEachDisassembledJdbcValue(value, valuesConsumer, session);
        }

        public int forEachDisassembledJdbcValue(Object value, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
            return this.delegate.forEachDisassembledJdbcValue(value, offset, valuesConsumer, session);
        }

        public <X, Y> int forEachJdbcValue(Object value, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
            return this.delegate.forEachJdbcValue(value, x, y, valuesConsumer, session);
        }

        public <X, Y> int forEachJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
            return this.delegate.forEachJdbcValue(value, offset, x, y, valuesConsumer, session);
        }

        public int forEachJdbcValue(Object value, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
            return this.delegate.forEachJdbcValue(value, valuesConsumer, session);
        }

        public int forEachJdbcValue(Object value, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
            return this.delegate.forEachJdbcValue(value, offset, valuesConsumer, session);
        }

        public JdbcMapping getJdbcMapping(int index) {
            return this.delegate.getJdbcMapping(index);
        }

        public JdbcMapping getSingleJdbcMapping() {
            return this.delegate.getSingleJdbcMapping();
        }

        public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
            return this.delegate.forEachJdbcType(offset, action);
        }

        public void forEachInsertable(SelectableConsumer consumer) {
            this.delegate.forEachInsertable(consumer);
        }

        public void forEachNonFormula(SelectableConsumer consumer) {
            this.delegate.forEachNonFormula(consumer);
        }

        public void forEachUpdatable(SelectableConsumer consumer) {
            this.delegate.forEachUpdatable(consumer);
        }

        public MappingType getMappedType() {
            return this.delegate.getMappedType();
        }

        public JavaType<?> getExpressibleJavaType() {
            return this.delegate.getExpressibleJavaType();
        }

        public <X> X treatAs(Class<X> targetType) {
            return (X)this.delegate.treatAs(targetType);
        }
    }

    private static class ReactiveSimpleForeignKeyDescriptor
    extends SimpleForeignKeyDescriptor {
        protected ReactiveSimpleForeignKeyDescriptor(SimpleForeignKeyDescriptor original) {
            super(original);
        }

        public DomainResult<?> createKeyDomainResult(NavigablePath navigablePath, TableGroup targetTableGroup, FetchParent fetchParent, DomainResultCreationState creationState) {
            return ReactivePluralAttributeMapping.convert(super.createKeyDomainResult(navigablePath, targetTableGroup, fetchParent, creationState));
        }

        public DomainResult<?> createKeyDomainResult(NavigablePath navigablePath, TableGroup targetTableGroup, ForeignKeyDescriptor.Nature fromSide, FetchParent fetchParent, DomainResultCreationState creationState) {
            return ReactivePluralAttributeMapping.convert(super.createKeyDomainResult(navigablePath, targetTableGroup, fromSide, fetchParent, creationState));
        }
    }
}

