/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.persister.entity.impl;

import java.util.List;
import java.util.concurrent.CompletionStage;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.values.GeneratedValues;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.loader.ast.internal.NoCallbackExecutionContext;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.reactive.sql.exec.internal.StandardReactiveSelectExecutor;
import org.hibernate.reactive.sql.results.spi.ReactiveListResultsConsumer;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;

class ReactiveGeneratedValuesProcessor {
    private final SelectStatement selectStatement;
    private final List<AttributeMapping> generatedValuesToSelect;
    private final JdbcParametersList jdbcParameters;
    private final JdbcOperationQuerySelect jdbcSelect;
    private final EntityMappingType entityDescriptor;

    ReactiveGeneratedValuesProcessor(SelectStatement selectStatement, JdbcOperationQuerySelect jdbcSelect, List<AttributeMapping> generatedValuesToSelect, JdbcParametersList jdbcParameters, EntityMappingType entityDescriptor) {
        this.selectStatement = selectStatement;
        this.jdbcSelect = jdbcSelect;
        this.generatedValuesToSelect = generatedValuesToSelect;
        this.jdbcParameters = jdbcParameters;
        this.entityDescriptor = entityDescriptor;
    }

    CompletionStage<Void> processGeneratedValues(Object id, Object entity, Object[] state, GeneratedValues generatedValues, SharedSessionContractImplementor session) {
        if (this.hasActualGeneratedValuesToSelect(session, entity)) {
            if (this.selectStatement != null) {
                return this.executeSelect(id, session).thenAccept(l -> {
                    assert (l.size() == 1);
                    this.setEntityAttributes(entity, state, (Object[])l.get(0));
                });
            }
            NullnessUtil.castNonNull((Object)generatedValues);
            List results = generatedValues.getGeneratedValues(this.generatedValuesToSelect);
            this.setEntityAttributes(entity, state, results.toArray(new Object[0]));
            return CompletionStages.voidFuture();
        }
        return CompletionStages.voidFuture();
    }

    private CompletionStage<List<Object[]>> executeSelect(Object id, SharedSessionContractImplementor session) {
        return StandardReactiveSelectExecutor.INSTANCE.list(this.jdbcSelect, this.getJdbcParameterBindings(id, session), (ExecutionContext)new NoCallbackExecutionContext(session), r -> r, ReactiveListResultsConsumer.UniqueSemantic.FILTER);
    }

    private boolean hasActualGeneratedValuesToSelect(SharedSessionContractImplementor session, Object entity) {
        for (AttributeMapping attributeMapping : this.generatedValuesToSelect) {
            if (!attributeMapping.getGenerator().generatedOnExecution(entity, session)) continue;
            return true;
        }
        return false;
    }

    private JdbcParameterBindings getJdbcParameterBindings(Object id, SharedSessionContractImplementor session) {
        JdbcParameterBindingsImpl jdbcParamBindings = new JdbcParameterBindingsImpl(this.jdbcParameters.size());
        int offset = jdbcParamBindings.registerParametersForEachJdbcValue(id, (Bindable)this.entityDescriptor.getIdentifierMapping(), this.jdbcParameters, session);
        assert (offset == this.jdbcParameters.size());
        return jdbcParamBindings;
    }

    private void setEntityAttributes(Object entity, Object[] state, Object[] selectionResults) {
        for (int i = 0; i < this.generatedValuesToSelect.size(); ++i) {
            Object generatedValue;
            AttributeMapping attribute = this.generatedValuesToSelect.get(i);
            state[attribute.getStateArrayPosition()] = generatedValue = selectionResults[i];
            attribute.getAttributeMetadata().getPropertyAccess().getSetter().set(entity, generatedValue);
        }
    }
}

