/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.persister.entity.impl;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.mutation.MergeCoordinator;
import org.hibernate.reactive.persister.entity.mutation.ReactiveMergeCoordinator;
import org.hibernate.reactive.persister.entity.mutation.ReactiveScopedUpdateCoordinator;
import org.hibernate.reactive.persister.entity.mutation.ReactiveUpdateCoordinator;
import org.hibernate.reactive.sql.model.ReactiveOptionalTableUpdateOperation;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.ValuesAnalysis;
import org.hibernate.sql.model.ast.MutationGroup;
import org.hibernate.sql.model.ast.TableMutation;
import org.hibernate.sql.model.internal.MutationOperationGroupFactory;
import org.hibernate.sql.model.internal.OptionalTableUpdate;
import org.hibernate.sql.model.jdbc.OptionalTableUpdateOperation;

public class ReactiveMergeCoordinatorStandardScopeFactory
extends MergeCoordinator
implements ReactiveUpdateCoordinator {
    public ReactiveMergeCoordinatorStandardScopeFactory(AbstractEntityPersister entityPersister, SessionFactoryImplementor factory) {
        super(entityPersister, factory);
    }

    @Override
    public ReactiveScopedUpdateCoordinator makeScopedCoordinator() {
        return new ReactiveMergeCoordinator(this.entityPersister(), this.factory(), this.getStaticMutationOperationGroup(), this.getBatchKey(), this.getVersionUpdateGroup(), this.getVersionUpdateBatchkey());
    }

    protected MutationOperationGroup createOperationGroup(ValuesAnalysis valuesAnalysis, MutationGroup mutationGroup) {
        int numberOfTableMutations = mutationGroup.getNumberOfTableMutations();
        switch (numberOfTableMutations) {
            case 0: {
                return MutationOperationGroupFactory.noOperations((MutationGroup)mutationGroup);
            }
            case 1: {
                MutationOperation operation = this.createOperation(valuesAnalysis, mutationGroup.getSingleTableMutation());
                return operation == null ? MutationOperationGroupFactory.noOperations((MutationGroup)mutationGroup) : MutationOperationGroupFactory.singleOperation((MutationGroup)mutationGroup, (MutationOperation)operation);
            }
        }
        MutationOperation[] operations = new MutationOperation[numberOfTableMutations];
        int outputIndex = 0;
        int skipped = 0;
        for (int i = 0; i < mutationGroup.getNumberOfTableMutations(); ++i) {
            TableMutation tableMutation = mutationGroup.getTableMutation(i);
            MutationOperation operation = this.createOperation(valuesAnalysis, tableMutation);
            if (operation != null) {
                operations[outputIndex++] = operation;
                continue;
            }
            ++skipped;
            ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Skipping table update - %s", (Object)tableMutation.getTableName());
        }
        if (skipped != 0) {
            MutationOperation[] trimmed = new MutationOperation[outputIndex];
            System.arraycopy(operations, 0, trimmed, 0, outputIndex);
            operations = trimmed;
        }
        return MutationOperationGroupFactory.manyOperations((MutationType)mutationGroup.getMutationType(), (MutationTarget)this.entityPersister, (MutationOperation[])operations);
    }

    protected MutationOperation createOperation(ValuesAnalysis valuesAnalysis, TableMutation<?> singleTableMutation) {
        MutationOperation operation = singleTableMutation.createMutationOperation(valuesAnalysis, this.factory());
        if (operation instanceof OptionalTableUpdateOperation) {
            return new ReactiveOptionalTableUpdateOperation(operation.getMutationTarget(), (OptionalTableUpdate)singleTableMutation, this.factory());
        }
        return operation;
    }
}

