/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.persister.entity.mutation;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.MutationExecutor;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.mutation.internal.ModelMutationHelper;
import org.hibernate.engine.jdbc.mutation.spi.MutationExecutorService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.mutation.DeleteCoordinatorSoft;
import org.hibernate.persister.entity.mutation.EntityTableMapping;
import org.hibernate.reactive.adaptor.impl.PrepareStatementDetailsAdaptor;
import org.hibernate.reactive.adaptor.impl.PreparedStatementAdaptor;
import org.hibernate.reactive.engine.jdbc.env.internal.ReactiveMutationExecutor;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.persister.entity.mutation.ReactiveAbstractDeleteCoordinator;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.MutationTarget;

public class ReactiveDeleteCoordinatorSoft
extends DeleteCoordinatorSoft
implements ReactiveAbstractDeleteCoordinator {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private CompletionStage<Void> stage;

    public ReactiveDeleteCoordinatorSoft(AbstractEntityPersister entityPersister, SessionFactoryImplementor factory) {
        super(entityPersister, factory);
    }

    public void delete(Object entity, Object id, Object version, SharedSessionContractImplementor session) {
        throw LOG.nonReactiveMethodCall("coordinateReactiveDelete");
    }

    @Override
    public CompletionStage<Void> reactiveDelete(Object entity, Object id, Object version, SharedSessionContractImplementor session) {
        try {
            super.delete(entity, id, version, session);
            return this.stage != null ? this.stage : CompletionStages.voidFuture();
        }
        catch (Throwable t) {
            if (this.stage == null) {
                return CompletionStages.failedFuture(t);
            }
            this.stage.toCompletableFuture().completeExceptionally(t);
            return this.stage;
        }
    }

    protected void doDynamicDelete(Object entity, Object id, Object rowId, Object[] loadedState, SharedSessionContractImplementor session) {
        this.stage = new CompletableFuture<Void>();
        MutationOperationGroup operationGroup = this.generateOperationGroup(null, loadedState, true, session);
        ReactiveMutationExecutor mutationExecutor = this.mutationExecutor(session, operationGroup);
        for (int i = 0; i < operationGroup.getNumberOfOperations(); ++i) {
            MutationOperation mutation = operationGroup.getOperation(i);
            if (mutation == null) continue;
            String tableName = mutation.getTableDetails().getTableName();
            mutationExecutor.getPreparedStatementDetails(tableName);
        }
        this.applyDynamicDeleteTableDetails(id, rowId, loadedState, mutationExecutor, operationGroup, session);
        mutationExecutor.executeReactive(entity, null, null, (statementDetails, affectedRowCount, batchPosition) -> ModelMutationHelper.identifiedResultsCheck((PreparedStatementDetails)statementDetails, (int)affectedRowCount, (int)batchPosition, (MutationTarget)this.entityPersister(), (Object)id, (SessionFactoryImplementor)this.factory()), session).whenComplete((o, t) -> mutationExecutor.release()).whenComplete(this::complete);
    }

    protected void applyId(Object id, Object rowId, MutationExecutor mutationExecutor, MutationOperationGroup operationGroup, SharedSessionContractImplementor session) {
        JdbcValueBindings jdbcValueBindings = mutationExecutor.getJdbcValueBindings();
        for (int position = 0; position < operationGroup.getNumberOfOperations(); ++position) {
            MutationOperation jdbcMutation = operationGroup.getOperation(position);
            EntityTableMapping tableDetails = (EntityTableMapping)jdbcMutation.getTableDetails();
            this.breakDownKeyJdbcValues(id, rowId, session, jdbcValueBindings, tableDetails);
            PreparedStatementDetails statementDetails = mutationExecutor.getPreparedStatementDetails(tableDetails.getTableName());
            if (statementDetails == null) continue;
            PreparedStatementAdaptor.bind(statement -> {
                PrepareStatementDetailsAdaptor detailsAdaptor = new PrepareStatementDetailsAdaptor(statementDetails, statement, session.getJdbcServices());
                detailsAdaptor.resolveStatement();
            });
        }
    }

    protected void doStaticDelete(Object entity, Object id, Object rowId, Object[] loadedState, Object version, SharedSessionContractImplementor session) {
        this.stage = new CompletableFuture<Void>();
        boolean applyVersion = entity != null;
        MutationOperationGroup operationGroupToUse = entity == null ? this.resolveNoVersionDeleteGroup(session) : this.getStaticMutationOperationGroup();
        ReactiveMutationExecutor mutationExecutor = this.mutationExecutor(session, operationGroupToUse);
        for (int position = 0; position < this.getStaticMutationOperationGroup().getNumberOfOperations(); ++position) {
            MutationOperation mutation = this.getStaticMutationOperationGroup().getOperation(position);
            if (mutation == null) continue;
            mutationExecutor.getPreparedStatementDetails(mutation.getTableDetails().getTableName());
        }
        if (applyVersion) {
            this.applyLocking(version, null, mutationExecutor, session);
        }
        JdbcValueBindings jdbcValueBindings = mutationExecutor.getJdbcValueBindings();
        this.bindPartitionColumnValueBindings(loadedState, session, jdbcValueBindings);
        this.applyId(id, rowId, mutationExecutor, this.getStaticMutationOperationGroup(), session);
        mutationExecutor.executeReactive(entity, null, null, (statementDetails, affectedRowCount, batchPosition) -> ModelMutationHelper.identifiedResultsCheck((PreparedStatementDetails)statementDetails, (int)affectedRowCount, (int)batchPosition, (MutationTarget)this.entityPersister(), (Object)id, (SessionFactoryImplementor)this.factory()), session).thenAccept(v -> mutationExecutor.release()).whenComplete(this::complete);
    }

    private void complete(Object o, Throwable throwable) {
        if (throwable != null) {
            this.stage.toCompletableFuture().completeExceptionally(throwable);
        } else {
            this.stage.toCompletableFuture().complete(null);
        }
    }

    private ReactiveMutationExecutor mutationExecutor(SharedSessionContractImplementor session, MutationOperationGroup operationGroup) {
        MutationExecutorService mutationExecutorService = (MutationExecutorService)session.getFactory().getServiceRegistry().getService(MutationExecutorService.class);
        return (ReactiveMutationExecutor)mutationExecutorService.createExecutor(() -> ((ReactiveDeleteCoordinatorSoft)this).getBatchKey(), operationGroup, session);
    }
}

