/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.pool.impl;

import java.util.function.IntConsumer;
import org.hibernate.dialect.CockroachDialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DialectDelegateWrapper;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.reactive.pool.impl.PostgresParameters;
import org.hibernate.reactive.pool.impl.SQLServerParameters;

public abstract class Parameters {
    private final String paramPrefix;
    private static final Parameters NO_PARSING = new Parameters(null){

        @Override
        public String process(String sql) {
            return sql;
        }

        @Override
        public String process(String sql, int parameterCount) {
            return sql;
        }
    };

    protected Parameters(String paramPrefix) {
        this.paramPrefix = paramPrefix;
    }

    public static Parameters instance(Dialect dialect) {
        if (dialect instanceof DialectDelegateWrapper) {
            dialect = ((DialectDelegateWrapper)dialect).getWrappedDialect();
        }
        if (dialect instanceof PostgreSQLDialect || dialect instanceof CockroachDialect) {
            return PostgresParameters.INSTANCE;
        }
        if (dialect instanceof SQLServerDialect) {
            return SQLServerParameters.INSTANCE;
        }
        return NO_PARSING;
    }

    public static boolean isProcessingNotRequired(String sql) {
        return sql == null || sql.indexOf(63) == -1;
    }

    public String process(String sql) {
        if (Parameters.isProcessingNotRequired(sql)) {
            return sql;
        }
        return new Parser(sql, this.paramPrefix).result();
    }

    public String process(String sql, int parameterCount) {
        if (Parameters.isProcessingNotRequired(sql)) {
            return sql;
        }
        return new Parser(sql, parameterCount, this.paramPrefix).result();
    }

    private static class Parser {
        private boolean inString;
        private boolean inQuoted;
        private boolean inSqlComment;
        private boolean inCComment;
        private boolean escaped;
        private int count = 0;
        private StringBuilder result;
        private int previous;

        private Parser(String sql, String paramPrefix) {
            this(sql, 10, paramPrefix);
        }

        private Parser(String sql, int parameterCount, final String paramPrefix) {
            this.result = new StringBuilder(sql.length() + parameterCount);
            sql.codePoints().forEach(new IntConsumer(){

                @Override
                public void accept(int codePoint) {
                    if (escaped) {
                        escaped = false;
                    } else {
                        switch (codePoint) {
                            case 92: {
                                escaped = true;
                                return;
                            }
                            case 34: {
                                if (inString || inSqlComment || inCComment) break;
                                inQuoted = !inQuoted;
                                break;
                            }
                            case 39: {
                                if (inQuoted || inSqlComment || inCComment) break;
                                inString = !inString;
                                break;
                            }
                            case 45: {
                                if (inQuoted || inString || inCComment || previous != 45) break;
                                inSqlComment = true;
                                break;
                            }
                            case 10: {
                                inSqlComment = false;
                                break;
                            }
                            case 42: {
                                if (inQuoted || inString || inSqlComment || previous != 47) break;
                                inCComment = true;
                                break;
                            }
                            case 47: {
                                if (previous != 42) break;
                                inCComment = false;
                                break;
                            }
                            case 63: {
                                if (inQuoted || inString) break;
                                result.append(paramPrefix).append(++count);
                                previous = 63;
                                return;
                            }
                        }
                    }
                    previous = codePoint;
                    result.appendCodePoint(codePoint);
                }
            });
        }

        public String result() {
            return this.result.toString();
        }
    }
}

