/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.pool.impl;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.sqlclient.DatabaseException;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PrepareOptions;
import io.vertx.sqlclient.PropertyKind;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowIterator;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.Transaction;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.spi.DatabaseMetadata;
import java.lang.invoke.MethodHandles;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.reactive.adaptor.impl.JdbcNull;
import org.hibernate.reactive.adaptor.impl.ResultSetAdaptor;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.pool.BatchingConnection;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.util.impl.CompletionStages;

public class SqlClientConnection
implements ReactiveConnection {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private static final PropertyKind<Long> MYSQL_LAST_INSERTED_ID = PropertyKind.create((String)"last-inserted-id", Long.class);
    private static final PropertyKind<Row> ORACLE_GENERATED_KEYS = PropertyKind.create((String)"generated-keys", Row.class);
    private final SqlStatementLogger sqlStatementLogger;
    private final SqlExceptionHelper sqlExceptionHelper;
    private final Pool pool;
    private final SqlConnection connection;
    private Transaction transaction;

    SqlClientConnection(SqlConnection connection, Pool pool, SqlStatementLogger sqlStatementLogger, SqlExceptionHelper sqlExceptionHelper) {
        this.pool = pool;
        this.sqlStatementLogger = sqlStatementLogger;
        this.connection = connection;
        this.sqlExceptionHelper = sqlExceptionHelper;
        LOG.tracef("Connection created: %s", connection);
    }

    @Override
    public DatabaseMetadata getDatabaseMetadata() {
        return this.client().databaseMetadata();
    }

    @Override
    public CompletionStage<Integer> update(String sql, Object[] paramValues) {
        SqlClientConnection.translateNulls(paramValues);
        return this.update(sql, Tuple.wrap((Object[])paramValues));
    }

    @Override
    public CompletionStage<int[]> update(String sql, List<Object[]> batchParamValues) {
        ArrayList<Tuple> tuples = new ArrayList<Tuple>(batchParamValues.size());
        for (Object[] paramValues : batchParamValues) {
            SqlClientConnection.translateNulls(paramValues);
            tuples.add(Tuple.wrap((Object[])paramValues));
        }
        return this.updateBatch(sql, tuples);
    }

    @Override
    public CompletionStage<Void> update(String sql, Object[] paramValues, boolean allowBatching, ReactiveConnection.Expectation expectation) {
        return this.update(sql, paramValues).thenAccept(rowCount -> expectation.verifyOutcome((int)rowCount, -1, sql));
    }

    @Override
    public <T> CompletionStage<T> selectIdentifier(String sql, Object[] paramValues, Class<T> idClass) {
        SqlClientConnection.translateNulls(paramValues);
        return this.preparedQuery(sql, Tuple.wrap((Object[])paramValues)).handle((rows, throwable) -> this.convertException((Object)rows, sql, (Throwable)throwable)).thenApply(rowSet -> {
            RowIterator rowIterator = rowSet.iterator();
            if (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                return row.get(idClass, 0);
            }
            return null;
        });
    }

    @Override
    public CompletionStage<ReactiveConnection.Result> select(String sql) {
        return this.preparedQuery(sql).thenApply(RowSetResult::new);
    }

    @Override
    public CompletionStage<ReactiveConnection.Result> select(String sql, Object[] paramValues) {
        SqlClientConnection.translateNulls(paramValues);
        return this.preparedQuery(sql, Tuple.wrap((Object[])paramValues)).thenApply(RowSetResult::new);
    }

    @Override
    public CompletionStage<ResultSet> selectJdbc(String sql, Object[] paramValues) {
        SqlClientConnection.translateNulls(paramValues);
        return this.preparedQuery(sql, Tuple.wrap((Object[])paramValues)).thenApply(ResultSetAdaptor::new);
    }

    @Override
    public CompletionStage<Void> execute(String sql) {
        return this.preparedQuery(sql).thenCompose(CompletionStages::voidFuture);
    }

    @Override
    public CompletionStage<Void> executeUnprepared(String sql) {
        this.feedback(sql);
        return this.client().query(sql).execute().toCompletionStage().handle((rows, throwable) -> this.convertException((Object)rows, sql, (Throwable)throwable)).thenCompose(CompletionStages::voidFuture);
    }

    private <T> T convertException(T rows, String sql, Throwable sqlException) {
        if (sqlException == null) {
            return rows;
        }
        if (sqlException instanceof DatabaseException) {
            DatabaseException de = (DatabaseException)sqlException;
            sqlException = this.sqlExceptionHelper.convert(new SQLException(de.getMessage(), de.getSqlState(), de.getErrorCode()), "error executing SQL statement", sql);
        }
        return (T)CompletionStages.rethrow(sqlException);
    }

    @Override
    public CompletionStage<Void> executeOutsideTransaction(String sql) {
        return this.preparedQueryOutsideTransaction(sql).thenApply(ignore -> null);
    }

    @Override
    public CompletionStage<Integer> update(String sql) {
        return this.preparedQuery(sql).thenApply(SqlResult::rowCount);
    }

    public CompletionStage<Integer> update(String sql, Tuple parameters) {
        return this.preparedQuery(sql, parameters).thenApply(SqlResult::rowCount);
    }

    public CompletionStage<int[]> updateBatch(String sql, List<Tuple> parametersBatch) {
        return this.preparedQueryBatch(sql, parametersBatch).thenApply(result -> {
            int[] updateCounts = new int[parametersBatch.size()];
            int i = 0;
            RowSet resultNext = result;
            if (!parametersBatch.isEmpty()) {
                RowIterator iterator = resultNext.iterator();
                if (iterator.hasNext()) {
                    while (iterator.hasNext()) {
                        updateCounts[i++] = ((Row)iterator.next()).getInteger(0);
                    }
                    resultNext = null;
                } else {
                    do {
                        updateCounts[i++] = result.rowCount();
                    } while ((resultNext = resultNext.next()) != null && i < parametersBatch.size());
                }
            }
            if (resultNext != null || i != parametersBatch.size()) {
                throw LOG.numberOfResultsGreaterThanBatchedParameters();
            }
            return updateCounts;
        });
    }

    @Override
    public <T> CompletionStage<T> insertAndSelectIdentifier(String sql, Object[] paramValues, Class<T> idClass, String idColumnName) {
        SqlClientConnection.translateNulls(paramValues);
        return this.insertAndSelectIdentifier(sql, Tuple.wrap((Object[])paramValues), idClass, idColumnName);
    }

    @Override
    public CompletionStage<ResultSet> insertAndSelectIdentifierAsResultSet(String sql, Object[] parameters, Class<?> idClass, String idColumnName) {
        JsonObject options = new JsonObject().put("autoGeneratedKeysIndexes", (Object)new JsonArray().add((Object)idColumnName));
        SqlClientConnection.translateNulls(parameters);
        return this.preparedQuery(sql, Tuple.wrap((Object[])parameters), new PrepareOptions(options)).thenApply(rows -> {
            RowIterator iterator = rows.iterator();
            return iterator.hasNext() ? new ResultSetAdaptor((RowSet<Row>)rows) : SqlClientConnection.getLastInsertedIdAsResultSet((RowSet<Row>)rows, idClass, idColumnName);
        });
    }

    public <T> CompletionStage<T> insertAndSelectIdentifier(String sql, Tuple parameters, Class<T> idClass, String idColumnName) {
        JsonObject options = new JsonObject().put("autoGeneratedKeysIndexes", (Object)new JsonArray().add((Object)idColumnName));
        return this.preparedQuery(sql, parameters, new PrepareOptions(options)).thenApply(rows -> {
            RowIterator iterator = rows.iterator();
            return iterator.hasNext() ? ((Row)iterator.next()).get(idClass, 0) : SqlClientConnection.getLastInsertedId((RowSet<Row>)rows, idClass, idColumnName);
        });
    }

    public CompletionStage<RowSet<Row>> preparedQuery(String sql, Tuple parameters) {
        this.feedback(sql);
        return this.client().preparedQuery(sql).execute(parameters).toCompletionStage().handle((rows, throwable) -> this.convertException((Object)rows, sql, (Throwable)throwable));
    }

    public CompletionStage<RowSet<Row>> preparedQuery(String sql, Tuple parameters, PrepareOptions options) {
        this.feedback(sql);
        return this.client().preparedQuery(sql, options).execute(parameters).toCompletionStage().handle((rows, throwable) -> this.convertException((Object)rows, sql, (Throwable)throwable));
    }

    public CompletionStage<RowSet<Row>> preparedQueryBatch(String sql, List<Tuple> parameters) {
        this.feedback(sql);
        return this.client().preparedQuery(sql).executeBatch(parameters).toCompletionStage().handle((rows, throwable) -> this.convertException((Object)rows, sql, (Throwable)throwable));
    }

    public CompletionStage<RowSet<Row>> preparedQuery(String sql) {
        this.feedback(sql);
        return this.client().preparedQuery(sql).execute().toCompletionStage().handle((rows, throwable) -> this.convertException((Object)rows, sql, (Throwable)throwable));
    }

    public CompletionStage<RowSet<Row>> preparedQueryOutsideTransaction(String sql) {
        this.feedback(sql);
        return this.pool.preparedQuery(sql).execute().toCompletionStage().handle((rows, throwable) -> this.convertException((Object)rows, sql, (Throwable)throwable));
    }

    private void feedback(String sql) {
        Objects.requireNonNull(sql, "SQL query cannot be null");
        FormatStyle formatStyle = this.sqlStatementLogger.isFormat() && !sql.contains(System.lineSeparator()) ? FormatStyle.BASIC : FormatStyle.NONE;
        this.sqlStatementLogger.logStatement(sql, formatStyle.getFormatter());
    }

    private SqlConnection client() {
        return this.connection;
    }

    @Override
    public CompletionStage<Void> beginTransaction() {
        return this.connection.begin().onSuccess(tx -> LOG.tracef("Transaction started: %s", tx)).toCompletionStage().thenAccept(this::setTransaction);
    }

    @Override
    public CompletionStage<Void> commitTransaction() {
        return this.transaction.commit().onSuccess(v -> LOG.tracef("Transaction committed: %s", this.transaction)).toCompletionStage().whenComplete(this::clearTransaction);
    }

    @Override
    public CompletionStage<Void> rollbackTransaction() {
        return this.transaction.rollback().onSuccess(v -> LOG.tracef("Transaction rolled back: %s", this.transaction)).toCompletionStage().whenComplete(this::clearTransaction);
    }

    @Override
    public CompletionStage<Void> close() {
        return this.connection.close().onSuccess(event -> LOG.tracef("Connection closed: %s", this.connection)).toCompletionStage();
    }

    private static <T> T getLastInsertedId(RowSet<Row> rows, Class<T> idClass, String idColumnName) {
        Long mySqlId = (Long)rows.property(MYSQL_LAST_INSERTED_ID);
        if (mySqlId != null) {
            if (Long.class.equals(idClass)) {
                return (T)mySqlId;
            }
            if (Integer.class.equals(idClass)) {
                return (T)Integer.valueOf(mySqlId.intValue());
            }
            throw LOG.nativelyGeneratedValueMustBeLong();
        }
        Row oracleKeys = (Row)rows.property(ORACLE_GENERATED_KEYS);
        if (oracleKeys != null) {
            return (T)oracleKeys.get(idClass, idColumnName);
        }
        return null;
    }

    private static ResultSet getLastInsertedIdAsResultSet(RowSet<Row> rows, Class<?> idClass, String idColumnName) {
        Long mySqlId = (Long)rows.property(MYSQL_LAST_INSERTED_ID);
        if (mySqlId != null) {
            if (Long.class.equals(idClass)) {
                return new ResultSetAdaptor(rows, List.of(mySqlId), idColumnName, Long.class);
            }
            if (Integer.class.equals(idClass)) {
                return new ResultSetAdaptor(rows, List.of(Integer.valueOf(mySqlId.intValue())), idColumnName, Integer.class);
            }
            throw LOG.nativelyGeneratedValueMustBeLong();
        }
        Row oracleKeys = (Row)rows.property(ORACLE_GENERATED_KEYS);
        if (oracleKeys != null) {
            return new ResultSetAdaptor(rows, ORACLE_GENERATED_KEYS, idColumnName, idClass);
        }
        return null;
    }

    private void setTransaction(Transaction tx) {
        this.transaction = tx;
    }

    private void clearTransaction(Void v, Throwable x) {
        this.transaction = null;
    }

    @Override
    public ReactiveConnection withBatchSize(int batchSize) {
        return batchSize <= 1 ? this : new BatchingConnection(this, batchSize);
    }

    @Override
    public CompletionStage<Void> executeBatch() {
        return CompletionStages.voidFuture();
    }

    private static void translateNulls(Object[] paramValues) {
        for (int i = 0; i < paramValues.length; ++i) {
            Object arg = paramValues[i];
            if (!(arg instanceof JdbcNull)) continue;
            paramValues[i] = ((JdbcNull)arg).toNullValue();
        }
    }

    private static class RowSetResult
    implements ReactiveConnection.Result {
        private final RowSet<Row> rowset;
        private final RowIterator<Row> it;

        public RowSetResult(RowSet<Row> rowset) {
            this.rowset = rowset;
            this.it = rowset.iterator();
        }

        @Override
        public int size() {
            return this.rowset.size();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Object[] next() {
            Row row = (Row)this.it.next();
            Object[] result = new Object[row.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = row.getValue(i);
            }
            return result;
        }
    }
}

