/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.pool.impl;

import io.vertx.core.Future;
import io.vertx.sqlclient.DatabaseException;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.Tuple;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.reactive.adaptor.impl.ResultSetAdaptor;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.pool.ReactiveConnectionPool;
import org.hibernate.reactive.pool.impl.SqlClientConnection;
import org.hibernate.reactive.util.impl.CompletionStages;

public abstract class SqlClientPool
implements ReactiveConnectionPool {
    protected abstract Pool getPool();

    protected abstract SqlStatementLogger getSqlStatementLogger();

    protected abstract SqlExceptionHelper getSqlExceptionHelper();

    protected Pool getTenantPool(String tenantId) {
        throw new UnsupportedOperationException("multitenancy not supported by built-in SqlClientPool");
    }

    @Override
    public CompletionStage<ReactiveConnection> getConnection() {
        return this.getConnectionFromPool(this.getPool());
    }

    @Override
    public CompletionStage<ReactiveConnection> getConnection(SqlExceptionHelper sqlExceptionHelper) {
        return this.getConnectionFromPool(this.getPool(), sqlExceptionHelper);
    }

    @Override
    public CompletionStage<ReactiveConnection> getConnection(String tenantId) {
        return this.getConnectionFromPool(this.getTenantPool(tenantId));
    }

    @Override
    public CompletionStage<ReactiveConnection> getConnection(String tenantId, SqlExceptionHelper sqlExceptionHelper) {
        return this.getConnectionFromPool(this.getTenantPool(tenantId), sqlExceptionHelper);
    }

    private CompletionStage<ReactiveConnection> getConnectionFromPool(Pool pool) {
        return this.completionStage(pool.getConnection().map(this::newConnection), ReactiveConnection::close);
    }

    private CompletionStage<ReactiveConnection> getConnectionFromPool(Pool pool, SqlExceptionHelper sqlExceptionHelper) {
        return this.completionStage(pool.getConnection().map(sqlConnection -> this.newConnection((SqlConnection)sqlConnection, sqlExceptionHelper)), ReactiveConnection::close);
    }

    @Override
    public CompletionStage<ResultSet> selectJdbcOutsideTransaction(String sql, Object[] paramValues) {
        return this.preparedQueryOutsideTransaction(sql, Tuple.wrap((Object[])paramValues)).thenApply(ResultSetAdaptor::new);
    }

    private CompletionStage<RowSet<Row>> preparedQueryOutsideTransaction(String sql, Tuple parameters) {
        this.feedback(sql);
        return this.getPool().preparedQuery(sql).execute(parameters).toCompletionStage().handle((rows, throwable) -> this.convertException((Object)rows, sql, (Throwable)throwable));
    }

    private <T> T convertException(T rows, String sql, Throwable sqlException) {
        if (sqlException == null) {
            return rows;
        }
        if (sqlException instanceof DatabaseException) {
            DatabaseException de = (DatabaseException)sqlException;
            sqlException = this.getSqlExceptionHelper().convert(new SQLException(de.getMessage(), de.getSqlState(), de.getErrorCode()), "error executing SQL statement", sql);
        }
        return (T)CompletionStages.rethrow(sqlException);
    }

    private void feedback(String sql) {
        Objects.requireNonNull(sql, "SQL query cannot be null");
        FormatStyle formatStyle = this.getSqlStatementLogger().isFormat() && !sql.contains(System.lineSeparator()) ? FormatStyle.BASIC : FormatStyle.NONE;
        this.getSqlStatementLogger().logStatement(sql, formatStyle.getFormatter());
    }

    private <T> CompletionStage<T> completionStage(Future<T> future, Consumer<T> onCancellation) {
        CompletableFuture completableFuture = new CompletableFuture();
        future.onComplete(ar -> {
            if (ar.succeeded()) {
                if (completableFuture.isCancelled()) {
                    onCancellation.accept(ar.result());
                }
                completableFuture.complete(ar.result());
            } else {
                completableFuture.completeExceptionally(ar.cause());
            }
        });
        return completableFuture;
    }

    private SqlClientConnection newConnection(SqlConnection connection) {
        return this.newConnection(connection, this.getSqlExceptionHelper());
    }

    private SqlClientConnection newConnection(SqlConnection connection, SqlExceptionHelper sqlExceptionHelper) {
        return new SqlClientConnection(connection, this.getPool(), this.getSqlStatementLogger(), sqlExceptionHelper);
    }
}

