/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.provider.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.reactive.event.impl.DefaultReactiveAutoFlushEventListener;
import org.hibernate.reactive.event.impl.DefaultReactiveDeleteEventListener;
import org.hibernate.reactive.event.impl.DefaultReactiveFlushEntityEventListener;
import org.hibernate.reactive.event.impl.DefaultReactiveFlushEventListener;
import org.hibernate.reactive.event.impl.DefaultReactiveInitializeCollectionEventListener;
import org.hibernate.reactive.event.impl.DefaultReactiveLoadEventListener;
import org.hibernate.reactive.event.impl.DefaultReactiveLockEventListener;
import org.hibernate.reactive.event.impl.DefaultReactiveMergeEventListener;
import org.hibernate.reactive.event.impl.DefaultReactivePersistEventListener;
import org.hibernate.reactive.event.impl.DefaultReactivePersistOnFlushEventListener;
import org.hibernate.reactive.event.impl.DefaultReactivePostLoadEventListener;
import org.hibernate.reactive.event.impl.DefaultReactiveRefreshEventListener;
import org.hibernate.reactive.event.impl.DefaultReactiveResolveNaturalIdEventListener;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.provider.impl.ReactiveModeCheck;
import org.hibernate.reactive.provider.impl.ReplacementDuplicationStrategy;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

public class ReactiveIntegrator
implements Integrator {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());

    public void integrate(Metadata metadata, BootstrapContext bootstrapContext, SessionFactoryImplementor sessionFactory) {
        this.attachEventContextManagingListenersIfRequired((ServiceRegistry)sessionFactory.getServiceRegistry());
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }

    private void attachEventContextManagingListenersIfRequired(ServiceRegistry serviceRegistry) {
        if (ReactiveModeCheck.isReactiveRegistry(serviceRegistry)) {
            LOG.startHibernateReactive();
            EventListenerRegistry eventListenerRegistry = (EventListenerRegistry)serviceRegistry.getService(EventListenerRegistry.class);
            eventListenerRegistry.addDuplicationStrategy(ReplacementDuplicationStrategy.INSTANCE);
            eventListenerRegistry.getEventListenerGroup(EventType.AUTO_FLUSH).appendListener((Object)new DefaultReactiveAutoFlushEventListener());
            eventListenerRegistry.getEventListenerGroup(EventType.FLUSH).appendListener((Object)new DefaultReactiveFlushEventListener());
            eventListenerRegistry.getEventListenerGroup(EventType.FLUSH_ENTITY).appendListener((Object)new DefaultReactiveFlushEntityEventListener());
            eventListenerRegistry.getEventListenerGroup(EventType.PERSIST).appendListener((Object)new DefaultReactivePersistEventListener());
            eventListenerRegistry.getEventListenerGroup(EventType.PERSIST_ONFLUSH).appendListener((Object)new DefaultReactivePersistOnFlushEventListener());
            eventListenerRegistry.getEventListenerGroup(EventType.MERGE).appendListener((Object)new DefaultReactiveMergeEventListener());
            eventListenerRegistry.getEventListenerGroup(EventType.DELETE).appendListener((Object)new DefaultReactiveDeleteEventListener());
            eventListenerRegistry.getEventListenerGroup(EventType.REFRESH).appendListener((Object)new DefaultReactiveRefreshEventListener());
            eventListenerRegistry.getEventListenerGroup(EventType.LOCK).appendListener((Object)new DefaultReactiveLockEventListener());
            eventListenerRegistry.getEventListenerGroup(EventType.LOAD).appendListener((Object)new DefaultReactiveLoadEventListener());
            eventListenerRegistry.getEventListenerGroup(EventType.INIT_COLLECTION).appendListener((Object)new DefaultReactiveInitializeCollectionEventListener());
            eventListenerRegistry.getEventListenerGroup(EventType.POST_LOAD).appendListener((Object)new DefaultReactivePostLoadEventListener());
            eventListenerRegistry.getEventListenerGroup(EventType.RESOLVE_NATURAL_ID).appendListener((Object)new DefaultReactiveResolveNaturalIdEventListener());
        }
    }
}

