/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.query.sql.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.hibernate.action.internal.BulkOperationCleanupAction;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sql.internal.SQLQueryParser;
import org.hibernate.query.sql.spi.ParameterOccurrence;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.reactive.engine.spi.ReactiveSharedSessionContractImplementor;
import org.hibernate.reactive.query.sql.spi.ReactiveNonSelectQueryPlan;
import org.hibernate.reactive.sql.exec.internal.StandardReactiveJdbcMutationExecutor;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQueryMutation;
import org.hibernate.sql.exec.spi.JdbcOperationQueryMutationNative;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class ReactiveNativeNonSelectQueryPlan
implements ReactiveNonSelectQueryPlan {
    private final String sql;
    private final Set<String> affectedTableNames;
    private final List<ParameterOccurrence> parameterList;

    public ReactiveNativeNonSelectQueryPlan(String sql, Set<String> affectedTableNames, List<ParameterOccurrence> parameterList) {
        this.sql = sql;
        this.affectedTableNames = affectedTableNames;
        this.parameterList = parameterList;
    }

    @Override
    public CompletionStage<Integer> executeReactiveUpdate(DomainQueryExecutionContext executionContext) {
        ReactiveSharedSessionContractImplementor reactiveSession = (ReactiveSharedSessionContractImplementor)executionContext.getSession();
        return reactiveSession.reactiveAutoFlushIfRequired(this.affectedTableNames).thenCompose(aBoolean -> {
            JdbcParameterBindings jdbcParameterBindings;
            List jdbcParameterBinders;
            SharedSessionContractImplementor session = executionContext.getSession();
            BulkOperationCleanupAction.schedule((SharedSessionContractImplementor)session, this.affectedTableNames);
            QueryParameterBindings queryParameterBindings = executionContext.getQueryParameterBindings();
            if (this.parameterList == null || this.parameterList.isEmpty()) {
                jdbcParameterBinders = Collections.emptyList();
                jdbcParameterBindings = JdbcParameterBindings.NO_BINDINGS;
            } else {
                jdbcParameterBinders = new ArrayList(this.parameterList.size());
                jdbcParameterBindings = new JdbcParameterBindingsImpl(queryParameterBindings, this.parameterList, jdbcParameterBinders, session.getFactory());
            }
            SQLQueryParser parser = new SQLQueryParser(this.sql, null, session.getFactory());
            JdbcOperationQueryMutationNative jdbcMutation = new JdbcOperationQueryMutationNative(parser.process(), jdbcParameterBinders, this.affectedTableNames);
            return StandardReactiveJdbcMutationExecutor.INSTANCE.executeReactive((JdbcOperationQueryMutation)jdbcMutation, jdbcParameterBindings, sql -> session.getJdbcCoordinator().getStatementPreparer().prepareStatement(sql), (integer, preparedStatement) -> {}, (ExecutionContext)SqmJdbcExecutionContextAdapter.usingLockingAndPaging((DomainQueryExecutionContext)executionContext));
        });
    }
}

