/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.query.sql.internal;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Parameter;
import jakarta.persistence.TemporalType;
import jakarta.persistence.metamodel.SingularAttribute;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.AbstractSharedSessionContract;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.query.BindableType;
import org.hibernate.query.Order;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.named.NamedResultSetMappingMemento;
import org.hibernate.query.spi.AbstractSelectionQuery;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.NonSelectQueryPlan;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.sql.internal.NativeQueryImpl;
import org.hibernate.query.sql.spi.NamedNativeQueryMemento;
import org.hibernate.query.sql.spi.NonSelectInterpretationsKey;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.query.spi.ReactiveAbstractSelectionQuery;
import org.hibernate.reactive.query.sql.internal.ReactiveNativeNonSelectQueryPlan;
import org.hibernate.reactive.query.sql.spi.ReactiveNativeQueryImplementor;
import org.hibernate.reactive.query.sql.spi.ReactiveNonSelectQueryPlan;
import org.hibernate.reactive.query.sqm.spi.ReactiveSelectQueryPlan;
import org.hibernate.type.BasicTypeReference;

public class ReactiveNativeQueryImpl<R>
extends NativeQueryImpl<R>
implements ReactiveNativeQueryImplementor<R> {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final ReactiveAbstractSelectionQuery<R> selectionQueryDelegate;

    public ReactiveNativeQueryImpl(String memento, SharedSessionContractImplementor session) {
        super(memento, session);
        this.selectionQueryDelegate = this.createSelectionQueryDelegate(session);
    }

    public ReactiveNativeQueryImpl(NamedNativeQueryMemento memento, SharedSessionContractImplementor session) {
        super(memento, session);
        this.selectionQueryDelegate = this.createSelectionQueryDelegate(session);
    }

    public ReactiveNativeQueryImpl(NamedNativeQueryMemento memento, Class<R> resultJavaType, SharedSessionContractImplementor session) {
        super(memento, resultJavaType, session);
        this.selectionQueryDelegate = this.createSelectionQueryDelegate(session);
    }

    public ReactiveNativeQueryImpl(NamedNativeQueryMemento memento, String resultSetMappingName, SharedSessionContractImplementor session) {
        super(memento, resultSetMappingName, session);
        this.selectionQueryDelegate = this.createSelectionQueryDelegate(session);
    }

    public ReactiveNativeQueryImpl(String sqlString, NamedResultSetMappingMemento resultSetMappingMemento, AbstractSharedSessionContract session) {
        super(sqlString, resultSetMappingMemento, session);
        this.selectionQueryDelegate = this.createSelectionQueryDelegate((SharedSessionContractImplementor)session);
    }

    private <T> T getNull() {
        return null;
    }

    public long getResultCount() {
        throw LOG.nonReactiveMethodCall("getReactiveResultCount()");
    }

    @Override
    public CompletionStage<Long> getReactiveResultCount() {
        throw LOG.notYetImplemented();
    }

    private ReactiveAbstractSelectionQuery<R> createSelectionQueryDelegate(SharedSessionContractImplementor session) {
        return new ReactiveAbstractSelectionQuery<Object>(() -> ((ReactiveNativeQueryImpl)this).getQueryOptions(), session, this::doReactiveList, this::getNull, this::getNull, this::getNull, this::getNull, () -> ((ReactiveNativeQueryImpl)this).getQueryString(), () -> ((ReactiveNativeQueryImpl)this).beforeQuery(), arg_0 -> ((ReactiveNativeQueryImpl)this).afterQuery(arg_0), AbstractSelectionQuery::uniqueElement, null);
    }

    private CompletionStage<List<R>> doReactiveList() {
        return this.reactiveSelectPlan().reactivePerformList((DomainQueryExecutionContext)this);
    }

    private ReactiveSelectQueryPlan<R> reactiveSelectPlan() {
        return (ReactiveSelectQueryPlan)this.resolveSelectQueryPlan();
    }

    private ReactiveNonSelectQueryPlan reactiveNonSelectPlan() {
        NonSelectQueryPlan queryPlan;
        NonSelectInterpretationsKey cacheKey = this.generateNonSelectInterpretationsKey();
        if (cacheKey != null && (queryPlan = this.getSession().getFactory().getQueryEngine().getInterpretationCache().getNonSelectQueryPlan((QueryInterpretationCache.Key)cacheKey)) != null) {
            return (ReactiveNonSelectQueryPlan)queryPlan;
        }
        String sqlString = this.expandParameterLists();
        ReactiveNativeNonSelectQueryPlan queryPlan2 = new ReactiveNativeNonSelectQueryPlan(sqlString, this.getQuerySpaces(), this.getParameterOccurrences());
        if (cacheKey != null) {
            this.getSession().getFactory().getQueryEngine().getInterpretationCache().cacheNonSelectQueryPlan((QueryInterpretationCache.Key)cacheKey, (NonSelectQueryPlan)queryPlan2);
        }
        return queryPlan2;
    }

    private Set<String> getQuerySpaces() {
        return new HashSet<String>(this.getSynchronizedQuerySpaces());
    }

    public int executeUpdate() throws HibernateException {
        throw LOG.nonReactiveMethodCall("executeReactiveUpdate");
    }

    @Override
    public CompletionStage<Integer> executeReactiveUpdate() {
        return this.reactiveNonSelectPlan().executeReactiveUpdate((DomainQueryExecutionContext)this);
    }

    public R getSingleResult() {
        return this.selectionQueryDelegate.getSingleResult();
    }

    @Override
    public CompletionStage<R> getReactiveSingleResult() {
        return this.selectionQueryDelegate.getReactiveSingleResult();
    }

    public R getSingleResultOrNull() {
        return this.selectionQueryDelegate.getSingleResultOrNull();
    }

    @Override
    public CompletionStage<R> getReactiveSingleResultOrNull() {
        return this.selectionQueryDelegate.getReactiveSingleResultOrNull();
    }

    @Override
    public CompletionStage<Optional<R>> reactiveUniqueResultOptional() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletionStage<R> reactiveUnique() {
        return this.selectionQueryDelegate.reactiveUnique();
    }

    public List<R> list() {
        return this.selectionQueryDelegate.list();
    }

    @Override
    public CompletionStage<List<R>> reactiveList() {
        return this.selectionQueryDelegate.reactiveList();
    }

    public R uniqueResult() {
        return this.selectionQueryDelegate.uniqueResult();
    }

    public Optional<R> uniqueResultOptional() {
        return this.selectionQueryDelegate.uniqueResultOptional();
    }

    public ReactiveNativeQueryImpl<R> applyGraph(RootGraph graph, GraphSemantic semantic) {
        super.applyGraph(graph, semantic);
        return this;
    }

    public ReactiveNativeQueryImpl<R> applyFetchGraph(RootGraph graph) {
        super.applyFetchGraph(graph);
        return this;
    }

    @Override
    public void addResultTypeClass(Class<?> resultClass) {
        super.addResultTypeClass(resultClass);
    }

    @Override
    public ReactiveNativeQueryImpl<R> addScalar(String columnAlias) {
        super.addScalar(columnAlias);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> addScalar(String columnAlias, BasicDomainType type) {
        super.addScalar(columnAlias, type);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> addScalar(String columnAlias, Class javaType) {
        super.addScalar(columnAlias, javaType);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> addScalar(int position, Class<?> type) {
        super.addScalar(position, type);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> addScalar(String columnAlias, BasicTypeReference type) {
        super.addScalar(columnAlias, type);
        return this;
    }

    @Override
    public <C> ReactiveNativeQueryImpl<R> addScalar(String columnAlias, Class<C> relationalJavaType, AttributeConverter<?, C> converter) {
        super.addScalar(columnAlias, relationalJavaType, converter);
        return this;
    }

    @Override
    public <O, J> ReactiveNativeQueryImpl<R> addScalar(String columnAlias, Class<O> domainJavaType, Class<J> jdbcJavaType, AttributeConverter<O, J> converter) {
        super.addScalar(columnAlias, domainJavaType, jdbcJavaType, converter);
        return this;
    }

    @Override
    public <C> ReactiveNativeQueryImpl<R> addScalar(String columnAlias, Class<C> relationalJavaType, Class<? extends AttributeConverter<?, C>> converter) {
        super.addScalar(columnAlias, relationalJavaType, converter);
        return this;
    }

    @Override
    public <O, J> ReactiveNativeQueryImpl<R> addScalar(String columnAlias, Class<O> domainJavaType, Class<J> jdbcJavaType, Class<? extends AttributeConverter<O, J>> converter) {
        super.addScalar(columnAlias, domainJavaType, jdbcJavaType, converter);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> addAttributeResult(String columnAlias, Class entityJavaType, String attributePath) {
        super.addAttributeResult(columnAlias, entityJavaType, attributePath);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> addAttributeResult(String columnAlias, String entityName, String attributePath) {
        super.addAttributeResult(columnAlias, entityName, attributePath);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> addAttributeResult(String columnAlias, SingularAttribute attribute) {
        super.addAttributeResult(columnAlias, attribute);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> addEntity(String entityName) {
        super.addEntity(entityName);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> addEntity(String tableAlias, String entityName) {
        super.addEntity(tableAlias, entityName);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> addEntity(String tableAlias, String entityName, LockMode lockMode) {
        super.addEntity(tableAlias, entityName, lockMode);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> addEntity(Class entityType) {
        super.addEntity(entityType);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> addEntity(String tableAlias, Class entityType) {
        super.addEntity(tableAlias, entityType);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> addEntity(String tableAlias, Class entityClass, LockMode lockMode) {
        super.addEntity(tableAlias, entityClass, lockMode);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> addJoin(String tableAlias, String path) {
        super.addJoin(tableAlias, path);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> addJoin(String tableAlias, String ownerTableAlias, String joinPropertyName) {
        super.addJoin(tableAlias, ownerTableAlias, joinPropertyName);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> addJoin(String tableAlias, String path, LockMode lockMode) {
        super.addJoin(tableAlias, path, lockMode);
        return this;
    }

    public ReactiveNativeQueryImpl<R> addSynchronizedQuerySpace(String querySpace) {
        super.addSynchronizedQuerySpace(querySpace);
        return this;
    }

    public ReactiveNativeQueryImpl<R> addSynchronizedEntityName(String entityName) {
        super.addSynchronizedEntityName(entityName);
        return this;
    }

    public ReactiveNativeQueryImpl<R> addSynchronizedEntityClass(Class entityClass) {
        super.addSynchronizedEntityClass(entityClass);
        return this;
    }

    public ReactiveNativeQueryImpl<R> applyLoadGraph(RootGraph graph) {
        super.applyLoadGraph(graph);
        return this;
    }

    @Override
    @Deprecated
    public ReactiveNativeQueryImpl<R> setAliasSpecificLockMode(String alias, LockMode lockMode) {
        super.setAliasSpecificLockMode(alias, lockMode);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setHint(String hintName, Object value) {
        super.setHint(hintName, value);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setHibernateFlushMode(FlushMode flushMode) {
        super.setHibernateFlushMode(flushMode);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setFlushMode(FlushModeType flushMode) {
        super.setFlushMode(flushMode);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setFollowOnLocking(boolean enable) {
        super.setFollowOnLocking(enable);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setCacheMode(CacheMode cacheMode) {
        super.setCacheMode(cacheMode);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setCacheable(boolean cacheable) {
        super.setCacheable(cacheable);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setCacheRegion(String cacheRegion) {
        super.setCacheRegion(cacheRegion);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setCacheRetrieveMode(CacheRetrieveMode cacheRetrieveMode) {
        super.setCacheRetrieveMode(cacheRetrieveMode);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setCacheStoreMode(CacheStoreMode cacheStoreMode) {
        super.setCacheStoreMode(cacheStoreMode);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setTimeout(int timeout) {
        super.setTimeout(timeout);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setFetchSize(int fetchSize) {
        super.setFetchSize(fetchSize);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setLockOptions(LockOptions lockOptions) {
        super.setLockOptions(lockOptions);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setHibernateLockMode(LockMode lockMode) {
        super.setHibernateLockMode(lockMode);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setLockMode(LockModeType lockMode) {
        super.setLockMode(lockMode);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setLockMode(String alias, LockMode lockMode) {
        super.setLockMode(alias, lockMode);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setOrder(List<Order<? super R>> orders) {
        super.setOrder(orders);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setOrder(Order<? super R> order) {
        super.setOrder(order);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setComment(String comment) {
        super.setComment(comment);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setMaxResults(int maxResult) {
        super.setMaxResults(maxResult);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setFirstResult(int startPosition) {
        super.setFirstResult(startPosition);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> addQueryHint(String hint) {
        super.addQueryHint(hint);
        return this;
    }

    @Override
    public <T> ReactiveNativeQueryImpl<T> setTupleTransformer(TupleTransformer<T> transformer) {
        super.setTupleTransformer(transformer);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setResultListTransformer(ResultListTransformer<R> transformer) {
        super.setResultListTransformer(transformer);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setParameter(String name, Object val) {
        super.setParameter(name, val);
        return this;
    }

    @Override
    public <P> ReactiveNativeQueryImpl<R> setParameter(String name, P val, BindableType<P> type) {
        super.setParameter(name, val, type);
        return this;
    }

    @Override
    public <P> ReactiveNativeQueryImpl<R> setParameter(String name, P val, Class<P> type) {
        super.setParameter(name, val, type);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setParameter(String name, Instant value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setParameter(String name, Date value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setParameter(String name, Calendar value, TemporalType temporalType) {
        super.setParameter(name, value, temporalType);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setParameter(int position, Object val) {
        super.setParameter(position, val);
        return this;
    }

    @Override
    public <P> ReactiveNativeQueryImpl<R> setParameter(int position, P val, Class<P> type) {
        super.setParameter(position, val, type);
        return this;
    }

    @Override
    public <P> ReactiveNativeQueryImpl<R> setParameter(int position, P val, BindableType<P> type) {
        super.setParameter(position, val, type);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setParameter(int position, Instant value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setParameter(int position, Date value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setParameter(int position, Calendar value, TemporalType temporalType) {
        super.setParameter(position, value, temporalType);
        return this;
    }

    @Override
    public <P> ReactiveNativeQueryImpl<R> setParameter(QueryParameter<P> parameter, P val) {
        super.setParameter(parameter, val);
        return this;
    }

    @Override
    public <P> ReactiveNativeQueryImpl<R> setParameter(QueryParameter<P> parameter, P val, Class<P> type) {
        super.setParameter(parameter, val, type);
        return this;
    }

    @Override
    public <P> ReactiveNativeQueryImpl<R> setParameter(QueryParameter<P> parameter, P val, BindableType<P> type) {
        super.setParameter(parameter, val, type);
        return this;
    }

    @Override
    public <P> ReactiveNativeQueryImpl<R> setParameter(Parameter<P> param, P value) {
        super.setParameter(param, value);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        super.setParameter(param, value, temporalType);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        super.setParameter(param, value, temporalType);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setParameterList(String name, Collection values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public <P> ReactiveNativeQueryImpl<R> setParameterList(String name, Collection<? extends P> values, Class<P> type) {
        super.setParameterList(name, values, type);
        return this;
    }

    @Override
    public <P> ReactiveNativeQueryImpl<R> setParameterList(String name, Collection<? extends P> values, BindableType<P> type) {
        super.setParameterList(name, values, type);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setParameterList(String name, Object[] values) {
        super.setParameterList(name, values);
        return this;
    }

    @Override
    public <P> ReactiveNativeQueryImpl<R> setParameterList(String name, P[] values, Class<P> type) {
        super.setParameterList(name, (Object[])values, type);
        return this;
    }

    @Override
    public <P> ReactiveNativeQueryImpl<R> setParameterList(String name, P[] values, BindableType<P> type) {
        super.setParameterList(name, (Object[])values, type);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setParameterList(int position, Collection values) {
        super.setParameterList(position, values);
        return this;
    }

    @Override
    public <P> ReactiveNativeQueryImpl<R> setParameterList(int position, Collection<? extends P> values, Class<P> type) {
        super.setParameterList(position, values, type);
        return this;
    }

    @Override
    public <P> ReactiveNativeQueryImpl<R> setParameterList(int position, Collection<? extends P> values, BindableType<P> type) {
        super.setParameterList(position, values, type);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setParameterList(int position, Object[] values) {
        super.setParameterList(position, values);
        return this;
    }

    @Override
    public <P> ReactiveNativeQueryImpl<R> setParameterList(int position, P[] values, Class<P> javaType) {
        super.setParameterList(position, (Object[])values, javaType);
        return this;
    }

    @Override
    public <P> ReactiveNativeQueryImpl<R> setParameterList(int position, P[] values, BindableType<P> type) {
        super.setParameterList(position, (Object[])values, type);
        return this;
    }

    @Override
    public <P> ReactiveNativeQueryImpl<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values) {
        super.setParameterList(parameter, values);
        return this;
    }

    @Override
    public <P> ReactiveNativeQueryImpl<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values, Class<P> javaType) {
        super.setParameterList(parameter, values, javaType);
        return this;
    }

    @Override
    public <P> ReactiveNativeQueryImpl<R> setParameterList(QueryParameter<P> parameter, Collection<? extends P> values, BindableType<P> type) {
        super.setParameterList(parameter, values, type);
        return this;
    }

    @Override
    public <P> ReactiveNativeQueryImpl<R> setParameterList(QueryParameter<P> parameter, P[] values) {
        super.setParameterList(parameter, (Object[])values);
        return this;
    }

    @Override
    public <P> ReactiveNativeQueryImpl<R> setParameterList(QueryParameter<P> parameter, P[] values, Class<P> javaType) {
        super.setParameterList(parameter, (Object[])values, javaType);
        return this;
    }

    @Override
    public <P> ReactiveNativeQueryImpl<R> setParameterList(QueryParameter<P> parameter, P[] values, BindableType<P> type) {
        super.setParameterList(parameter, (Object[])values, type);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setProperties(Object bean) {
        super.setProperties(bean);
        return this;
    }

    @Override
    public ReactiveNativeQueryImpl<R> setProperties(Map bean) {
        super.setProperties(bean);
        return this;
    }

    @Override
    public void applyGraph(RootGraphImplementor<?> graph, GraphSemantic semantic) {
        super.applyGraph(graph, semantic);
    }

    @Override
    public ReactiveNativeQueryImpl<R> enableFetchProfile(String profileName) {
        throw new UnsupportedOperationException("A native SQL query cannot use fetch profiles");
    }
}

