/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.query.sqm.internal;

import java.util.concurrent.CompletionStage;
import org.hibernate.action.internal.BulkOperationCleanupAction;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.reactive.query.sql.spi.ReactiveNonSelectQueryPlan;
import org.hibernate.reactive.query.sqm.mutation.spi.ReactiveSqmMultiTableMutationStrategy;

public class ReactiveMultiTableDeleteQueryPlan
implements ReactiveNonSelectQueryPlan {
    private final SqmDeleteStatement<?> sqmDelete;
    private final DomainParameterXref domainParameterXref;
    private final ReactiveSqmMultiTableMutationStrategy deleteStrategy;

    public ReactiveMultiTableDeleteQueryPlan(SqmDeleteStatement<?> sqmDelete, DomainParameterXref domainParameterXref, ReactiveSqmMultiTableMutationStrategy deleteStrategy) {
        this.sqmDelete = sqmDelete;
        this.domainParameterXref = domainParameterXref;
        this.deleteStrategy = deleteStrategy;
    }

    @Override
    public CompletionStage<Integer> executeReactiveUpdate(DomainQueryExecutionContext executionContext) {
        BulkOperationCleanupAction.schedule((SharedSessionContractImplementor)executionContext.getSession(), this.sqmDelete);
        return this.deleteStrategy.reactiveExecuteDelete(this.sqmDelete, this.domainParameterXref, executionContext);
    }
}

