/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.query.sqm.internal;

import java.util.concurrent.CompletionStage;
import org.hibernate.action.internal.BulkOperationCleanupAction;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.reactive.query.sql.spi.ReactiveNonSelectQueryPlan;
import org.hibernate.reactive.query.sqm.mutation.spi.ReactiveSqmMultiTableMutationStrategy;

public class ReactiveMultiTableUpdateQueryPlan
implements ReactiveNonSelectQueryPlan {
    private final SqmUpdateStatement<?> sqmUpdate;
    private final DomainParameterXref domainParameterXref;
    private final ReactiveSqmMultiTableMutationStrategy mutationStrategy;

    public ReactiveMultiTableUpdateQueryPlan(SqmUpdateStatement<?> sqmUpdate, DomainParameterXref domainParameterXref, ReactiveSqmMultiTableMutationStrategy mutationStrategy) {
        this.sqmUpdate = sqmUpdate;
        this.domainParameterXref = domainParameterXref;
        this.mutationStrategy = mutationStrategy;
    }

    @Override
    public CompletionStage<Integer> executeReactiveUpdate(DomainQueryExecutionContext executionContext) {
        BulkOperationCleanupAction.schedule((SharedSessionContractImplementor)executionContext.getSession(), this.sqmUpdate);
        return this.mutationStrategy.reactiveExecuteUpdate(this.sqmUpdate, this.domainParameterXref, executionContext);
    }
}

