/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.query.sqm.mutation.internal;

import java.sql.PreparedStatement;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.StatementPreparer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EmbeddedAttributeMapping;
import org.hibernate.reactive.sql.exec.internal.StandardReactiveJdbcMutationExecutor;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQueryDelete;
import org.hibernate.sql.exec.spi.JdbcOperationQueryMutation;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class ReactiveSqmMutationStrategyHelper {
    private ReactiveSqmMutationStrategyHelper() {
    }

    public static CompletionStage<Void> cleanUpCollectionTables(EntityMappingType entityDescriptor, BiFunction<TableReference, PluralAttributeMapping, Predicate> restrictionProducer, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        if (!entityDescriptor.getEntityPersister().hasCollections()) {
            return CompletionStages.voidFuture();
        }
        CompletableFuture<Void> stage = new CompletableFuture<Void>();
        try {
            entityDescriptor.visitSubTypeAttributeMappings(attributeMapping -> {
                if (attributeMapping instanceof PluralAttributeMapping) {
                    ReactiveSqmMutationStrategyHelper.cleanUpCollectionTable((PluralAttributeMapping)attributeMapping, entityDescriptor, restrictionProducer, jdbcParameterBindings, executionContext).whenComplete((v, throwable) -> ReactiveSqmMutationStrategyHelper.complete(stage, throwable));
                } else if (attributeMapping instanceof EmbeddedAttributeMapping) {
                    ReactiveSqmMutationStrategyHelper.cleanUpCollectionTables((EmbeddedAttributeMapping)attributeMapping, entityDescriptor, restrictionProducer, jdbcParameterBindings, executionContext).whenComplete((v, throwable) -> ReactiveSqmMutationStrategyHelper.complete(stage, throwable));
                } else {
                    ReactiveSqmMutationStrategyHelper.complete(stage, null);
                }
            });
            return stage;
        }
        catch (Throwable throwable) {
            ReactiveSqmMutationStrategyHelper.complete(stage, throwable);
            return stage;
        }
    }

    private static CompletionStage<Void> cleanUpCollectionTables(EmbeddedAttributeMapping attributeMapping, EntityMappingType entityDescriptor, BiFunction<TableReference, PluralAttributeMapping, Predicate> restrictionProducer, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        CompletableFuture<Void> stage = new CompletableFuture<Void>();
        try {
            attributeMapping.visitSubParts(modelPart -> {
                if (modelPart instanceof PluralAttributeMapping) {
                    ReactiveSqmMutationStrategyHelper.cleanUpCollectionTable((PluralAttributeMapping)modelPart, entityDescriptor, restrictionProducer, jdbcParameterBindings, executionContext);
                } else if (modelPart instanceof EmbeddedAttributeMapping) {
                    ReactiveSqmMutationStrategyHelper.cleanUpCollectionTables((EmbeddedAttributeMapping)modelPart, entityDescriptor, restrictionProducer, jdbcParameterBindings, executionContext);
                }
            }, null);
            return stage;
        }
        catch (Throwable throwable) {
            ReactiveSqmMutationStrategyHelper.complete(stage, throwable);
            return stage;
        }
    }

    private static CompletionStage<Void> cleanUpCollectionTable(PluralAttributeMapping attributeMapping, EntityMappingType entityDescriptor, BiFunction<TableReference, PluralAttributeMapping, Predicate> restrictionProducer, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        String separateCollectionTable = attributeMapping.getSeparateCollectionTable();
        if (separateCollectionTable == null) {
            return CompletionStages.voidFuture();
        }
        SessionFactoryImplementor sessionFactory = executionContext.getSession().getFactory();
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        NamedTableReference tableReference = new NamedTableReference(separateCollectionTable, "to_delete_", true);
        DeleteStatement sqlAstDelete = new DeleteStatement(tableReference, restrictionProducer.apply((TableReference)tableReference, attributeMapping));
        JdbcOperationQueryDelete jdbcDelete = (JdbcOperationQueryDelete)jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildDeleteTranslator(sessionFactory, sqlAstDelete).translate(jdbcParameterBindings, executionContext.getQueryOptions());
        return StandardReactiveJdbcMutationExecutor.INSTANCE.executeReactive((JdbcOperationQueryMutation)jdbcDelete, jdbcParameterBindings, arg_0 -> ((StatementPreparer)executionContext.getSession().getJdbcCoordinator().getStatementPreparer()).prepareStatement(arg_0), ReactiveSqmMutationStrategyHelper::doNothing, executionContext).thenCompose(CompletionStages::voidFuture);
    }

    private static void complete(CompletableFuture<Void> stage, Throwable throwable) {
        if (throwable == null) {
            stage.complete(null);
        } else {
            stage.completeExceptionally(throwable);
        }
    }

    private static void doNothing(Integer i, PreparedStatement ps) {
    }
}

