/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.exec.spi;

import java.util.concurrent.CompletionStage;
import org.hibernate.LockMode;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.reactive.sql.exec.spi.ReactiveValuesResultSet;
import org.hibernate.reactive.sql.results.spi.ReactiveRowReader;
import org.hibernate.sql.exec.internal.BaseExecutionContext;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.entity.EntityFetch;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingState;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.sql.results.spi.RowReader;

public class ReactiveRowProcessingState
extends BaseExecutionContext
implements RowProcessingState {
    private final JdbcValuesSourceProcessingStateStandardImpl resultSetProcessingState;
    private final ReactiveRowReader<?> rowReader;
    private final ReactiveValuesResultSet jdbcValues;
    private final ExecutionContext executionContext;
    private final boolean needsResolveState;
    private final InitializerData[] initializerData;

    public ReactiveRowProcessingState(JdbcValuesSourceProcessingStateStandardImpl resultSetProcessingState, ExecutionContext executionContext, ReactiveRowReader<?> rowReader, ReactiveValuesResultSet jdbcValues) {
        super(resultSetProcessingState.getSession());
        this.resultSetProcessingState = resultSetProcessingState;
        this.executionContext = executionContext;
        this.rowReader = rowReader;
        this.jdbcValues = jdbcValues;
        this.needsResolveState = !this.isQueryCacheHit() && this.getQueryOptions().isResultCachingEnabled() == Boolean.TRUE;
        this.initializerData = new InitializerData[rowReader.getInitializerCount()];
    }

    public CompletionStage<Boolean> next() {
        return this.jdbcValues.next();
    }

    public JdbcValuesSourceProcessingState getJdbcValuesSourceProcessingState() {
        return this.resultSetProcessingState;
    }

    public Object getEntityId() {
        return this.executionContext.getEntityId();
    }

    public LockMode determineEffectiveLockMode(String alias) {
        if (this.jdbcValues.usesFollowOnLocking()) {
            return LockMode.NONE;
        }
        LockMode effectiveLockMode = this.resultSetProcessingState.getQueryOptions().getLockOptions().getEffectiveLockMode(alias);
        return effectiveLockMode == LockMode.NONE ? this.jdbcValues.getValuesMapping().determineDefaultLockMode(alias, effectiveLockMode) : effectiveLockMode;
    }

    public boolean needsResolveState() {
        return this.needsResolveState;
    }

    public <T extends InitializerData> T getInitializerData(int initializerId) {
        return (T)this.initializerData[initializerId];
    }

    public void setInitializerData(int initializerId, InitializerData state) {
        this.initializerData[initializerId] = state;
    }

    public RowReader<?> getRowReader() {
        return this.rowReader;
    }

    public Object getJdbcValue(int position) {
        return this.jdbcValues.getCurrentRowValuesArray()[position];
    }

    public void registerNonExists(EntityFetch fetch) {
    }

    public boolean isQueryCacheHit() {
        return false;
    }

    public void finishRowProcessing(boolean wasAdded) {
        this.jdbcValues.finishRowProcessing(this, wasAdded);
    }

    public QueryOptions getQueryOptions() {
        return this.executionContext.getQueryOptions();
    }
}

