/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.model;

import java.lang.invoke.MethodHandles;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.mutation.internal.MutationQueryOptions;
import org.hibernate.engine.jdbc.mutation.internal.PreparedStatementGroupSingleTable;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.persister.entity.mutation.UpdateValuesAnalysis;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.reactive.adaptor.impl.PrepareStatementDetailsAdaptor;
import org.hibernate.reactive.adaptor.impl.PreparedStatementAdaptor;
import org.hibernate.reactive.logging.impl.Log;
import org.hibernate.reactive.logging.impl.LoggerFactory;
import org.hibernate.reactive.pool.ReactiveConnection;
import org.hibernate.reactive.session.ReactiveConnectionSupplier;
import org.hibernate.reactive.sql.model.ReactiveSelfExecutingUpdateOperation;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.PreparableMutationOperation;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ValuesAnalysis;
import org.hibernate.sql.model.ast.MutatingTableReference;
import org.hibernate.sql.model.ast.TableMutation;
import org.hibernate.sql.model.internal.OptionalTableUpdate;
import org.hibernate.sql.model.internal.TableDeleteCustomSql;
import org.hibernate.sql.model.internal.TableDeleteStandard;
import org.hibernate.sql.model.internal.TableInsertCustomSql;
import org.hibernate.sql.model.internal.TableInsertStandard;
import org.hibernate.sql.model.internal.TableUpdateCustomSql;
import org.hibernate.sql.model.internal.TableUpdateStandard;
import org.hibernate.sql.model.jdbc.JdbcDeleteMutation;
import org.hibernate.sql.model.jdbc.JdbcInsertMutation;
import org.hibernate.sql.model.jdbc.JdbcMutationOperation;
import org.hibernate.sql.model.jdbc.OptionalTableUpdateOperation;

public class ReactiveOptionalTableUpdateOperation
extends OptionalTableUpdateOperation
implements ReactiveSelfExecutingUpdateOperation {
    private static final Log LOG = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final OptionalTableUpdate upsert;

    public ReactiveOptionalTableUpdateOperation(MutationTarget<?> mutationTarget, OptionalTableUpdate upsert, SessionFactoryImplementor factory) {
        super(mutationTarget, upsert, factory);
        this.upsert = upsert;
    }

    public void performMutation(JdbcValueBindings jdbcValueBindings, ValuesAnalysis valuesAnalysis, SharedSessionContractImplementor session) {
        throw LOG.nonReactiveMethodCall("performReactiveMutation");
    }

    @Override
    public CompletionStage<Void> performReactiveMutation(JdbcValueBindings jdbcValueBindings, ValuesAnalysis incomingValuesAnalysis, SharedSessionContractImplementor session) {
        UpdateValuesAnalysis valuesAnalysis = (UpdateValuesAnalysis)incomingValuesAnalysis;
        if (!valuesAnalysis.getTablesNeedingUpdate().contains(this.getTableDetails())) {
            return CompletionStages.voidFuture();
        }
        return this.doReactiveMutation(this.getTableDetails(), jdbcValueBindings, valuesAnalysis, session);
    }

    private CompletionStage<Void> doReactiveMutation(TableMapping tableMapping, JdbcValueBindings jdbcValueBindings, UpdateValuesAnalysis valuesAnalysis, SharedSessionContractImplementor session) {
        return CompletionStages.voidFuture().thenCompose(v -> {
            if (this.shouldDelete(valuesAnalysis, tableMapping)) {
                return this.performReactiveDelete(jdbcValueBindings, session);
            }
            return this.performReactiveUpdate(jdbcValueBindings, session).thenCompose(wasUpdated -> {
                if (!wasUpdated.booleanValue()) {
                    ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Upsert update altered no rows - inserting : %s", (Object)tableMapping.getTableName());
                    return this.performReactiveInsert(jdbcValueBindings, session);
                }
                return CompletionStages.voidFuture();
            });
        }).whenComplete((o, throwable) -> jdbcValueBindings.afterStatement(tableMapping));
    }

    private boolean shouldDelete(UpdateValuesAnalysis valuesAnalysis, TableMapping tableMapping) {
        return !valuesAnalysis.getTablesWithNonNullValues().contains(tableMapping) && valuesAnalysis.getTablesWithPreviousNonNullValues().contains(tableMapping);
    }

    private CompletionStage<Void> performReactiveDelete(JdbcValueBindings jdbcValueBindings, SharedSessionContractImplementor session) {
        JdbcDeleteMutation jdbcDelete = this.createJdbcDelete(session);
        PreparedStatementGroupSingleTable statementGroup = new PreparedStatementGroupSingleTable((PreparableMutationOperation)jdbcDelete, session);
        PreparedStatementDetails statementDetails = statementGroup.resolvePreparedStatementDetails(this.getTableDetails().getTableName());
        session.getJdbcServices().getSqlStatementLogger().logStatement(jdbcDelete.getSqlString());
        Object[] params = PreparedStatementAdaptor.bind(statement -> {
            PrepareStatementDetailsAdaptor details = new PrepareStatementDetailsAdaptor(statementDetails, statement, session.getJdbcServices());
            jdbcValueBindings.beforeStatement((PreparedStatementDetails)details);
        });
        ReactiveConnection reactiveConnection = ((ReactiveConnectionSupplier)session).getReactiveConnection();
        return reactiveConnection.update(statementDetails.getSqlString(), params).thenCompose(CompletionStages::voidFuture);
    }

    private CompletionStage<Boolean> performReactiveUpdate(JdbcValueBindings jdbcValueBindings, SharedSessionContractImplementor session) {
        ModelMutationLogging.MODEL_MUTATION_LOGGER.tracef("#performReactiveUpdate(%s)", (Object)this.getTableDetails().getTableName());
        JdbcMutationOperation jdbcUpdate = this.createJdbcUpdate(session);
        PreparedStatementGroupSingleTable statementGroup = new PreparedStatementGroupSingleTable((PreparableMutationOperation)jdbcUpdate, session);
        PreparedStatementDetails statementDetails = statementGroup.resolvePreparedStatementDetails(this.getTableDetails().getTableName());
        Object[] params = PreparedStatementAdaptor.bind(statement -> {
            PrepareStatementDetailsAdaptor details = new PrepareStatementDetailsAdaptor(statementDetails, statement, session.getJdbcServices());
            jdbcValueBindings.beforeStatement((PreparedStatementDetails)details);
        });
        session.getJdbcServices().getSqlStatementLogger().logStatement(statementDetails.getSqlString());
        ReactiveConnection reactiveConnection = ((ReactiveConnectionSupplier)session).getReactiveConnection();
        return reactiveConnection.update(statementDetails.getSqlString(), params).thenApply(rowCount -> {
            if (rowCount == 0) {
                return false;
            }
            try {
                this.upsert.getExpectation().verifyOutcome(rowCount.intValue(), statementDetails.getStatement(), -1, statementDetails.getSqlString());
                return true;
            }
            catch (SQLException e) {
                throw session.getJdbcServices().getSqlExceptionHelper().convert(e, "Unable to execute mutation PreparedStatement against table `" + this.getTableDetails().getTableName() + "`", statementDetails.getSqlString());
            }
        });
    }

    private JdbcMutationOperation createJdbcUpdate(SharedSessionContractImplementor session) {
        MutationTarget mutationTarget = super.getMutationTarget();
        Object tableUpdate = this.getTableDetails().getUpdateDetails() != null && this.getTableDetails().getUpdateDetails().getCustomSql() != null ? new TableUpdateCustomSql(new MutatingTableReference(this.getTableDetails()), mutationTarget, "upsert update for " + mutationTarget.getRolePath(), this.upsert.getValueBindings(), this.upsert.getKeyBindings(), this.upsert.getOptimisticLockBindings(), this.upsert.getParameters()) : new TableUpdateStandard(new MutatingTableReference(this.getTableDetails()), mutationTarget, "upsert update for " + mutationTarget.getRolePath(), this.upsert.getValueBindings(), this.upsert.getKeyBindings(), this.upsert.getOptimisticLockBindings(), this.upsert.getParameters());
        SqlAstTranslator translator = session.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildModelMutationTranslator((TableMutation)tableUpdate, session.getFactory());
        return (JdbcMutationOperation)translator.translate(null, (QueryOptions)MutationQueryOptions.INSTANCE);
    }

    private CompletionStage<Void> performReactiveInsert(JdbcValueBindings jdbcValueBindings, SharedSessionContractImplementor session) {
        JdbcInsertMutation jdbcInsert = this.createJdbcInsert(session);
        PreparedStatementGroupSingleTable statementGroup = new PreparedStatementGroupSingleTable((PreparableMutationOperation)jdbcInsert, session);
        PreparedStatementDetails statementDetails = statementGroup.resolvePreparedStatementDetails(this.getTableDetails().getTableName());
        Object[] params = PreparedStatementAdaptor.bind(statement -> {
            PrepareStatementDetailsAdaptor details = new PrepareStatementDetailsAdaptor(statementDetails, statement, session.getJdbcServices());
            jdbcValueBindings.beforeStatement((PreparedStatementDetails)details);
        });
        ReactiveConnection reactiveConnection = ((ReactiveConnectionSupplier)session).getReactiveConnection();
        return reactiveConnection.update(statementDetails.getSqlString(), params).thenCompose(CompletionStages::voidFuture);
    }

    private JdbcInsertMutation createJdbcInsert(SharedSessionContractImplementor session) {
        Object tableInsert = this.getTableDetails().getInsertDetails() != null && this.getTableDetails().getInsertDetails().getCustomSql() != null ? new TableInsertCustomSql(new MutatingTableReference(this.getTableDetails()), this.getMutationTarget(), CollectionHelper.combine((List)this.upsert.getValueBindings(), (List)this.upsert.getKeyBindings()), this.upsert.getParameters()) : new TableInsertStandard(new MutatingTableReference(this.getTableDetails()), this.getMutationTarget(), CollectionHelper.combine((List)this.upsert.getValueBindings(), (List)this.upsert.getKeyBindings()), Collections.emptyList(), this.upsert.getParameters());
        SessionFactoryImplementor factory = session.getSessionFactory();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = factory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory();
        SqlAstTranslator translator = sqlAstTranslatorFactory.buildModelMutationTranslator((TableMutation)tableInsert, factory);
        return (JdbcInsertMutation)translator.translate(null, (QueryOptions)MutationQueryOptions.INSTANCE);
    }

    private JdbcDeleteMutation createJdbcDelete(SharedSessionContractImplementor session) {
        Object tableDelete = this.getTableDetails().getDeleteDetails() != null && this.getTableDetails().getDeleteDetails().getCustomSql() != null ? new TableDeleteCustomSql(new MutatingTableReference(this.getTableDetails()), this.getMutationTarget(), "upsert delete for " + this.upsert.getMutationTarget().getRolePath(), this.upsert.getKeyBindings(), this.upsert.getOptimisticLockBindings(), this.upsert.getParameters()) : new TableDeleteStandard(new MutatingTableReference(this.getTableDetails()), this.getMutationTarget(), "upsert delete for " + this.getMutationTarget().getRolePath(), this.upsert.getKeyBindings(), this.upsert.getOptimisticLockBindings(), this.upsert.getParameters());
        SessionFactoryImplementor factory = session.getSessionFactory();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = factory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory();
        SqlAstTranslator translator = sqlAstTranslatorFactory.buildModelMutationTranslator((TableMutation)tableDelete, factory);
        return (JdbcDeleteMutation)translator.translate(null, (QueryOptions)MutationQueryOptions.INSTANCE);
    }
}

