/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.results.graph.collection.internal;

import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.reactive.sql.results.graph.entity.internal.ReactiveEntityFetchJoinedImpl;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.collection.CollectionInitializer;
import org.hibernate.sql.results.graph.collection.internal.CollectionDomainResult;
import org.hibernate.sql.results.graph.entity.internal.EntityFetchJoinedImpl;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class ReactiveCollectionDomainResult
extends CollectionDomainResult {
    public ReactiveCollectionDomainResult(NavigablePath loadingPath, PluralAttributeMapping loadingAttribute, String resultVariable, TableGroup tableGroup, DomainResultCreationState creationState) {
        super(loadingPath, loadingAttribute, resultVariable, tableGroup, creationState);
    }

    public Fetch generateFetchableFetch(Fetchable fetchable, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        Fetch fetch = super.generateFetchableFetch(fetchable, fetchablePath, fetchTiming, selected, resultVariable, creationState);
        if (fetch instanceof EntityFetchJoinedImpl) {
            return new ReactiveEntityFetchJoinedImpl((EntityFetchJoinedImpl)fetch);
        }
        return fetch;
    }

    public CollectionInitializer<?> createInitializer(InitializerParent<?> parent, AssemblerCreationState creationState) {
        CollectionInitializer initializer = super.createInitializer(parent, creationState);
        return new ReactiveCollectionInitializerAdapter(initializer);
    }

    public static class ReactiveCollectionInitializerAdapter<T extends InitializerData>
    implements CollectionInitializer<T> {
        private final CollectionInitializer<T> delegate;

        public ReactiveCollectionInitializerAdapter(CollectionInitializer<T> initializer) {
            this.delegate = initializer;
        }

        public NavigablePath getNavigablePath() {
            return this.delegate.getNavigablePath();
        }

        public PluralAttributeMapping getInitializedPart() {
            return this.delegate.getInitializedPart();
        }

        public T getData(RowProcessingState rowProcessingState) {
            return (T)this.delegate.getData(rowProcessingState);
        }

        public void startLoading(RowProcessingState rowProcessingState) {
            this.delegate.startLoading(rowProcessingState);
        }

        public void resolveKey(T data) {
            this.delegate.resolveKey(data);
        }

        public void resolveInstance(T data) {
            this.delegate.resolveInstance(data);
        }

        public void resolveState(T data) {
        }

        public void initializeInstance(T data) {
            this.delegate.initializeInstance(data);
        }

        public void finishUpRow(T data) {
            this.delegate.finishUpRow(data);
        }

        public boolean isPartOfKey() {
            return this.delegate.isPartOfKey();
        }

        public boolean isEager() {
            return this.delegate.isEager();
        }

        public boolean hasLazySubInitializers() {
            return this.delegate.hasLazySubInitializers();
        }

        public boolean isResultInitializer() {
            return this.delegate.isResultInitializer();
        }

        public PersistentCollection<?> getCollectionInstance(T data) {
            return this.delegate.getCollectionInstance(data);
        }
    }
}

