/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.results.graph.entity.internal;

import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import org.hibernate.FetchNotFoundException;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.reactive.persister.entity.impl.ReactiveEntityPersister;
import org.hibernate.reactive.session.impl.ReactiveQueryExecutorLookup;
import org.hibernate.reactive.sql.results.graph.ReactiveInitializer;
import org.hibernate.reactive.sql.results.graph.embeddable.internal.ReactiveEmbeddableForeignKeyResultImpl;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.basic.BasicResultAssembler;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableForeignKeyResultImpl;
import org.hibernate.sql.results.graph.entity.internal.EntityDelayedFetchInitializer;
import org.hibernate.sql.results.graph.entity.internal.EntityInitializerImpl;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.Type;

public class ReactiveEntityDelayedFetchInitializer
extends EntityDelayedFetchInitializer
implements ReactiveInitializer<EntityDelayedFetchInitializer.EntityDelayedFetchInitializerData> {
    private final ToOneAttributeMapping referencedModelPart;

    public ReactiveEntityDelayedFetchInitializer(InitializerParent<?> parent, NavigablePath fetchedNavigable, ToOneAttributeMapping referencedModelPart, boolean selectByUniqueKey, DomainResult<?> keyResult, BasicFetch<?> discriminatorResult, AssemblerCreationState creationState) {
        super(parent, fetchedNavigable, referencedModelPart, selectByUniqueKey, ReactiveEntityDelayedFetchInitializer.convert(keyResult), discriminatorResult, creationState);
        this.referencedModelPart = referencedModelPart;
    }

    private static DomainResult<?> convert(DomainResult<?> keyResult) {
        return keyResult instanceof EmbeddableForeignKeyResultImpl ? new ReactiveEmbeddableForeignKeyResultImpl((EmbeddableForeignKeyResultImpl)keyResult) : keyResult;
    }

    protected InitializerData createInitializerData(RowProcessingState rowProcessingState) {
        return new ReactiveEntityDelayedFetchInitializerData(rowProcessingState);
    }

    @Override
    public CompletionStage<Void> reactiveResolveInstance(EntityDelayedFetchInitializer.EntityDelayedFetchInitializerData initializerData) {
        if (initializerData.getState() != Initializer.State.KEY_RESOLVED) {
            return CompletionStages.voidFuture();
        }
        ReactiveEntityDelayedFetchInitializerData data = (ReactiveEntityDelayedFetchInitializerData)initializerData;
        data.setState(Initializer.State.RESOLVED);
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        data.setEntityIdentifier(this.getIdentifierAssembler().assemble(rowProcessingState));
        CompletionStage<Void> stage = CompletionStages.voidFuture();
        if (data.getEntityIdentifier() == null) {
            data.setInstance(null);
            data.setState(Initializer.State.MISSING);
        } else {
            EntityPersister concreteDescriptor;
            SharedSessionContractImplementor session = rowProcessingState.getSession();
            EntityPersister entityPersister = this.referencedModelPart.getEntityMappingType().getEntityPersister();
            if (this.getDiscriminatorAssembler() != null) {
                concreteDescriptor = EntityInitializerImpl.determineConcreteEntityDescriptor((RowProcessingState)rowProcessingState, (BasicResultAssembler)this.getDiscriminatorAssembler(), (EntityPersister)entityPersister);
                if (concreteDescriptor == null) {
                    if (!this.referencedModelPart.isOptional()) {
                        throw new FetchNotFoundException(entityPersister.getEntityName(), data.getEntityIdentifier());
                    }
                    data.setInstance(null);
                    data.setState(Initializer.State.MISSING);
                    return CompletionStages.voidFuture();
                }
            } else {
                concreteDescriptor = entityPersister;
            }
            PersistenceContext persistenceContext = session.getPersistenceContextInternal();
            if (this.isSelectByUniqueKey()) {
                String uniqueKeyPropertyName = this.referencedModelPart.getReferencedPropertyName();
                Type uniqueKeyPropertyType = uniqueKeyPropertyName == null ? concreteDescriptor.getIdentifierType() : session.getFactory().getReferencedPropertyType(concreteDescriptor.getEntityName(), uniqueKeyPropertyName);
                EntityUniqueKey euk = new EntityUniqueKey(concreteDescriptor.getEntityName(), uniqueKeyPropertyName, data.getEntityIdentifier(), uniqueKeyPropertyType, session.getFactory());
                data.setInstance(persistenceContext.getEntity(euk));
                if (data.getInstance() == null) {
                    if (this.referencedModelPart.isLazy()) {
                        data.setInstance(LazyPropertyInitializer.UNFETCHED_PROPERTY);
                    } else {
                        stage = stage.thenCompose(v -> ((ReactiveEntityPersister)concreteDescriptor).reactiveLoadByUniqueKey(uniqueKeyPropertyName, data.getEntityIdentifier(), session)).thenAccept(arg_0 -> ((ReactiveEntityDelayedFetchInitializerData)data).setInstance(arg_0)).thenAccept(v -> {
                            if (data.getInstance() != null) {
                                persistenceContext.addEntity(euk, data.getInstance());
                            }
                        });
                    }
                }
                stage = stage.thenAccept(v -> {
                    if (data.getInstance() != null) {
                        data.setInstance(persistenceContext.proxyFor(data.getInstance()));
                    }
                });
            } else {
                EntityKey entityKey = new EntityKey(data.getEntityIdentifier(), concreteDescriptor);
                EntityHolder holder = persistenceContext.getEntityHolder(entityKey);
                if (holder != null && holder.getEntity() != null) {
                    data.setInstance(persistenceContext.proxyFor(holder, concreteDescriptor));
                } else if (this.referencedModelPart.isOptional() && this.referencedModelPart.isLazy()) {
                    data.setInstance(LazyPropertyInitializer.UNFETCHED_PROPERTY);
                } else {
                    stage = stage.thenCompose(v -> ReactiveQueryExecutorLookup.extract(session).reactiveInternalLoad(concreteDescriptor.getEntityName(), data.getEntityIdentifier(), false, false).thenAccept(arg_0 -> ((ReactiveEntityDelayedFetchInitializerData)data).setInstance(arg_0)));
                }
                stage = stage.thenAccept(v -> {
                    LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer((Object)data.getInstance());
                    if (lazyInitializer != null) {
                        lazyInitializer.setUnwrap(this.referencedModelPart.isUnwrapProxy() && concreteDescriptor.isInstrumented());
                    }
                });
            }
        }
        return stage;
    }

    @Override
    public CompletionStage<Void> reactiveInitializeInstance(EntityDelayedFetchInitializer.EntityDelayedFetchInitializerData data) {
        return CompletionStages.voidFuture();
    }

    @Override
    public CompletionStage<Void> forEachReactiveSubInitializer(BiFunction<ReactiveInitializer<?>, RowProcessingState, CompletionStage<Void>> consumer, InitializerData data) {
        ReactiveInitializer initializer = (ReactiveInitializer)this.getIdentifierAssembler().getInitializer();
        if (initializer != null) {
            return consumer.apply(initializer, data.getRowProcessingState());
        }
        return CompletionStages.voidFuture();
    }

    @Override
    public Object getResolvedInstance(EntityDelayedFetchInitializer.EntityDelayedFetchInitializerData data) {
        return super.getResolvedInstance((InitializerData)data);
    }

    public static class ReactiveEntityDelayedFetchInitializerData
    extends EntityDelayedFetchInitializer.EntityDelayedFetchInitializerData {
        public ReactiveEntityDelayedFetchInitializerData(RowProcessingState rowProcessingState) {
            super(rowProcessingState);
        }

        public Object getEntityIdentifier() {
            return this.entityIdentifier;
        }

        public void setEntityIdentifier(Object entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
        }
    }
}

