/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.results.graph.entity.internal;

import java.util.concurrent.CompletionStage;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.reactive.persister.entity.impl.ReactiveEntityPersister;
import org.hibernate.reactive.sql.results.graph.entity.internal.ReactiveEntitySelectFetchInitializer;
import org.hibernate.reactive.util.impl.CompletionStages;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.entity.internal.EntitySelectFetchInitializer;

public class ReactiveEntitySelectFetchByUniqueKeyInitializer
extends ReactiveEntitySelectFetchInitializer<EntitySelectFetchInitializer.EntitySelectFetchInitializerData> {
    private final ToOneAttributeMapping fetchedAttribute;

    public ReactiveEntitySelectFetchByUniqueKeyInitializer(InitializerParent<?> parent, ToOneAttributeMapping fetchedAttribute, NavigablePath fetchedNavigable, EntityPersister concreteDescriptor, DomainResult<?> keyResult, boolean affectedByFilter, AssemblerCreationState creationState) {
        super(parent, fetchedAttribute, fetchedNavigable, concreteDescriptor, keyResult, affectedByFilter, creationState);
        this.fetchedAttribute = fetchedAttribute;
    }

    @Override
    public CompletionStage<Void> reactiveInitialize(EntitySelectFetchInitializer.EntitySelectFetchInitializerData actual) {
        ReactiveEntitySelectFetchInitializer.ReactiveEntitySelectFetchInitializerData data = (ReactiveEntitySelectFetchInitializer.ReactiveEntitySelectFetchInitializerData)actual;
        String entityName = this.concreteDescriptor.getEntityName();
        String uniqueKeyPropertyName = this.fetchedAttribute.getReferencedPropertyName();
        SharedSessionContractImplementor session = data.getRowProcessingState().getSession();
        EntityUniqueKey euk = new EntityUniqueKey(entityName, uniqueKeyPropertyName, data.getEntityIdentifier(), this.concreteDescriptor.getPropertyType(uniqueKeyPropertyName), session.getFactory());
        PersistenceContext persistenceContext = session.getPersistenceContextInternal();
        data.setInstance(persistenceContext.getEntity(euk));
        if (data.getInstance() == null) {
            return ((ReactiveEntityPersister)this.concreteDescriptor).reactiveLoadByUniqueKey(uniqueKeyPropertyName, data.getEntityIdentifier(), session).thenAccept(arg_0 -> ((ReactiveEntitySelectFetchInitializer.ReactiveEntitySelectFetchInitializerData)data).setInstance(arg_0)).thenAccept(v -> {
                if (data.getInstance() != null) {
                    persistenceContext.addEntity(euk, data.getInstance());
                }
            });
        }
        if (data.getInstance() != null) {
            data.setInstance(persistenceContext.proxyFor(data.getInstance()));
        }
        return CompletionStages.voidFuture();
    }

    @Override
    public Object getResolvedInstance(EntitySelectFetchInitializer.EntitySelectFetchInitializerData data) {
        return super.getResolvedInstance(data);
    }
}

