/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.results.graph.entity.internal;

import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.metamodel.internal.StandardEmbeddableInstantiator;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.reactive.sql.results.graph.embeddable.internal.ReactiveEmbeddableForeignKeyResultImpl;
import org.hibernate.reactive.sql.results.graph.entity.internal.ReactiveEntitySelectFetchByUniqueKeyInitializer;
import org.hibernate.reactive.sql.results.graph.entity.internal.ReactiveEntitySelectFetchInitializer;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.embeddable.EmbeddableInitializer;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableForeignKeyResultImpl;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.internal.BatchEntityInsideEmbeddableSelectFetchInitializer;
import org.hibernate.sql.results.graph.entity.internal.BatchEntitySelectFetchInitializer;
import org.hibernate.sql.results.graph.entity.internal.BatchInitializeEntitySelectFetchInitializer;

public class ReactiveEntitySelectFetchInitializerBuilder {
    public static EntityInitializer<?> createInitializer(InitializerParent<?> parent, ToOneAttributeMapping fetchedAttribute, EntityPersister entityPersister, DomainResult<?> originalKeyResult, NavigablePath navigablePath, boolean selectByUniqueKey, boolean affectedByFilter, AssemblerCreationState creationState) {
        Object keyResult;
        Object object = keyResult = originalKeyResult instanceof EmbeddableForeignKeyResultImpl ? new ReactiveEmbeddableForeignKeyResultImpl((EmbeddableForeignKeyResultImpl)originalKeyResult) : originalKeyResult;
        if (selectByUniqueKey) {
            return new ReactiveEntitySelectFetchByUniqueKeyInitializer(parent, fetchedAttribute, navigablePath, entityPersister, (DomainResult<?>)keyResult, affectedByFilter, creationState);
        }
        BatchMode batchMode = ReactiveEntitySelectFetchInitializerBuilder.determineBatchMode(entityPersister, parent, creationState);
        switch (batchMode) {
            case NONE: {
                return new ReactiveEntitySelectFetchInitializer(parent, fetchedAttribute, navigablePath, entityPersister, (DomainResult<?>)keyResult, affectedByFilter, creationState);
            }
            case BATCH_LOAD: {
                if (parent.isEmbeddableInitializer()) {
                    return new BatchEntityInsideEmbeddableSelectFetchInitializer(parent, fetchedAttribute, navigablePath, entityPersister, keyResult, affectedByFilter, creationState);
                }
                return new BatchEntitySelectFetchInitializer(parent, fetchedAttribute, navigablePath, entityPersister, keyResult, affectedByFilter, creationState);
            }
            case BATCH_INITIALIZE: {
                return new BatchInitializeEntitySelectFetchInitializer(parent, fetchedAttribute, navigablePath, entityPersister, keyResult, affectedByFilter, creationState);
            }
        }
        throw new IllegalStateException("Should be unreachable");
    }

    public static BatchMode determineBatchMode(EntityPersister entityPersister, InitializerParent<?> parent, AssemblerCreationState creationState) {
        if (!entityPersister.isBatchLoadable()) {
            return BatchMode.NONE;
        }
        if (creationState.isDynamicInstantiation()) {
            if (ReactiveEntitySelectFetchInitializerBuilder.canBatchInitializeBeUsed(entityPersister)) {
                return BatchMode.BATCH_INITIALIZE;
            }
            return BatchMode.NONE;
        }
        while (parent.isEmbeddableInitializer()) {
            EmbeddableInitializer embeddableInitializer = parent.asEmbeddableInitializer();
            EmbeddableValuedModelPart initializedPart = embeddableInitializer.getInitializedPart();
            if (initializedPart.isEntityIdentifierMapping() || initializedPart.isVirtual() || initializedPart.getMappedType().isPolymorphic() || !(initializedPart.getMappedType().getRepresentationStrategy().getInstantiator() instanceof StandardEmbeddableInstantiator)) {
                return entityPersister.hasSubclasses() ? BatchMode.NONE : BatchMode.BATCH_INITIALIZE;
            }
            if ((parent = parent.getParent()) != null) continue;
            break;
        }
        if (parent != null) {
            assert (parent.getInitializedPart() instanceof EntityValuedModelPart);
            EntityPersister parentPersister = parent.asEntityInitializer().getEntityDescriptor();
            EntityDataAccess cacheAccess = parentPersister.getCacheAccessStrategy();
            if (cacheAccess != null) {
                if (ReactiveEntitySelectFetchInitializerBuilder.canBatchInitializeBeUsed(entityPersister)) {
                    return BatchMode.BATCH_INITIALIZE;
                }
                return BatchMode.NONE;
            }
        }
        return BatchMode.BATCH_LOAD;
    }

    private static boolean canBatchInitializeBeUsed(EntityPersister entityPersister) {
        return entityPersister.getRepresentationStrategy().getProxyFactory() != null;
    }

    private static enum BatchMode {
        NONE,
        BATCH_LOAD,
        BATCH_INITIALIZE;

    }
}

