/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.sql.results.internal;

import java.util.ArrayList;
import java.util.Map;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.entity.internal.EntityDelayedFetchInitializer;
import org.hibernate.sql.results.graph.entity.internal.EntitySelectFetchInitializer;

public final class ReactiveInitializersList {
    private final Initializer[] initializers;
    private final Initializer[] sortedForResolveInstance;
    private final boolean hasCollectionInitializers;

    private ReactiveInitializersList(Initializer[] initializers, Initializer[] sortedForResolveInstance, boolean hasCollectionInitializers) {
        this.initializers = initializers;
        this.sortedForResolveInstance = sortedForResolveInstance;
        this.hasCollectionInitializers = hasCollectionInitializers;
    }

    public boolean hasCollectionInitializers() {
        return this.hasCollectionInitializers;
    }

    static class Builder {
        private final ArrayList<Initializer<?>> initializers;
        int nonCollectionInitializersNum = 0;
        int resolveFirstNum = 0;

        public Builder() {
            this.initializers = new ArrayList();
        }

        public Builder(int size) {
            this.initializers = new ArrayList(size);
        }

        public void addInitializer(Initializer<?> initializer) {
            this.initializers.add(initializer);
            if (!initializer.isCollectionInitializer()) {
                ++this.nonCollectionInitializersNum;
            }
            if (Builder.initializeFirst(initializer)) {
                ++this.resolveFirstNum;
            }
        }

        private static boolean initializeFirst(Initializer<?> initializer) {
            return !(initializer instanceof EntityDelayedFetchInitializer) && !(initializer instanceof EntitySelectFetchInitializer);
        }

        ReactiveInitializersList build(Map<NavigablePath, Initializer<?>> initializerMap) {
            Initializer<?>[] originalSortInitializers;
            int size = this.initializers.size();
            Initializer[] sortedForResolveInstance = new Initializer[size];
            int resolveFirstIdx = 0;
            int resolveLaterIdx = this.resolveFirstNum;
            for (Initializer<?> initializer : originalSortInitializers = this.toArray(this.initializers)) {
                if (Builder.initializeFirst(initializer)) {
                    sortedForResolveInstance[resolveFirstIdx++] = initializer;
                    continue;
                }
                sortedForResolveInstance[resolveLaterIdx++] = initializer;
            }
            boolean hasCollectionInitializers = this.nonCollectionInitializersNum != this.initializers.size();
            return new ReactiveInitializersList(originalSortInitializers, sortedForResolveInstance, hasCollectionInitializers);
        }

        private Initializer<?>[] toArray(ArrayList<Initializer<?>> initializers) {
            return initializers.toArray(new Initializer[initializers.size()]);
        }
    }
}

