/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reactive.type.descriptor.jdbc;

import java.lang.reflect.Array;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Locale;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.OracleArrayJdbcType;
import org.hibernate.reactive.adaptor.impl.ArrayAdaptor;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.converter.spi.JpaAttributeConverter;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.ArrayJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.StructJdbcType;

public class ReactiveOracleArrayJdbcType
extends OracleArrayJdbcType {
    private final String upperTypeName;

    public ReactiveOracleArrayJdbcType(JdbcType elementJdbcType, String typeName) {
        super(elementJdbcType, typeName);
        this.upperTypeName = typeName == null ? null : typeName.toUpperCase(Locale.ROOT);
    }

    public static String getTypeName(WrapperOptions options, BasicPluralJavaType<?> containerJavaType) {
        Dialect dialect = options.getSessionFactory().getJdbcServices().getDialect();
        return ReactiveOracleArrayJdbcType.getTypeName(containerJavaType.getElementJavaType(), dialect);
    }

    public static String getTypeName(JavaType<?> elementJavaType, Dialect dialect) {
        return dialect.getArrayTypeName(elementJavaType.getJavaTypeClass().getSimpleName(), null, null);
    }

    public <X> ValueBinder<X> getBinder(final JavaType<X> javaTypeDescriptor) {
        final BasicPluralJavaType containerJavaType = (BasicPluralJavaType)javaTypeDescriptor;
        return new BasicBinder<X>(javaTypeDescriptor, (JdbcType)this){

            private String typeName(WrapperOptions options) {
                return ReactiveOracleArrayJdbcType.this.upperTypeName == null ? ReactiveOracleArrayJdbcType.getTypeName(options, (BasicPluralJavaType)this.getJavaType(), (ArrayJdbcType)this.getJdbcType()).toUpperCase(Locale.ROOT) : ReactiveOracleArrayJdbcType.this.upperTypeName;
            }

            protected void doBindNull(PreparedStatement st, int index, WrapperOptions options) throws SQLException {
                st.setNull(index, 2003, this.typeName(options));
            }

            protected void doBindNull(CallableStatement st, String name, WrapperOptions options) throws SQLException {
                st.setNull(name, 2003, this.typeName(options));
            }

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setArray(index, this.getArray(value, containerJavaType, options));
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) {
                ArrayAdaptor arr = this.getArray(value, containerJavaType, options);
                try {
                    st.setObject(name, (Object)arr, 2003);
                }
                catch (SQLException ex) {
                    throw new HibernateException((Throwable)ex);
                }
            }

            private ArrayAdaptor getArray(X value, BasicPluralJavaType<X> containerJavaType2, WrapperOptions options) {
                Class<?> arrayClass = Array.newInstance(ReactiveOracleArrayJdbcType.this.getElementJdbcType().getPreferredJavaTypeClass(options), 0).getClass();
                Object[] objects = (Object[])javaTypeDescriptor.unwrap(value, arrayClass, options);
                String arrayTypeName = this.typeName(options).toUpperCase(Locale.ROOT);
                return new ArrayAdaptor(arrayTypeName, objects);
            }
        };
    }

    static String getTypeName(WrapperOptions options, BasicPluralJavaType<?> containerJavaType, ArrayJdbcType arrayJdbcType) {
        Dialect dialect = options.getSessionFactory().getJdbcServices().getDialect();
        return ReactiveOracleArrayJdbcType.getTypeName(containerJavaType.getElementJavaType(), arrayJdbcType.getElementJdbcType(), dialect);
    }

    static String getTypeName(BasicType<?> elementType, Dialect dialect) {
        BasicValueConverter converter = elementType.getValueConverter();
        if (converter != null) {
            String simpleName = converter instanceof JpaAttributeConverter ? ((JpaAttributeConverter)converter).getConverterJavaType().getJavaTypeClass().getSimpleName() : converter.getClass().getSimpleName();
            return dialect.getArrayTypeName(simpleName, null, null);
        }
        return ReactiveOracleArrayJdbcType.getTypeName(elementType.getJavaTypeDescriptor(), elementType.getJdbcType(), dialect);
    }

    static String getTypeName(JavaType<?> elementJavaType, JdbcType elementJdbcType, Dialect dialect) {
        Class preferredJavaTypeClass;
        Object simpleName = elementJavaType.getJavaTypeClass().isArray() ? dialect.getArrayTypeName(elementJavaType.getJavaTypeClass().getComponentType().getSimpleName(), null, null) : (elementJdbcType instanceof StructJdbcType ? ((StructJdbcType)elementJdbcType).getStructTypeName() : ((preferredJavaTypeClass = elementJdbcType.getPreferredJavaTypeClass(null)) == elementJavaType.getJavaTypeClass() ? elementJavaType.getJavaTypeClass().getSimpleName() : (preferredJavaTypeClass.isArray() ? elementJavaType.getJavaTypeClass().getSimpleName() + dialect.getArrayTypeName(preferredJavaTypeClass.getComponentType().getSimpleName(), null, null) : elementJavaType.getJavaTypeClass().getSimpleName() + preferredJavaTypeClass.getSimpleName())));
        return dialect.getArrayTypeName((String)simpleName, null, null);
    }
}

