/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.predicate.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.search.common.impl.AbstractElasticsearchValueFieldSearchQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSingleFieldPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.PrefixPredicateBuilder;

public class ElasticsearchTextPrefixPredicate
extends AbstractElasticsearchSingleFieldPredicate {
    private static final JsonObjectAccessor PREFIX_ACCESSOR = JsonAccessor.root().property("prefix").asObject();
    private static final JsonAccessor<JsonElement> VALUE_ACCESSOR = JsonAccessor.root().property("value");
    private final JsonPrimitive prefix;

    private ElasticsearchTextPrefixPredicate(Builder builder) {
        super(builder);
        this.prefix = builder.prefix;
    }

    @Override
    protected JsonObject doToJsonQuery(PredicateRequestContext context, JsonObject outerObject, JsonObject innerObject) {
        VALUE_ACCESSOR.set(innerObject, (JsonElement)this.prefix);
        JsonObject middleObject = new JsonObject();
        middleObject.add(this.absoluteFieldPath, (JsonElement)innerObject);
        PREFIX_ACCESSOR.set(outerObject, middleObject);
        return outerObject;
    }

    private static class Builder
    extends AbstractElasticsearchSingleFieldPredicate.AbstractBuilder
    implements PrefixPredicateBuilder {
        private JsonPrimitive prefix;

        private Builder(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<String> field) {
            super(scope, field);
        }

        public void prefix(String prefix) {
            this.prefix = new JsonPrimitive(prefix);
        }

        public SearchPredicate build() {
            return new ElasticsearchTextPrefixPredicate(this);
        }
    }

    public static class Factory
    extends AbstractElasticsearchValueFieldSearchQueryElementFactory<PrefixPredicateBuilder, String> {
        @Override
        public PrefixPredicateBuilder create(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<String> field) {
            return new Builder(scope, field);
        }
    }
}

