/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.predicate.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.ValueModel;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.RangePredicateFieldMoreStep;
import org.hibernate.search.engine.search.predicate.dsl.RangePredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.impl.AbstractBooleanMultiFieldPredicateCommonState;
import org.hibernate.search.engine.search.predicate.dsl.spi.SearchPredicateDslContext;
import org.hibernate.search.engine.search.predicate.spi.PredicateTypeKeys;
import org.hibernate.search.engine.search.predicate.spi.RangePredicateBuilder;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

class RangePredicateFieldMoreStepImpl
implements RangePredicateFieldMoreStep<RangePredicateFieldMoreStepImpl, RangePredicateOptionsStep<?>>,
AbstractBooleanMultiFieldPredicateCommonState.FieldSetState {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final CommonState commonState;
    private final List<String> fieldPaths;
    private final List<RangePredicateBuilder> predicateBuilders = new ArrayList<RangePredicateBuilder>();
    private Float fieldSetBoost;

    RangePredicateFieldMoreStepImpl(CommonState commonState, List<String> fieldPaths) {
        this.commonState = commonState;
        this.commonState.add(this);
        this.fieldPaths = fieldPaths;
        for (String path : fieldPaths) {
            commonState.scope().fieldQueryElement(path, PredicateTypeKeys.RANGE);
        }
    }

    @Override
    public RangePredicateFieldMoreStepImpl fields(String ... fieldPaths) {
        return new RangePredicateFieldMoreStepImpl(this.commonState, Arrays.asList(fieldPaths));
    }

    @Override
    public RangePredicateFieldMoreStepImpl boost(float boost) {
        this.fieldSetBoost = Float.valueOf(boost);
        return this;
    }

    @Override
    public RangePredicateOptionsStep<?> within(Range<?> range, ValueModel valueModel) {
        return this.commonState.within(range, valueModel, valueModel);
    }

    @Override
    public RangePredicateOptionsStep<?> withinAny(Collection<? extends Range<?>> ranges, ValueModel valueModel) {
        return this.commonState.withinAny(ranges, valueModel);
    }

    @Override
    public void contributePredicates(Consumer<SearchPredicate> collector) {
        for (RangePredicateBuilder predicateBuilder : this.predicateBuilders) {
            this.commonState.applyBoostAndConstantScore(this.fieldSetBoost, predicateBuilder);
            collector.accept(predicateBuilder.build());
        }
    }

    static class CommonState
    extends AbstractBooleanMultiFieldPredicateCommonState<CommonState, RangePredicateFieldMoreStepImpl>
    implements RangePredicateOptionsStep<CommonState> {
        CommonState(SearchPredicateDslContext<?> dslContext) {
            super(dslContext);
        }

        CommonState within(Range<?> range, ValueModel lowerBoundModel, ValueModel upperBoundModel) {
            Contracts.assertNotNull(range, (String)"range");
            Contracts.assertNotNull((Object)((Object)lowerBoundModel), (String)"lowerBoundModel");
            Contracts.assertNotNull((Object)((Object)upperBoundModel), (String)"upperBoundModel");
            if (range.lowerBoundValue().isEmpty() && range.upperBoundValue().isEmpty()) {
                throw log.rangePredicateCannotMatchNullValue(this.getEventContext());
            }
            for (RangePredicateFieldMoreStepImpl fieldSetState : this.getFieldSetStates()) {
                for (String path : fieldSetState.fieldPaths) {
                    RangePredicateBuilder builder = this.scope().fieldQueryElement(path, PredicateTypeKeys.RANGE);
                    builder.within(range, lowerBoundModel, upperBoundModel);
                    fieldSetState.predicateBuilders.add(builder);
                }
            }
            return this;
        }

        public CommonState withinAny(Collection<? extends Range<?>> ranges, ValueModel valueModel) {
            Contracts.assertNotNull((Object)((Object)valueModel), (String)"valueModel");
            for (RangePredicateFieldMoreStepImpl fieldSetState : this.getFieldSetStates()) {
                for (String path : fieldSetState.fieldPaths) {
                    for (Range<?> range : ranges) {
                        Contracts.assertNotNull(range, (String)"range");
                        if (range.lowerBoundValue().isEmpty() && range.upperBoundValue().isEmpty()) {
                            throw log.rangePredicateCannotMatchNullValue(this.getEventContext());
                        }
                        RangePredicateBuilder builder = this.scope().fieldQueryElement(path, PredicateTypeKeys.RANGE);
                        builder.within(range, valueModel, valueModel);
                        fieldSetState.predicateBuilders.add(builder);
                    }
                }
            }
            return this;
        }

        @Override
        protected CommonState thisAsS() {
            return this;
        }

        protected final EventContext getEventContext() {
            return EventContexts.fromIndexFieldAbsolutePaths(this.getFieldSetStates().stream().flatMap(f -> f.fieldPaths.stream()).collect(Collectors.toList()));
        }
    }
}

