/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.corejs.javascript.typedarrays;

import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.LambdaConstructor;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.corejs.javascript.typedarrays.ByteIo;
import org.htmlunit.corejs.javascript.typedarrays.Conversions;
import org.htmlunit.corejs.javascript.typedarrays.NativeArrayBuffer;
import org.htmlunit.corejs.javascript.typedarrays.NativeArrayBufferView;

public class NativeDataView
extends NativeArrayBufferView {
    private static final long serialVersionUID = 1427967607557438968L;
    public static final String CLASS_NAME = "DataView";

    public NativeDataView() {
    }

    public NativeDataView(NativeArrayBuffer ab, int offset, int length) {
        super(ab, offset, length);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    public static Object init(Context cx, Scriptable scope, boolean sealed) {
        LambdaConstructor constructor = new LambdaConstructor(scope, CLASS_NAME, 1, 2, NativeDataView::js_constructor);
        constructor.setPrototypePropertyAttributes(7);
        constructor.definePrototypeProperty(cx, "buffer", thisObj -> NativeDataView.realThis((Scriptable)thisObj).arrayBuffer, 3);
        constructor.definePrototypeProperty(cx, "byteLength", thisObj -> NativeDataView.realThis((Scriptable)thisObj).byteLength, 3);
        constructor.definePrototypeProperty(cx, "byteOffset", thisObj -> NativeDataView.realThis((Scriptable)thisObj).offset, 3);
        constructor.definePrototypeMethod(scope, "getFloat32", 1, (lcx, lscope, thisObj, args) -> NativeDataView.realThis(thisObj).js_getFloat(4, args), 2, 3);
        constructor.definePrototypeMethod(scope, "getFloat64", 1, (lcx, lscope, thisObj, args) -> NativeDataView.realThis(thisObj).js_getFloat(8, args), 2, 3);
        constructor.definePrototypeMethod(scope, "getInt8", 1, (lcx, lscope, thisObj, args) -> NativeDataView.realThis(thisObj).js_getInt(1, true, args), 2, 3);
        constructor.definePrototypeMethod(scope, "getInt16", 1, (lcx, lscope, thisObj, args) -> NativeDataView.realThis(thisObj).js_getInt(2, true, args), 2, 3);
        constructor.definePrototypeMethod(scope, "getInt32", 1, (lcx, lscope, thisObj, args) -> NativeDataView.realThis(thisObj).js_getInt(4, true, args), 2, 3);
        constructor.definePrototypeMethod(scope, "getUint8", 1, (lcx, lscope, thisObj, args) -> NativeDataView.realThis(thisObj).js_getInt(1, false, args), 2, 3);
        constructor.definePrototypeMethod(scope, "getUint16", 1, (lcx, lscope, thisObj, args) -> NativeDataView.realThis(thisObj).js_getInt(2, false, args), 2, 3);
        constructor.definePrototypeMethod(scope, "getUint32", 1, (lcx, lscope, thisObj, args) -> NativeDataView.realThis(thisObj).js_getInt(4, false, args), 2, 3);
        constructor.definePrototypeMethod(scope, "setFloat32", 2, (lcx, lscope, thisObj, args) -> {
            NativeDataView.realThis(thisObj).js_setFloat(4, args);
            return Undefined.instance;
        }, 2, 3);
        constructor.definePrototypeMethod(scope, "setFloat64", 2, (lcx, lscope, thisObj, args) -> {
            NativeDataView.realThis(thisObj).js_setFloat(8, args);
            return Undefined.instance;
        }, 2, 3);
        constructor.definePrototypeMethod(scope, "setInt8", 2, (lcx, lscope, thisObj, args) -> {
            NativeDataView.realThis(thisObj).js_setInt(1, true, args);
            return Undefined.instance;
        }, 2, 3);
        constructor.definePrototypeMethod(scope, "setInt16", 2, (lcx, lscope, thisObj, args) -> {
            NativeDataView.realThis(thisObj).js_setInt(2, true, args);
            return Undefined.instance;
        }, 2, 3);
        constructor.definePrototypeMethod(scope, "setInt32", 2, (lcx, lscope, thisObj, args) -> {
            NativeDataView.realThis(thisObj).js_setInt(4, true, args);
            return Undefined.instance;
        }, 2, 3);
        constructor.definePrototypeMethod(scope, "setUint8", 2, (lcx, lscope, thisObj, args) -> {
            NativeDataView.realThis(thisObj).js_setInt(1, false, args);
            return Undefined.instance;
        }, 2, 3);
        constructor.definePrototypeMethod(scope, "setUint16", 2, (lcx, lscope, thisObj, args) -> {
            NativeDataView.realThis(thisObj).js_setInt(2, false, args);
            return Undefined.instance;
        }, 2, 3);
        constructor.definePrototypeMethod(scope, "setUint32", 2, (lcx, lscope, thisObj, args) -> {
            NativeDataView.realThis(thisObj).js_setInt(4, false, args);
            return Undefined.instance;
        }, 2, 3);
        if (sealed) {
            constructor.sealObject();
        }
        return constructor;
    }

    private static int determinePos(Object[] args) {
        if (NativeDataView.isArg(args, 0)) {
            double doublePos = ScriptRuntime.toNumber(args[0]);
            if (Double.isInfinite(doublePos)) {
                throw ScriptRuntime.rangeError("offset out of range");
            }
            return ScriptRuntime.toInt32(doublePos);
        }
        return 0;
    }

    private void rangeCheck(int pos, int len) {
        if (pos < 0 || pos + len > this.byteLength) {
            throw ScriptRuntime.rangeError("offset out of range");
        }
    }

    private static NativeDataView realThis(Scriptable thisObj) {
        return LambdaConstructor.convertThisObject(thisObj, NativeDataView.class);
    }

    private static NativeDataView js_constructor(Context cx, Scriptable scope, Object[] args) {
        int len;
        int pos;
        if (!NativeDataView.isArg(args, 0) || !(args[0] instanceof NativeArrayBuffer)) {
            throw ScriptRuntime.constructError("TypeError", "Missing parameters");
        }
        NativeArrayBuffer ab = (NativeArrayBuffer)args[0];
        if (NativeDataView.isArg(args, 1)) {
            double doublePos = ScriptRuntime.toNumber(args[1]);
            if (Double.isInfinite(doublePos)) {
                throw ScriptRuntime.rangeError("offset out of range");
            }
            pos = ScriptRuntime.toInt32(doublePos);
        } else {
            pos = 0;
        }
        if (NativeDataView.isArg(args, 2)) {
            double doublePos = ScriptRuntime.toNumber(args[2]);
            if (Double.isInfinite(doublePos)) {
                throw ScriptRuntime.rangeError("offset out of range");
            }
            len = ScriptRuntime.toInt32(doublePos);
        } else {
            len = ab.getLength() - pos;
        }
        if (len < 0) {
            throw ScriptRuntime.rangeError("length out of range");
        }
        if (pos < 0 || pos + len > ab.getLength()) {
            throw ScriptRuntime.rangeError("offset out of range");
        }
        return new NativeDataView(ab, pos, len);
    }

    private Object js_getInt(int bytes, boolean signed, Object[] args) {
        int pos = NativeDataView.determinePos(args);
        this.rangeCheck(pos, bytes);
        boolean littleEndian = NativeDataView.isArg(args, 1) && bytes > 1 && ScriptRuntime.toBoolean(args[1]);
        switch (bytes) {
            case 1: {
                if (signed) {
                    return ByteIo.readInt8(this.arrayBuffer.buffer, this.offset + pos);
                }
                return ByteIo.readUint8(this.arrayBuffer.buffer, this.offset + pos);
            }
            case 2: {
                if (signed) {
                    return ByteIo.readInt16(this.arrayBuffer.buffer, this.offset + pos, littleEndian);
                }
                return ByteIo.readUint16(this.arrayBuffer.buffer, this.offset + pos, littleEndian);
            }
            case 4: {
                return signed ? ByteIo.readInt32(this.arrayBuffer.buffer, this.offset + pos, littleEndian) : ByteIo.readUint32(this.arrayBuffer.buffer, this.offset + pos, littleEndian);
            }
        }
        throw new AssertionError();
    }

    private Object js_getFloat(int bytes, Object[] args) {
        int pos = NativeDataView.determinePos(args);
        this.rangeCheck(pos, bytes);
        boolean littleEndian = NativeDataView.isArg(args, 1) && bytes > 1 && ScriptRuntime.toBoolean(args[1]);
        switch (bytes) {
            case 4: {
                return ByteIo.readFloat32(this.arrayBuffer.buffer, this.offset + pos, littleEndian);
            }
            case 8: {
                return ByteIo.readFloat64(this.arrayBuffer.buffer, this.offset + pos, littleEndian);
            }
        }
        throw new AssertionError();
    }

    private void js_setInt(int bytes, boolean signed, Object[] args) {
        int pos = NativeDataView.determinePos(args);
        if (pos < 0) {
            throw ScriptRuntime.rangeError("offset out of range");
        }
        boolean littleEndian = NativeDataView.isArg(args, 2) && bytes > 1 && ScriptRuntime.toBoolean(args[2]);
        Object val = ScriptRuntime.zeroObj;
        if (args.length > 1) {
            val = args[1];
        }
        switch (bytes) {
            case 1: {
                if (signed) {
                    int value = Conversions.toInt8(val);
                    if (pos + bytes > this.byteLength) {
                        throw ScriptRuntime.rangeError("offset out of range");
                    }
                    ByteIo.writeInt8(this.arrayBuffer.buffer, this.offset + pos, value);
                    break;
                }
                int value = Conversions.toUint8(val);
                if (pos + bytes > this.byteLength) {
                    throw ScriptRuntime.rangeError("offset out of range");
                }
                ByteIo.writeUint8(this.arrayBuffer.buffer, this.offset + pos, value);
                break;
            }
            case 2: {
                if (signed) {
                    int value = Conversions.toInt16(val);
                    if (pos + bytes > this.byteLength) {
                        throw ScriptRuntime.rangeError("offset out of range");
                    }
                    ByteIo.writeInt16(this.arrayBuffer.buffer, this.offset + pos, value, littleEndian);
                    break;
                }
                int value = Conversions.toUint16(val);
                if (pos + bytes > this.byteLength) {
                    throw ScriptRuntime.rangeError("offset out of range");
                }
                ByteIo.writeUint16(this.arrayBuffer.buffer, this.offset + pos, value, littleEndian);
                break;
            }
            case 4: {
                if (signed) {
                    int value = Conversions.toInt32(val);
                    if (pos + bytes > this.byteLength) {
                        throw ScriptRuntime.rangeError("offset out of range");
                    }
                    ByteIo.writeInt32(this.arrayBuffer.buffer, this.offset + pos, value, littleEndian);
                    break;
                }
                long value = Conversions.toUint32(val);
                if (pos + bytes > this.byteLength) {
                    throw ScriptRuntime.rangeError("offset out of range");
                }
                ByteIo.writeUint32(this.arrayBuffer.buffer, this.offset + pos, value, littleEndian);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private void js_setFloat(int bytes, Object[] args) {
        int pos = NativeDataView.determinePos(args);
        if (pos < 0) {
            throw ScriptRuntime.rangeError("offset out of range");
        }
        boolean littleEndian = NativeDataView.isArg(args, 2) && bytes > 1 && ScriptRuntime.toBoolean(args[2]);
        double val = Double.NaN;
        if (args.length > 1) {
            val = ScriptRuntime.toNumber(args[1]);
        }
        if (pos + bytes > this.byteLength) {
            throw ScriptRuntime.rangeError("offset out of range");
        }
        switch (bytes) {
            case 4: {
                ByteIo.writeFloat32(this.arrayBuffer.buffer, this.offset + pos, val, littleEndian);
                break;
            }
            case 8: {
                ByteIo.writeFloat64(this.arrayBuffer.buffer, this.offset + pos, val, littleEndian);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }
}

