/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cssparser.parser.selector;

import java.io.Serializable;
import org.htmlunit.cssparser.parser.condition.Condition;
import org.htmlunit.cssparser.parser.condition.NotPseudoClassCondition;
import org.htmlunit.cssparser.parser.selector.ChildSelector;
import org.htmlunit.cssparser.parser.selector.DescendantSelector;
import org.htmlunit.cssparser.parser.selector.DirectAdjacentSelector;
import org.htmlunit.cssparser.parser.selector.ElementSelector;
import org.htmlunit.cssparser.parser.selector.GeneralAdjacentSelector;
import org.htmlunit.cssparser.parser.selector.PseudoElementSelector;
import org.htmlunit.cssparser.parser.selector.Selector;
import org.htmlunit.cssparser.parser.selector.SelectorList;

public class SelectorSpecificity
implements Comparable<SelectorSpecificity>,
Serializable {
    public static final SelectorSpecificity FROM_STYLE_ATTRIBUTE = new SelectorSpecificity(true, 0, 0, 0);
    public static final SelectorSpecificity DEFAULT_STYLE_ATTRIBUTE = new SelectorSpecificity(false, 0, 0, 0);
    private int fromStyle_;
    private int idCount_;
    private int classCount_;
    private int typeCount_;

    public SelectorSpecificity(Selector selector) {
        this.readSelectorSpecificity(selector);
    }

    private SelectorSpecificity(boolean fromStyle, int idCount, int classCount, int typeCount) {
        this.fromStyle_ = fromStyle ? 1 : 0;
        this.idCount_ = idCount;
        this.classCount_ = classCount;
        this.typeCount_ = typeCount;
    }

    private void readSelectorSpecificity(Selector selector) {
        switch (selector.getSelectorType()) {
            case DESCENDANT_SELECTOR: {
                DescendantSelector ds = (DescendantSelector)selector;
                this.readSelectorSpecificity(ds.getAncestorSelector());
                this.readSelectorSpecificity(ds.getSimpleSelector());
                return;
            }
            case CHILD_SELECTOR: {
                ChildSelector cs = (ChildSelector)selector;
                this.readSelectorSpecificity(cs.getAncestorSelector());
                this.readSelectorSpecificity(cs.getSimpleSelector());
                return;
            }
            case ELEMENT_NODE_SELECTOR: {
                ElementSelector es = (ElementSelector)selector;
                if (es.getLocalName() != null) {
                    ++this.typeCount_;
                }
                if (es.getConditions() != null) {
                    for (Condition condition : es.getConditions()) {
                        this.readSelectorSpecificity(condition);
                    }
                }
                return;
            }
            case PSEUDO_ELEMENT_SELECTOR: {
                PseudoElementSelector pes = (PseudoElementSelector)selector;
                String pesName = pes.getLocalName();
                if (pesName != null) {
                    ++this.typeCount_;
                }
                return;
            }
            case DIRECT_ADJACENT_SELECTOR: {
                DirectAdjacentSelector das = (DirectAdjacentSelector)selector;
                this.readSelectorSpecificity(das.getSelector());
                this.readSelectorSpecificity(das.getSimpleSelector());
                return;
            }
            case GENERAL_ADJACENT_SELECTOR: {
                GeneralAdjacentSelector gas = (GeneralAdjacentSelector)selector;
                this.readSelectorSpecificity(gas.getSelector());
                this.readSelectorSpecificity(gas.getSimpleSelector());
                return;
            }
        }
        throw new RuntimeException("Unhandled CSS selector type for specificity computation: '" + (Object)((Object)selector.getSelectorType()) + "'.");
    }

    private void readSelectorSpecificity(Condition condition) {
        switch (condition.getConditionType()) {
            case ID_CONDITION: {
                ++this.idCount_;
                return;
            }
            case CLASS_CONDITION: {
                ++this.classCount_;
                return;
            }
            case ATTRIBUTE_CONDITION: {
                ++this.classCount_;
                return;
            }
            case SUBSTRING_ATTRIBUTE_CONDITION: {
                ++this.classCount_;
                return;
            }
            case SUFFIX_ATTRIBUTE_CONDITION: {
                ++this.classCount_;
                return;
            }
            case PREFIX_ATTRIBUTE_CONDITION: {
                ++this.classCount_;
                return;
            }
            case BEGIN_HYPHEN_ATTRIBUTE_CONDITION: {
                ++this.classCount_;
                return;
            }
            case ONE_OF_ATTRIBUTE_CONDITION: {
                ++this.classCount_;
                return;
            }
            case NOT_PSEUDO_CLASS_CONDITION: {
                NotPseudoClassCondition notPseudoCondition = (NotPseudoClassCondition)condition;
                SelectorList selectorList = notPseudoCondition.getSelectors();
                for (Selector selector : selectorList) {
                    this.readSelectorSpecificity(selector);
                }
                return;
            }
            case PSEUDO_CLASS_CONDITION: {
                ++this.classCount_;
                return;
            }
            case LANG_CONDITION: {
                ++this.classCount_;
                return;
            }
        }
        throw new RuntimeException("Unhandled CSS condition type for specifity computation: '" + (Object)((Object)condition.getConditionType()) + "'.");
    }

    public String toString() {
        return this.fromStyle_ + "," + this.idCount_ + "," + this.classCount_ + "," + this.typeCount_;
    }

    @Override
    public int compareTo(SelectorSpecificity other) {
        if (this.fromStyle_ != other.fromStyle_) {
            return this.fromStyle_ - other.fromStyle_;
        }
        if (this.idCount_ != other.idCount_) {
            return this.idCount_ - other.idCount_;
        }
        if (this.classCount_ != other.classCount_) {
            return this.classCount_ - other.classCount_;
        }
        if (this.typeCount_ != other.typeCount_) {
            return this.typeCount_ - other.typeCount_;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fromStyle_;
        result = 31 * result + this.idCount_;
        result = 31 * result + this.classCount_;
        result = 31 * result + this.typeCount_;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SelectorSpecificity other = (SelectorSpecificity)obj;
        if (this.fromStyle_ != other.fromStyle_) {
            return false;
        }
        if (this.idCount_ != other.idCount_) {
            return false;
        }
        if (this.classCount_ != other.classCount_) {
            return false;
        }
        return this.typeCount_ == other.typeCount_;
    }
}

