/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cyberneko.filters;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.htmlunit.cyberneko.HTMLElements;
import org.htmlunit.cyberneko.HTMLNamedEntitiesParser;
import org.htmlunit.cyberneko.filters.DefaultFilter;
import org.htmlunit.cyberneko.xerces.xni.Augmentations;
import org.htmlunit.cyberneko.xerces.xni.NamespaceContext;
import org.htmlunit.cyberneko.xerces.xni.QName;
import org.htmlunit.cyberneko.xerces.xni.XMLAttributes;
import org.htmlunit.cyberneko.xerces.xni.XMLLocator;
import org.htmlunit.cyberneko.xerces.xni.XMLString;
import org.htmlunit.cyberneko.xerces.xni.XNIException;

public class HTMLWriterFilter
extends DefaultFilter {
    private final String encoding_;
    private final PrintWriter printer_;
    private boolean seenRootElement_;
    private int elementDepth_;
    private boolean normalize_;
    private final HTMLElements htmlElements_;

    public HTMLWriterFilter() {
        try {
            this.encoding_ = StandardCharsets.UTF_8.name();
            this.printer_ = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, this.encoding_));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.htmlElements_ = new HTMLElements();
    }

    public HTMLWriterFilter(OutputStream outputStream, String encoding) throws UnsupportedEncodingException {
        this(new OutputStreamWriter(outputStream, encoding), encoding, new HTMLElements());
    }

    public HTMLWriterFilter(Writer writer, String encoding, HTMLElements htmlElements) {
        this.encoding_ = encoding;
        this.printer_ = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        this.htmlElements_ = htmlElements;
    }

    @Override
    public void startDocument(XMLLocator locator, String encoding, NamespaceContext nscontext, Augmentations augs) throws XNIException {
        this.seenRootElement_ = false;
        this.elementDepth_ = 0;
        this.normalize_ = true;
        super.startDocument(locator, encoding, nscontext, augs);
    }

    @Override
    public void comment(XMLString text, Augmentations augs) throws XNIException {
        if (this.seenRootElement_ && this.elementDepth_ <= 0) {
            this.printer_.println();
        }
        this.printer_.print("<!--");
        this.printCharacters(text, false);
        this.printer_.print("-->");
        if (!this.seenRootElement_) {
            this.printer_.println();
        }
        this.printer_.flush();
    }

    @Override
    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        this.seenRootElement_ = true;
        ++this.elementDepth_;
        this.normalize_ = !this.htmlElements_.getElement(element.getRawname()).isSpecial();
        this.printStartElement(element, attributes);
        super.startElement(element, attributes, augs);
    }

    @Override
    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        this.seenRootElement_ = true;
        this.printStartElement(element, attributes);
        super.emptyElement(element, attributes, augs);
    }

    @Override
    public void characters(XMLString text, Augmentations augs) throws XNIException {
        this.printCharacters(text, this.normalize_);
        super.characters(text, augs);
    }

    @Override
    public void endElement(QName element, Augmentations augs) throws XNIException {
        --this.elementDepth_;
        this.normalize_ = true;
        this.printEndElement(element);
        super.endElement(element, augs);
    }

    protected void printAttributeValue(String text) {
        int length = text.length();
        for (int j = 0; j < length; ++j) {
            char c = text.charAt(j);
            if (c == '\"') {
                this.printer_.print("&quot;");
                continue;
            }
            this.printer_.print(c);
        }
        this.printer_.flush();
    }

    protected void printCharacters(XMLString text, boolean normalize) {
        if (normalize) {
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c != '\n') {
                    String entity = HTMLNamedEntitiesParser.get().lookupEntityRefFor(Character.toString(c));
                    if (entity != null) {
                        this.printer_.print(entity);
                        continue;
                    }
                    this.printer_.print(c);
                    continue;
                }
                this.printer_.println();
            }
        } else {
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                this.printer_.print(c);
            }
        }
        this.printer_.flush();
    }

    protected void printStartElement(QName element, XMLAttributes attributes) {
        int contentIndex = -1;
        String originalContent = null;
        if ("meta".equalsIgnoreCase(element.getRawname())) {
            String httpEquiv = null;
            int length = attributes.getLength();
            for (int i = 0; i < length; ++i) {
                String aname = attributes.getQName(i).toLowerCase();
                if ("http-equiv".equals(aname)) {
                    httpEquiv = attributes.getValue(i);
                    continue;
                }
                if (!"content".equals(aname)) continue;
                contentIndex = i;
            }
            if ("content-type".equalsIgnoreCase(httpEquiv)) {
                String content = null;
                if (contentIndex != -1) {
                    originalContent = attributes.getValue(contentIndex);
                    content = originalContent.toLowerCase();
                }
                if (content != null) {
                    int charsetIndex = content.indexOf("charset=");
                    content = charsetIndex != -1 ? content.substring(0, charsetIndex + 8) : content + ";charset=";
                    content = content + this.encoding_;
                    attributes.setValue(contentIndex, content);
                }
            }
        }
        this.printer_.print('<');
        this.printer_.print(element.getRawname());
        int attrCount = attributes != null ? attributes.getLength() : 0;
        for (int i = 0; i < attrCount; ++i) {
            String aname = attributes.getQName(i);
            String avalue = attributes.getValue(i);
            this.printer_.print(' ');
            this.printer_.print(aname);
            this.printer_.print("=\"");
            this.printAttributeValue(avalue);
            this.printer_.print('\"');
        }
        this.printer_.print('>');
        this.printer_.flush();
        if (contentIndex != -1 && originalContent != null) {
            attributes.setValue(contentIndex, originalContent);
        }
    }

    protected void printEndElement(QName element) {
        this.printer_.print("</");
        this.printer_.print(element.getRawname());
        this.printer_.print('>');
        this.printer_.flush();
    }

    protected void print(String content) {
        this.printer_.print(content);
    }

    protected boolean hasSeenRootElement() {
        return this.seenRootElement_;
    }

    protected int getElementDepth() {
        return this.elementDepth_;
    }

    protected boolean getNormalize() {
        return this.normalize_;
    }
}

