/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.commons.beanutils.Converter;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.Header;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

abstract class AnnotationHandler<T extends Annotation> {
    static final Map<Class<? extends Annotation>, AnnotationHandler> HANDLERS = new HashMap<Class<? extends Annotation>, AnnotationHandler>();

    AnnotationHandler() {
    }

    abstract Object parse(StaplerRequest var1, T var2, Class var3, String var4) throws ServletException;

    protected final Object convert(Class targetType, String value) {
        Converter converter = Stapler.lookupConverter(targetType);
        if (converter == null) {
            throw new IllegalArgumentException("Unable to convert to " + targetType);
        }
        return converter.convert(targetType, (Object)value);
    }

    static Object handle(StaplerRequest request, Annotation[] annotations, String parameterName, Class targetType) throws ServletException {
        for (Annotation a : annotations) {
            AnnotationHandler h = HANDLERS.get(a.annotationType());
            if (h == null) continue;
            return h.parse(request, a, targetType, parameterName);
        }
        return null;
    }

    static {
        HANDLERS.put(Header.class, new AnnotationHandler<Header>(){

            @Override
            Object parse(StaplerRequest request, Header a, Class type, String parameterName) throws ServletException {
                String name = a.value();
                if (name.length() == 0) {
                    name = parameterName;
                }
                if (name == null) {
                    throw new IllegalArgumentException("Parameter name unavailable neither in the code nor in annotation");
                }
                String value = request.getHeader(name);
                if (a.required() && value == null) {
                    throw new ServletException("Required HTTP header " + name + " is missing");
                }
                return this.convert(type, value);
            }
        });
        HANDLERS.put(QueryParameter.class, new AnnotationHandler<QueryParameter>(){

            @Override
            Object parse(StaplerRequest request, QueryParameter a, Class type, String parameterName) throws ServletException {
                String name = a.value();
                if (name.length() == 0) {
                    name = parameterName;
                }
                if (name == null) {
                    throw new IllegalArgumentException("Parameter name unavailable neither in the code nor in annotation");
                }
                String value = request.getParameter(name);
                if (a.required() && value == null) {
                    throw new ServletException("Required Query parameter " + name + " is missing");
                }
                if (a.fixEmpty() && value != null && value.length() == 0) {
                    value = null;
                }
                return this.convert(type, value);
            }
        });
        HANDLERS.put(AncestorInPath.class, new AnnotationHandler<AncestorInPath>(){

            @Override
            Object parse(StaplerRequest request, AncestorInPath a, Class type, String parameterName) throws ServletException {
                return request.findAncestorObject(type);
            }
        });
    }
}

