/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class EvaluationTrace {
    private final List<String> traces = new ArrayList<String>();
    private static final String KEY = EvaluationTrace.class.getName();

    public void trace(StaplerResponse rsp, String msg) {
        this.traces.add(msg);
        rsp.addHeader(String.format("Stapler-Trace-%03d", this.traces.size()), msg);
    }

    public void printHtml(PrintWriter w) {
        for (String trace : this.traces) {
            w.println(trace.replaceAll("&", "&amp;").replaceAll("<", "&lt;"));
        }
    }

    public static EvaluationTrace get(StaplerRequest req) {
        EvaluationTrace et = (EvaluationTrace)req.getAttribute(KEY);
        if (et == null) {
            et = new EvaluationTrace();
            req.setAttribute(KEY, et);
        }
        return et;
    }
}

