/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import com.google.common.collect.MapMaker;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kohsuke.stapler.AnnotationHandler;
import org.kohsuke.stapler.ClassDescriptor;
import org.kohsuke.stapler.FunctionList;
import org.kohsuke.stapler.HttpResponseRenderer;
import org.kohsuke.stapler.LimitedTo;
import org.kohsuke.stapler.RequestImpl;
import org.kohsuke.stapler.ResponseImpl;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

abstract class Function {
    private static final Map<Class, Function> PARSE_METHODS;
    private static final Function RETURN_NULL;

    Function() {
    }

    abstract String getName();

    abstract String getDisplayName();

    abstract String getQualifiedName();

    abstract Class[] getParameterTypes();

    abstract Type[] getGenericParameterTypes();

    abstract Annotation[][] getParameterAnnotations();

    abstract String[] getParameterNames();

    abstract Class getReturnType();

    void bindAndInvokeAndServeResponse(Object node, RequestImpl req, ResponseImpl rsp, Object ... headArgs) throws IllegalAccessException, InvocationTargetException, ServletException, IOException {
        block3: {
            try {
                Object r = this.bindAndInvoke(node, req, rsp, headArgs);
                if (this.getReturnType() != Void.TYPE) {
                    this.renderResponse(req, rsp, node, r);
                }
            }
            catch (InvocationTargetException e) {
                Throwable te = e.getTargetException();
                if (this.renderResponse(req, rsp, node, te)) break block3;
                throw e;
            }
        }
    }

    private boolean renderResponse(RequestImpl req, ResponseImpl rsp, Object node, Object ret) throws IOException, ServletException {
        for (HttpResponseRenderer r : req.stapler.getWebApp().getResponseRenderers()) {
            if (!r.generateResponse(req, rsp, node, ret)) continue;
            return true;
        }
        return false;
    }

    Object bindAndInvoke(Object o, StaplerRequest req, StaplerResponse rsp, Object ... headArgs) throws IllegalAccessException, InvocationTargetException, ServletException {
        Class[] types = this.getParameterTypes();
        Annotation[][] annotations = this.getParameterAnnotations();
        String[] parameterNames = this.getParameterNames();
        Object[] arguments = new Object[types.length];
        System.arraycopy(headArgs, 0, arguments, 0, headArgs.length);
        try {
            for (int i = headArgs.length; i < types.length; ++i) {
                Function binder;
                Class t = types[i];
                arguments[i] = t == StaplerRequest.class || t == HttpServletRequest.class ? req : (t == StaplerResponse.class || t == HttpServletResponse.class ? rsp : ((binder = PARSE_METHODS.get(t)) != RETURN_NULL ? binder.bindAndInvoke(null, req, rsp, new Object[0]) : AnnotationHandler.handle(req, annotations[i], i < parameterNames.length ? parameterNames[i] : null, t)));
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Failed to invoke " + this.getDisplayName(), e);
        }
        return this.invoke(req, o, arguments);
    }

    public static Object returnNull() {
        return null;
    }

    abstract Object invoke(HttpServletRequest var1, Object var2, Object ... var3) throws IllegalAccessException, InvocationTargetException;

    final Function protectBy(Method m) {
        try {
            LimitedTo a = m.getAnnotation(LimitedTo.class);
            if (a == null) {
                return this;
            }
            return new ProtectedFunction(this, a.value());
        }
        catch (LinkageError e) {
            return this;
        }
    }

    public abstract <A extends Annotation> A getAnnotation(Class<A> var1);

    static {
        try {
            RETURN_NULL = new StaticFunction(Function.class.getMethod("returnNull", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        PARSE_METHODS = new MapMaker().weakKeys().makeComputingMap((com.google.common.base.Function)new com.google.common.base.Function<Class, Function>(){

            public Function apply(Class from) {
                FunctionList methods = new ClassDescriptor((Class)from, (Class[])new Class[0]).methods.name("fromStapler");
                switch (methods.size()) {
                    case 0: {
                        return RETURN_NULL;
                    }
                    default: {
                        throw new IllegalArgumentException("Too many 'fromStapler' methods on " + from);
                    }
                    case 1: 
                }
                Method m = ((MethodFunction)methods.get((int)0)).m;
                return new MethodFunction(m){

                    @Override
                    Class[] getParameterTypes() {
                        return this.m.getParameterTypes();
                    }

                    @Override
                    Type[] getGenericParameterTypes() {
                        return this.m.getGenericParameterTypes();
                    }

                    @Override
                    Annotation[][] getParameterAnnotations() {
                        return this.m.getParameterAnnotations();
                    }

                    @Override
                    Object invoke(HttpServletRequest req, Object o, Object ... args) throws IllegalAccessException, InvocationTargetException {
                        return this.m.invoke(null, args);
                    }
                };
            }
        });
    }

    static final class ProtectedFunction
    extends Function {
        private final String role;
        private final Function core;

        public ProtectedFunction(Function core, String role) {
            this.role = role;
            this.core = core;
        }

        @Override
        public String getName() {
            return this.core.getName();
        }

        @Override
        String getDisplayName() {
            return this.core.getDisplayName();
        }

        @Override
        String getQualifiedName() {
            return this.core.getQualifiedName();
        }

        @Override
        public Class[] getParameterTypes() {
            return this.core.getParameterTypes();
        }

        @Override
        Class getReturnType() {
            return this.core.getReturnType();
        }

        @Override
        Type[] getGenericParameterTypes() {
            return this.core.getGenericParameterTypes();
        }

        @Override
        Annotation[][] getParameterAnnotations() {
            return this.core.getParameterAnnotations();
        }

        @Override
        String[] getParameterNames() {
            return this.core.getParameterNames();
        }

        @Override
        public Object invoke(HttpServletRequest req, Object o, Object ... args) throws IllegalAccessException, InvocationTargetException {
            if (req.isUserInRole(this.role)) {
                return this.core.invoke(req, o, args);
            }
            throw new IllegalAccessException("Needs to be in role " + this.role);
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> annotation) {
            return this.core.getAnnotation(annotation);
        }
    }

    static final class StaticFunction
    extends MethodFunction {
        public StaticFunction(Method m) {
            super(m);
        }

        @Override
        public Class[] getParameterTypes() {
            Class<?>[] p = this.m.getParameterTypes();
            Class[] r = new Class[p.length - 1];
            System.arraycopy(p, 1, r, 0, r.length);
            return r;
        }

        @Override
        Type[] getGenericParameterTypes() {
            Type[] p = this.m.getGenericParameterTypes();
            Type[] r = new Type[p.length - 1];
            System.arraycopy(p, 1, r, 0, r.length);
            return r;
        }

        @Override
        Annotation[][] getParameterAnnotations() {
            Annotation[][] a = this.m.getParameterAnnotations();
            Annotation[][] r = new Annotation[a.length - 1][];
            System.arraycopy(a, 1, r, 0, r.length);
            return r;
        }

        @Override
        public Object invoke(HttpServletRequest req, Object o, Object ... args) throws IllegalAccessException, InvocationTargetException {
            Object[] r = new Object[args.length + 1];
            r[0] = o;
            System.arraycopy(args, 0, r, 1, args.length);
            return this.m.invoke(null, r);
        }
    }

    static final class InstanceFunction
    extends MethodFunction {
        public InstanceFunction(Method m) {
            super(m);
        }

        @Override
        public Class[] getParameterTypes() {
            return this.m.getParameterTypes();
        }

        @Override
        Type[] getGenericParameterTypes() {
            return this.m.getGenericParameterTypes();
        }

        @Override
        Annotation[][] getParameterAnnotations() {
            return this.m.getParameterAnnotations();
        }

        @Override
        public Object invoke(HttpServletRequest req, Object o, Object ... args) throws IllegalAccessException, InvocationTargetException {
            return this.m.invoke(o, args);
        }
    }

    private static abstract class MethodFunction
    extends Function {
        protected final Method m;
        private volatile String[] names;

        public MethodFunction(Method m) {
            this.m = m;
        }

        @Override
        public final String getName() {
            return this.m.getName();
        }

        @Override
        final String getDisplayName() {
            return this.m.toGenericString();
        }

        @Override
        String getQualifiedName() {
            return this.m.getDeclaringClass().getName() + '.' + this.getName();
        }

        @Override
        public final <A extends Annotation> A getAnnotation(Class<A> annotation) {
            return this.m.getAnnotation(annotation);
        }

        @Override
        final String[] getParameterNames() {
            if (this.names == null) {
                this.names = ClassDescriptor.loadParameterNames(this.m);
            }
            return this.names;
        }

        @Override
        Class getReturnType() {
            return this.m.getReturnType();
        }
    }
}

