/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.io.IOException;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import net.sf.json.JSONArray;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.ClassDescriptor;
import org.kohsuke.stapler.Dispatcher;
import org.kohsuke.stapler.Facet;
import org.kohsuke.stapler.Function;
import org.kohsuke.stapler.FunctionList;
import org.kohsuke.stapler.LimitedTo;
import org.kohsuke.stapler.MetaClassLoader;
import org.kohsuke.stapler.NameBasedDispatcher;
import org.kohsuke.stapler.RequestImpl;
import org.kohsuke.stapler.ResponseImpl;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.TearOffSupport;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class MetaClass
extends TearOffSupport {
    public final Class clazz;
    public final MetaClassLoader classLoader;
    public final List<Dispatcher> dispatchers = new ArrayList<Dispatcher>();
    public final MetaClass baseClass;
    public final WebApp webApp;
    public static boolean NO_CACHE = false;

    MetaClass(WebApp webApp, Class clazz) {
        this.clazz = clazz;
        this.webApp = webApp;
        this.baseClass = webApp.getMetaClass(clazz.getSuperclass());
        this.classLoader = MetaClassLoader.get(clazz.getClassLoader());
        this.buildDispatchers(new ClassDescriptor(clazz, null));
    }

    private void buildDispatchers(ClassDescriptor node) {
        String name;
        String[] names;
        Annotation a;
        for (final Function function : node.methods.prefix("do")) {
            a = function.getAnnotation(WebMethod.class);
            names = a != null && a.name().length > 0 ? a.name() : new String[]{MetaClass.camelize(function.getName().substring(2))};
            for (String name2 : names) {
                this.dispatchers.add(new NameBasedDispatcher(name2, 0){

                    @Override
                    public boolean doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IllegalAccessException, InvocationTargetException, ServletException, IOException {
                        if (1.traceable()) {
                            1.trace(req, rsp, "-> <%s>.%s(...)", node, function.getName());
                        }
                        function.bindAndInvokeAndServeResponse(node, req, rsp, new Object[0]);
                        return true;
                    }

                    @Override
                    public String toString() {
                        return function.getQualifiedName() + "(...) for url=/" + this.name + "/...";
                    }
                });
            }
        }
        for (Function function : node.methods.prefix("js")) {
            String name3 = MetaClass.camelize(function.getName().substring(2));
            this.dispatchers.add(new JavaScriptProxyMethodDispatcher(name3, function));
        }
        for (Function function : node.methods.annotated(JavaScriptMethod.class)) {
            a = function.getAnnotation(JavaScriptMethod.class);
            names = a != null && a.name().length > 0 ? a.name() : new String[]{function.getName()};
            for (String name2 : names) {
                this.dispatchers.add(new JavaScriptProxyMethodDispatcher(name2, function));
            }
        }
        for (Facet facet : this.webApp.facets) {
            facet.buildViewDispatchers(this, this.dispatchers);
        }
        for (final Function function : node.methods.name("doIndex")) {
            this.dispatchers.add(new Dispatcher(){

                @Override
                public boolean dispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IllegalAccessException, InvocationTargetException, ServletException, IOException {
                    if (req.tokens.hasMore()) {
                        return false;
                    }
                    if (2.traceable()) {
                        2.trace(req, rsp, "-> <%s>.doIndex(...)", node);
                    }
                    function.bindAndInvokeAndServeResponse(node, req, rsp, new Object[0]);
                    return true;
                }

                @Override
                public String toString() {
                    return function.getQualifiedName() + "(StaplerRequest,StaplerResponse) for url=/";
                }
            });
        }
        for (final Field f : node.fields) {
            this.dispatchers.add(new NameBasedDispatcher(f.getName()){
                final String role;
                {
                    super(x0);
                    this.role = MetaClass.this.getProtectedRole(f);
                }

                @Override
                public boolean doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException, IllegalAccessException {
                    if (this.role != null && !req.isUserInRole(this.role)) {
                        throw new IllegalAccessException("Needs to be in role " + this.role);
                    }
                    if (3.traceable()) {
                        3.traceEval(req, rsp, node, f.getName());
                    }
                    req.getStapler().invoke(req, rsp, f.get(node));
                    return true;
                }

                @Override
                public String toString() {
                    return String.format("%1$s.%2$s for url=/%2$s/...", f.getDeclaringClass().getName(), f.getName());
                }
            });
        }
        FunctionList getMethods = node.methods.prefix("get");
        for (final Function f : getMethods.signature(new Class[0])) {
            String[] names2;
            if (f.getName().length() <= 3) continue;
            WebMethod a2 = f.getAnnotation(WebMethod.class);
            if (a2 != null && a2.name().length > 0) {
                String[] names22 = a2.name();
            } else {
                names2 = new String[]{MetaClass.camelize(f.getName().substring(3))};
            }
            for (void name4 : names2) {
                this.dispatchers.add(new NameBasedDispatcher((String)name4){

                    @Override
                    public boolean doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException, IllegalAccessException, InvocationTargetException {
                        if (4.traceable()) {
                            4.traceEval(req, rsp, node, f.getName() + "()");
                        }
                        req.getStapler().invoke(req, rsp, f.invoke(req, node, new Object[0]));
                        return true;
                    }

                    @Override
                    public String toString() {
                        return String.format("%1$s() for url=/%2$s/...", f.getQualifiedName(), this.name);
                    }
                });
            }
        }
        for (final Function f : getMethods.signature(StaplerRequest.class)) {
            if (f.getName().length() <= 3) continue;
            name = MetaClass.camelize(f.getName().substring(3));
            this.dispatchers.add(new NameBasedDispatcher(name){

                @Override
                public boolean doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException, IllegalAccessException, InvocationTargetException {
                    if (5.traceable()) {
                        5.traceEval(req, rsp, node, f.getName() + "(...)");
                    }
                    req.getStapler().invoke(req, rsp, f.invoke(req, node, req));
                    return true;
                }

                @Override
                public String toString() {
                    return String.format("%1$s(StaplerRequest) for url=/%2$s/...", f.getQualifiedName(), this.name);
                }
            });
        }
        for (final Function f : getMethods.signature(String.class)) {
            if (f.getName().length() <= 3) continue;
            name = MetaClass.camelize(f.getName().substring(3));
            this.dispatchers.add(new NameBasedDispatcher(name, 1){

                @Override
                public boolean doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException, IllegalAccessException, InvocationTargetException {
                    String token = req.tokens.next();
                    if (6.traceable()) {
                        6.traceEval(req, rsp, node, f.getName() + "(\"" + token + "\")");
                    }
                    req.getStapler().invoke(req, rsp, f.invoke(req, node, token));
                    return true;
                }

                @Override
                public String toString() {
                    return String.format("%1$s(String) for url=/%2$s/TOKEN/...", f.getQualifiedName(), this.name);
                }
            });
        }
        for (final Function f : getMethods.signature(Integer.TYPE)) {
            if (f.getName().length() <= 3) continue;
            name = MetaClass.camelize(f.getName().substring(3));
            this.dispatchers.add(new NameBasedDispatcher(name, 1){

                @Override
                public boolean doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException, IllegalAccessException, InvocationTargetException {
                    int idx = req.tokens.nextAsInt();
                    if (7.traceable()) {
                        7.traceEval(req, rsp, node, f.getName() + "(" + idx + ")");
                    }
                    req.getStapler().invoke(req, rsp, f.invoke(req, node, idx));
                    return true;
                }

                @Override
                public String toString() {
                    return String.format("%1$s(int) for url=/%2$s/N/...", f.getQualifiedName(), this.name);
                }
            });
        }
        if (node.clazz.isArray()) {
            this.dispatchers.add(new Dispatcher(){

                @Override
                public boolean dispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException {
                    if (!req.tokens.hasMore()) {
                        return false;
                    }
                    try {
                        int index = req.tokens.nextAsInt();
                        if (8.traceable()) {
                            8.traceEval(req, rsp, node, "((Object[])", ")[" + index + "]");
                        }
                        req.getStapler().invoke(req, rsp, ((Object[])node)[index]);
                        return true;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }

                @Override
                public String toString() {
                    return "Array look-up for url=/N/...";
                }
            });
        }
        if (List.class.isAssignableFrom(node.clazz)) {
            this.dispatchers.add(new Dispatcher(){

                @Override
                public boolean dispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException {
                    if (!req.tokens.hasMore()) {
                        return false;
                    }
                    try {
                        int index = req.tokens.nextAsInt();
                        if (9.traceable()) {
                            9.traceEval(req, rsp, node, "((List)", ").get(" + index + ")");
                        }
                        List list = (List)node;
                        if (0 <= index && index < list.size()) {
                            req.getStapler().invoke(req, rsp, list.get(index));
                        } else {
                            if (9.traceable()) {
                                9.trace(req, rsp, "-> IndexOutOfRange [0,%d)", list.size());
                            }
                            rsp.sendError(404);
                        }
                        return true;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }

                @Override
                public String toString() {
                    return "List.get(int) look-up for url=/N/...";
                }
            });
        }
        if (Map.class.isAssignableFrom(node.clazz)) {
            this.dispatchers.add(new Dispatcher(){

                @Override
                public boolean dispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException {
                    if (!req.tokens.hasMore()) {
                        return false;
                    }
                    try {
                        Object item;
                        String key = req.tokens.peek();
                        if (10.traceable()) {
                            10.traceEval(req, rsp, "((Map)", ").get(\"" + key + "\")");
                        }
                        if ((item = ((Map)node).get(key)) != null) {
                            req.tokens.next();
                            req.getStapler().invoke(req, rsp, item);
                            return true;
                        }
                        if (10.traceable()) {
                            10.trace(req, rsp, "Map.get(\"" + key + "\")==null. Back tracking.");
                        }
                        return false;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }

                @Override
                public String toString() {
                    return "Map.get(String) look-up for url=/TOKEN/...";
                }
            });
        }
        for (final Function f : node.methods.name("doDynamic")) {
            this.dispatchers.add(new Dispatcher(){

                @Override
                public boolean dispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IllegalAccessException, InvocationTargetException, ServletException, IOException {
                    if (11.traceable()) {
                        11.trace(req, rsp, "-> <%s>.doDynamic(...)", node);
                    }
                    f.bindAndInvokeAndServeResponse(node, req, rsp, new Object[0]);
                    return true;
                }

                @Override
                public String toString() {
                    return String.format("%s(StaplerRequest,StaplerResponse) for any URL", f.getQualifiedName());
                }
            });
        }
        for (final Function f : getMethods.signatureStartsWith(String.class).name("getDynamic")) {
            this.dispatchers.add(new Dispatcher(){

                @Override
                public boolean dispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IllegalAccessException, InvocationTargetException, IOException, ServletException {
                    Object target;
                    if (!req.tokens.hasMore()) {
                        return false;
                    }
                    String token = req.tokens.next();
                    if (12.traceable()) {
                        12.traceEval(req, rsp, node, "getDynamic(\"" + token + "\",...)");
                    }
                    if ((target = f.bindAndInvoke(node, req, rsp, token)) != null) {
                        req.getStapler().invoke(req, rsp, target);
                        return true;
                    }
                    if (12.traceable()) {
                        12.trace(req, rsp, "            %s.getDynamic(\"%s\",...)==null. Back tracking.", node, token);
                    }
                    req.tokens.prev();
                    return false;
                }

                @Override
                public String toString() {
                    return String.format("%s(String,StaplerRequest,StaplerResponse) for url=/TOKEN/...", f.getQualifiedName());
                }
            });
        }
    }

    private String getProtectedRole(Field f) {
        try {
            LimitedTo a = f.getAnnotation(LimitedTo.class);
            return a != null ? a.value() : null;
        }
        catch (LinkageError e) {
            return null;
        }
    }

    private static String camelize(String name) {
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    static {
        try {
            NO_CACHE = Boolean.getBoolean("stapler.jelly.noCache");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static class JavaScriptProxyMethodDispatcher
    extends NameBasedDispatcher {
        private final Function f;

        public JavaScriptProxyMethodDispatcher(String name, Function f) {
            super(name, 0);
            this.f = f;
        }

        @Override
        public boolean doDispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IllegalAccessException, InvocationTargetException, ServletException, IOException {
            if (!req.isJavaScriptProxyCall()) {
                return false;
            }
            req.stapler.getWebApp().getCrumbIssuer().validateCrumb(req, req.getHeader("Crumb"));
            if (JavaScriptProxyMethodDispatcher.traceable()) {
                JavaScriptProxyMethodDispatcher.trace(req, rsp, "-> <%s>.%s(...)", node, this.f.getName());
            }
            JSONArray jsargs = JSONArray.fromObject((Object)IOUtils.toString((Reader)req.getReader()));
            Object[] args = new Object[jsargs.size()];
            Class[] types = this.f.getParameterTypes();
            Class[] genericTypes = this.f.getParameterTypes();
            for (int i = 0; i < args.length; ++i) {
                args[i] = req.bindJSON((Type)genericTypes[i], types[i], jsargs.get(i));
            }
            this.f.bindAndInvokeAndServeResponse(node, req, rsp, args);
            return true;
        }

        @Override
        public String toString() {
            return this.f.getQualifiedName() + "(...) for url=/" + this.name + "/...";
        }
    }
}

