/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

final class TruncatedInputStream
extends FilterInputStream {
    private long len;

    public TruncatedInputStream(InputStream in, long len) {
        super(in);
        this.len = len;
    }

    @Override
    public int read() throws IOException {
        if (this.len <= 0L) {
            return -1;
        }
        --this.len;
        return super.read();
    }

    @Override
    public int read(byte[] b, int off, int l) throws IOException {
        if (l <= 0) {
            return -1;
        }
        int r = super.read(b, off, (int)Math.min((long)l, this.len));
        if (r > 0) {
            this.len -= (long)r;
        }
        return r;
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min((long)super.available(), this.len);
    }

    @Override
    public long skip(long n) throws IOException {
        long r = super.skip(Math.min(this.len, n));
        this.len -= r;
        return r;
    }
}

