/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.ServletContext;
import org.kohsuke.stapler.AbstractTearOff;
import org.kohsuke.stapler.CrumbIssuer;
import org.kohsuke.stapler.Facet;
import org.kohsuke.stapler.HttpResponseRenderer;
import org.kohsuke.stapler.MetaClass;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.bind.BoundObjectTable;

public class WebApp {
    public final ServletContext context;
    public final Map<Class, Class[]> wrappers = new HashMap<Class, Class[]>();
    public final Map<String, String> defaultEncodingForStaticResources = new HashMap<String, String>();
    public final List<Facet> facets = new Vector<Facet>();
    public final Map<String, String> mimeTypes = new Hashtable<String, String>();
    private volatile ClassLoader classLoader;
    private final Map<Class, MetaClass> classMap = new WeakHashMap<Class, MetaClass>();
    public final BoundObjectTable boundObjectTable = new BoundObjectTable();
    private final CopyOnWriteArrayList<HttpResponseRenderer> responseRenderers = new CopyOnWriteArrayList();
    private CrumbIssuer crumbIssuer = CrumbIssuer.DEFAULT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WebApp get(ServletContext context) {
        Object o = context.getAttribute(WebApp.class.getName());
        if (o != null) return (WebApp)o;
        Class<WebApp> clazz = WebApp.class;
        synchronized (WebApp.class) {
            o = context.getAttribute(WebApp.class.getName());
            if (o != null) return (WebApp)o;
            o = new WebApp(context);
            context.setAttribute(WebApp.class.getName(), o);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return (WebApp)o;
        }
    }

    public WebApp(ServletContext context) {
        this.context = context;
        this.facets.addAll(Facet.discoverExtensions(Facet.class, Thread.currentThread().getContextClassLoader(), this.getClass().getClassLoader()));
        this.responseRenderers.add(new HttpResponseRenderer.Default());
    }

    public Object getApp() {
        return this.context.getAttribute("app");
    }

    public void setApp(Object app) {
        this.context.setAttribute("app", app);
    }

    public CrumbIssuer getCrumbIssuer() {
        return this.crumbIssuer;
    }

    public void setCrumbIssuer(CrumbIssuer crumbIssuer) {
        this.crumbIssuer = crumbIssuer;
    }

    public CopyOnWriteArrayList<HttpResponseRenderer> getResponseRenderers() {
        return this.responseRenderers;
    }

    public ClassLoader getClassLoader() {
        ClassLoader cl = this.classLoader;
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        if (cl == null) {
            cl = Stapler.class.getClassLoader();
        }
        return cl;
    }

    public <T extends Facet> T getFacet(Class<T> type) {
        for (Facet f : this.facets) {
            if (type != f.getClass()) continue;
            return (T)((Facet)type.cast(f));
        }
        return null;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaClass getMetaClass(Class c) {
        if (c == null) {
            return null;
        }
        Map<Class, MetaClass> map = this.classMap;
        synchronized (map) {
            MetaClass mc = this.classMap.get(c);
            if (mc == null) {
                mc = new MetaClass(this, c);
                this.classMap.put(c, mc);
            }
            return mc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearScripts(Class<? extends AbstractTearOff> clazz) {
        Map<Class, MetaClass> map = this.classMap;
        synchronized (map) {
            for (MetaClass v : this.classMap.values()) {
                AbstractTearOff t = v.getTearOff(clazz);
                if (t == null) continue;
                t.clearScripts();
            }
        }
    }

    public static WebApp getCurrent() {
        return Stapler.getCurrent().getWebApp();
    }
}

