/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.export;

import java.io.IOException;
import java.io.Writer;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.DataWriter;
import org.kohsuke.stapler.export.JSONDataWriter;
import org.kohsuke.stapler.export.PythonDataWriter;
import org.kohsuke.stapler.export.RubyDataWriter;
import org.kohsuke.stapler.export.XMLDataWriter;

public enum Flavor {
    JSON("application/javascript;charset=UTF-8"){

        @Override
        public DataWriter createDataWriter(Object bean, StaplerResponse rsp) throws IOException {
            return new JSONDataWriter(rsp);
        }

        @Override
        public DataWriter createDataWriter(Object bean, Writer w) throws IOException {
            return new JSONDataWriter(w);
        }
    }
    ,
    PYTHON("text/x-python;charset=UTF-8"){

        @Override
        public DataWriter createDataWriter(Object bean, StaplerResponse rsp) throws IOException {
            return new PythonDataWriter(rsp);
        }

        @Override
        public DataWriter createDataWriter(Object bean, Writer w) throws IOException {
            return new PythonDataWriter(w);
        }
    }
    ,
    RUBY("text/x-ruby;charset=UTF-8"){

        @Override
        public DataWriter createDataWriter(Object bean, StaplerResponse rsp) throws IOException {
            return new RubyDataWriter(rsp);
        }

        @Override
        public DataWriter createDataWriter(Object bean, Writer w) throws IOException {
            return new RubyDataWriter(w);
        }
    }
    ,
    XML("application/xml;charset=UTF-8"){

        @Override
        public DataWriter createDataWriter(Object bean, StaplerResponse rsp) throws IOException {
            return new XMLDataWriter(bean, rsp);
        }

        @Override
        public DataWriter createDataWriter(Object bean, Writer w) throws IOException {
            return new XMLDataWriter(bean, w);
        }
    };

    public final String contentType;

    private Flavor(String contentType) {
        this.contentType = contentType;
    }

    public abstract DataWriter createDataWriter(Object var1, StaplerResponse var2) throws IOException;

    public abstract DataWriter createDataWriter(Object var1, Writer var2) throws IOException;
}

