/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.export;

import com.sun.xml.txw2.TXW;
import com.sun.xml.txw2.output.ResultFactory;
import com.sun.xml.txw2.output.XmlSerializer;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import org.kohsuke.stapler.export.Model;
import org.kohsuke.stapler.export.ModelBuilder;
import org.kohsuke.stapler.export.Property;
import org.kohsuke.stapler.export.TypeUtil;
import org.kohsuke.stapler.export.XMLDataWriter;
import org.kohsuke.stapler.export.XSD;

public class SchemaGenerator {
    private final Stack<Model> queue = new Stack();
    private final Set<Model> written = new HashSet<Model>();
    private final Set<Class> enums = new HashSet<Class>();
    private final ModelBuilder builder;
    private final Model<?> top;

    public SchemaGenerator(Model<?> m) {
        this.builder = m.parent;
        this.top = m;
    }

    public void generateSchema(Result r) {
        XSD.Schema s = (XSD.Schema)TXW.create(XSD.Schema.class, (XmlSerializer)ResultFactory.createSerializer((Result)r));
        s._namespace("http://www.w3.org/2001/XMLSchema", "xsd");
        this.queue.clear();
        this.written.clear();
        s.element().name(this.top.type.getSimpleName()).type(this.getXmlTypeName(this.top.type));
        while (!this.queue.isEmpty()) {
            this.writeBean(s, this.queue.pop());
        }
        for (Class e : this.enums) {
            this.writeEnum(s, e);
        }
        s.commit();
    }

    private void writeEnum(XSD.Schema s, Class e) {
        XSD.Restriction facets = s.simpleType().name(this.getXmlToken(e)).restriction().base(XSD.Types.STRING);
        for (Object constant : e.getEnumConstants()) {
            facets.enumeration().value(constant.toString());
        }
    }

    private void writeBean(XSD.Schema s, Model<?> m) {
        XSD.ContentModel cm;
        XSD.ComplexType ct = s.complexType().name(this.getXmlToken(m.type));
        if (m.superModel == null) {
            cm = ct.sequence();
        } else {
            this.addToQueue(m.superModel);
            cm = ct.complexContent().extension().base(this.getXmlTypeName(m.superModel.type)).sequence();
        }
        for (Property p : m.getProperties()) {
            Class itemType;
            boolean isCollection;
            Class t = p.getType();
            if (t.isArray()) {
                isCollection = true;
                itemType = t.getComponentType();
            } else if (Collection.class.isAssignableFrom(t)) {
                isCollection = true;
                itemType = TypeUtil.erasure(TypeUtil.getTypeArgument(TypeUtil.getBaseClass(p.getGenericType(), Collection.class), 0));
            } else {
                isCollection = false;
                itemType = t;
            }
            XSD.Element e = cm.element().name(isCollection ? XMLDataWriter.toSingular(p.name) : p.name).type(this.getXmlTypeName(itemType));
            if (!t.isPrimitive()) {
                e.minOccurs(0);
            }
            if (isCollection) {
                e.maxOccurs("unbounded");
            }
            this.annotate(e, p.getJavadoc());
        }
    }

    private void annotate(XSD.Annotated e, String javadoc) {
        if (javadoc == null) {
            return;
        }
        e.annotation().documentation(javadoc);
    }

    public void add(Class<?> c) {
        this.addToQueue(this.builder.get(c));
    }

    private void addToQueue(Model m) {
        if (this.written.add(m)) {
            this.queue.push(m);
        }
    }

    public QName getXmlTypeName(Class<?> t) {
        if (Property.STRING_TYPES.contains(t)) {
            return XSD.Types.STRING;
        }
        if (t == Boolean.class || t == Boolean.TYPE) {
            return XSD.Types.BOOLEAN;
        }
        if (t == Integer.class || t == Integer.TYPE) {
            return XSD.Types.INT;
        }
        if (t == Long.class || t == Long.TYPE) {
            return XSD.Types.LONG;
        }
        if (Map.class.isAssignableFrom(t)) {
            return XSD.Types.ANYTYPE;
        }
        if (Calendar.class.isAssignableFrom(t)) {
            return XSD.Types.LONG;
        }
        if (Enum.class.isAssignableFrom(t)) {
            this.enums.add(t);
            return new QName(this.getXmlToken(t));
        }
        try {
            this.addToQueue(this.builder.get(t));
        }
        catch (IllegalArgumentException e) {
            return XSD.Types.ANYTYPE;
        }
        return new QName(this.getXmlToken(t));
    }

    private String getXmlToken(Class<?> t) {
        return t.getName().replace('$', '-');
    }

    private String getXmlElementName(Class<?> type) {
        return this.getXmlToken(type);
    }
}

