/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.export;

import java.beans.Introspector;
import java.io.IOException;
import java.io.Writer;
import java.util.Stack;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.DataWriter;
import org.kohsuke.stapler.export.XmlChars;

final class XMLDataWriter
implements DataWriter {
    private String name;
    private final Stack<String> objectNames = new Stack();
    private final Stack<Boolean> arrayState = new Stack();
    private final Writer out;
    public boolean isArray;

    XMLDataWriter(Object bean, Writer out) throws IOException {
        Class<?> c = bean.getClass();
        while (c.isAnonymousClass()) {
            c = c.getSuperclass();
        }
        this.name = Introspector.decapitalize(c.getSimpleName());
        this.out = out;
    }

    XMLDataWriter(Object bean, StaplerResponse rsp) throws IOException {
        this(bean, rsp.getWriter());
    }

    @Override
    public void name(String name) {
        this.name = name;
    }

    @Override
    public void valuePrimitive(Object v) throws IOException {
        this.value(v.toString());
    }

    @Override
    public void value(String v) throws IOException {
        String n = this.adjustName();
        this.out.write('<' + n + '>');
        this.out.write(this.escape(v));
        this.out.write("</" + n + '>');
    }

    private String escape(String v) {
        StringBuffer buf = new StringBuffer(v.length() + 64);
        for (int i = 0; i < v.length(); ++i) {
            char ch = v.charAt(i);
            if (ch == '<') {
                buf.append("&lt;");
                continue;
            }
            if (ch == '>') {
                buf.append("&gt;");
                continue;
            }
            if (ch == '&') {
                buf.append("&amp;");
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    @Override
    public void valueNull() {
    }

    @Override
    public void startArray() {
        this.isArray = true;
    }

    @Override
    public void endArray() {
        this.isArray = false;
    }

    @Override
    public void startObject() throws IOException {
        this.objectNames.push(this.name);
        this.out.write('<' + this.adjustName() + '>');
        this.arrayState.push(this.isArray);
        this.isArray = false;
    }

    @Override
    public void endObject() throws IOException {
        this.name = this.objectNames.pop();
        this.isArray = this.arrayState.pop();
        this.out.write("</" + this.adjustName() + '>');
    }

    private String adjustName() {
        String escaped = XMLDataWriter.makeXmlName(this.name);
        if (this.isArray) {
            return XMLDataWriter.toSingular(escaped);
        }
        return escaped;
    }

    static String toSingular(String name) {
        if (name.endsWith("s")) {
            return name.substring(0, name.length() - 1);
        }
        return name;
    }

    static String makeXmlName(String name) {
        if (name.length() == 0) {
            name = "_";
        }
        if (!XmlChars.isNameStart(name.charAt(0))) {
            name = name.length() > 1 && XmlChars.isNameStart(name.charAt(1)) ? name.substring(1) : '_' + name;
        }
        int i = 1;
        while (i < name.length()) {
            if (XmlChars.isNameChar(name.charAt(i))) {
                ++i;
                continue;
            }
            name = name.substring(0, i) + name.substring(i + 1);
        }
        return name;
    }
}

