/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.framework.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class AtomicFileWriter
extends Writer {
    private final Writer core;
    private final File tmpFile;
    private final File destFile;

    public AtomicFileWriter(File f) throws IOException {
        this.tmpFile = File.createTempFile("atomic", null, f.getParentFile());
        this.destFile = f;
        this.core = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.tmpFile), "UTF-8"));
    }

    @Override
    public void write(int c) throws IOException {
        this.core.write(c);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.core.write(str, off, len);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.core.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.core.flush();
    }

    @Override
    public void close() throws IOException {
        this.core.close();
    }

    public void commit() throws IOException {
        this.close();
        if (this.destFile.exists() && !this.destFile.delete()) {
            throw new IOException("Unable to delete " + this.destFile);
        }
        this.tmpFile.renameTo(this.destFile);
    }

    public File getTemporaryFile() {
        return this.tmpFile;
    }
}

