/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.framework.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.commons.io.output.CountingOutputStream;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.framework.io.ByteBuffer;
import org.kohsuke.stapler.framework.io.CharSpool;
import org.kohsuke.stapler.framework.io.LineEndNormalizingWriter;
import org.kohsuke.stapler.framework.io.WriterOutputStream;

public class LargeText {
    private final Source source;
    protected final Charset charset;
    private volatile boolean completed;

    public LargeText(File file, boolean completed) {
        this(file, Charset.defaultCharset(), completed);
    }

    public LargeText(final File file, Charset charset, boolean completed) {
        this.charset = charset;
        this.source = new Source(){

            @Override
            public Session open() throws IOException {
                return new FileSession(file);
            }

            @Override
            public long length() {
                return file.length();
            }

            @Override
            public boolean exists() {
                return file.exists();
            }
        };
        this.completed = completed;
    }

    public LargeText(ByteBuffer memory, boolean completed) {
        this(memory, Charset.defaultCharset(), completed);
    }

    public LargeText(final ByteBuffer memory, Charset charset, boolean completed) {
        this.charset = charset;
        this.source = new Source(){

            @Override
            public Session open() throws IOException {
                return new BufferSession(memory);
            }

            @Override
            public long length() {
                return memory.length();
            }

            @Override
            public boolean exists() {
                return true;
            }
        };
        this.completed = completed;
    }

    public void markAsComplete() {
        this.completed = true;
    }

    public boolean isComplete() {
        return this.completed;
    }

    public long length() {
        return this.source.length();
    }

    public Reader readAll() throws IOException {
        return new InputStreamReader(new InputStream(){
            final Session session;
            {
                this.session = LargeText.this.source.open();
            }

            @Override
            public int read() throws IOException {
                byte[] buf = new byte[1];
                int n = this.session.read(buf);
                if (n == 1) {
                    return buf[0];
                }
                return -1;
            }

            @Override
            public int read(byte[] buf, int off, int len) throws IOException {
                return this.session.read(buf, off, len);
            }

            @Override
            public void close() throws IOException {
                this.session.close();
            }
        }, this.charset);
    }

    public long writeLogTo(long start, Writer w) throws IOException {
        return this.writeLogTo(start, new WriterOutputStream(w, this.charset));
    }

    public long writeLogTo(long start, OutputStream out) throws IOException {
        CountingOutputStream os = new CountingOutputStream(out);
        Session f = this.source.open();
        f.skip(start);
        if (this.completed) {
            int sz;
            byte[] buf = new byte[1024];
            while ((sz = f.read(buf)) >= 0) {
                os.write(buf, 0, sz);
            }
        } else {
            ByteBuf buf = new ByteBuf(null, f);
            HeadMark head = new HeadMark(buf);
            TailMark tail = new TailMark(buf);
            while (tail.moveToNextLine(f)) {
                head.moveTo(tail, (OutputStream)os);
            }
            head.finish((OutputStream)os);
        }
        f.close();
        os.flush();
        return (long)os.getCount() + start;
    }

    public void doProgressText(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.setContentType(rsp);
        rsp.setStatus(200);
        if (!this.source.exists()) {
            rsp.addHeader("X-Text-Size", "0");
            rsp.addHeader("X-More-Data", "true");
            return;
        }
        long start = 0L;
        String s = req.getParameter("start");
        if (s != null) {
            start = Long.parseLong(s);
        }
        if (this.source.length() < start) {
            start = 0L;
        }
        CharSpool spool = new CharSpool();
        long r = this.writeLogTo(start, spool);
        rsp.addHeader("X-Text-Size", String.valueOf(r));
        if (!this.completed) {
            rsp.addHeader("X-More-Data", "true");
        }
        Writer w = this.createWriter(req, rsp, r - start);
        spool.writeTo(new LineEndNormalizingWriter(w));
        w.close();
    }

    protected void setContentType(StaplerResponse rsp) {
        rsp.setContentType("text/plain;charset=UTF-8");
    }

    protected Writer createWriter(StaplerRequest req, StaplerResponse rsp, long size) throws IOException {
        if (size > 4096L) {
            return rsp.getCompressedWriter(req);
        }
        return rsp.getWriter();
    }

    private static final class BufferSession
    implements Session {
        private final InputStream in;

        public BufferSession(ByteBuffer buf) {
            this.in = buf.newInputStream();
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        public void skip(long start) throws IOException {
            while (start > 0L) {
                start -= this.in.skip(start);
            }
        }

        @Override
        public int read(byte[] buf) throws IOException {
            return this.in.read(buf);
        }

        @Override
        public int read(byte[] buf, int offset, int length) throws IOException {
            return this.in.read(buf, offset, length);
        }
    }

    private static final class FileSession
    implements Session {
        private final RandomAccessFile file;

        public FileSession(File file) throws IOException {
            this.file = new RandomAccessFile(file, "r");
        }

        @Override
        public void close() throws IOException {
            this.file.close();
        }

        @Override
        public void skip(long start) throws IOException {
            this.file.seek(this.file.getFilePointer() + start);
        }

        @Override
        public int read(byte[] buf) throws IOException {
            return this.file.read(buf);
        }

        @Override
        public int read(byte[] buf, int offset, int length) throws IOException {
            return this.file.read(buf, offset, length);
        }
    }

    private static interface Session {
        public void close() throws IOException;

        public void skip(long var1) throws IOException;

        public int read(byte[] var1) throws IOException;

        public int read(byte[] var1, int var2, int var3) throws IOException;
    }

    private static final class ByteBuf {
        private final byte[] buf = new byte[1024];
        private int size = 0;
        private ByteBuf next;

        public ByteBuf(ByteBuf previous, Session f) throws IOException {
            if (previous != null) {
                assert (previous.next == null);
                previous.next = this;
            }
            while (!this.isFull()) {
                int chunk = f.read(this.buf, this.size, this.buf.length - this.size);
                if (chunk == -1) {
                    return;
                }
                this.size += chunk;
            }
        }

        public boolean isFull() {
            return this.buf.length == this.size;
        }
    }

    private static final class TailMark
    extends Mark {
        public TailMark(ByteBuf buf) {
            super(buf);
        }

        boolean moveToNextLine(Session f) throws IOException {
            while (true) {
                if (this.pos == this.buf.size) {
                    if (!this.buf.isFull()) {
                        return false;
                    }
                    this.buf = new ByteBuf(this.buf, f);
                    this.pos = 0;
                    continue;
                }
                byte b = this.buf.buf[this.pos++];
                if (b == 13 || b == 10) break;
            }
            return true;
        }
    }

    private static final class HeadMark
    extends Mark {
        public HeadMark(ByteBuf buf) {
            super(buf);
        }

        void moveTo(Mark that, OutputStream os) throws IOException {
            while (this.buf != that.buf) {
                os.write(this.buf.buf, 0, this.buf.size);
                this.buf = this.buf.next;
                this.pos = 0;
            }
            this.pos = that.pos;
        }

        void finish(OutputStream os) throws IOException {
            os.write(this.buf.buf, 0, this.pos);
        }
    }

    private static class Mark {
        protected ByteBuf buf;
        protected int pos;

        public Mark(ByteBuf buf) {
            this.buf = buf;
        }
    }

    private static interface Source {
        public Session open() throws IOException;

        public long length();

        public boolean exists();
    }
}

