/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.basic;

import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import com.thoughtworks.xstream.core.util.ConcurrentWeakHashMap;
import java.util.Map;

public class StringConverter
extends AbstractSingleValueConverter {
    private final Map cache;

    public StringConverter(Map map) {
        this.cache = map;
    }

    public StringConverter() {
        this(new ConcurrentWeakHashMap());
    }

    public boolean canConvert(Class type) {
        return type.equals(String.class);
    }

    public Object fromString(String str) {
        if (this.cache != null) {
            String s = (String)this.cache.get(str);
            if (s == null) {
                this.cache.put(str, str);
                s = str;
            }
            return s;
        }
        return str;
    }
}

