/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.hyperic.sigar.FileTail;
import org.hyperic.sigar.FileWatcher;

public class FileWatcherThread
implements Runnable {
    public static final int DEFAULT_INTERVAL = 300000;
    private Thread thread = null;
    private static FileWatcherThread instance = null;
    private boolean shouldDie = false;
    private long interval = 300000L;
    private Set watchers = Collections.synchronizedSet(new HashSet());

    public static synchronized FileWatcherThread getInstance() {
        if (instance == null) {
            instance = new FileWatcherThread();
        }
        return instance;
    }

    public synchronized void doStart() {
        if (this.thread != null) {
            return;
        }
        this.thread = new Thread((Runnable)this, "FileWatcherThread");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public synchronized void doStop() {
        if (this.thread == null) {
            return;
        }
        this.die();
        this.thread.interrupt();
        this.thread = null;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public long getInterval() {
        return this.interval;
    }

    public void add(FileWatcher watcher) {
        this.watchers.add(watcher);
    }

    public void remove(FileWatcher watcher) {
        this.watchers.remove(watcher);
    }

    public void run() {
        while (!this.shouldDie) {
            this.check();
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void die() {
        this.shouldDie = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() {
        Set set = this.watchers;
        synchronized (set) {
            Iterator it = this.watchers.iterator();
            while (it.hasNext()) {
                FileWatcher watcher = (FileWatcher)it.next();
                try {
                    watcher.check();
                }
                catch (Exception e) {
                    FileTail.error("Unexpected exception: " + e.getMessage(), e);
                }
            }
        }
    }
}

