/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.component.datetimeentry;

import java.io.IOException;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.DateTimeConverter;
import javax.faces.render.Renderer;
import org.icefaces.component.animation.AnimationBehavior;
import org.icefaces.component.animation.ClientBehaviorContextImpl;
import org.icefaces.component.datetimeentry.DateTimeEntry;
import org.icefaces.component.utils.JSONBuilder;
import org.icefaces.component.utils.ScriptWriter;
import org.icefaces.component.utils.Utils;
import org.icefaces.render.MandatoryResourceComponent;
import org.icefaces.util.EnvUtils;

@MandatoryResourceComponent(value="org.icefaces.component.datetimeentry.DateTimeEntry")
public class DateTimeEntryRenderer
extends Renderer {
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        String styleClass;
        super.encodeBegin(context, component);
        ResponseWriter writer = context.getResponseWriter();
        String clientId = component.getClientId(context);
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)clientId, "clientId");
        DateTimeEntry dateTimeEntry = (DateTimeEntry)component;
        String style = dateTimeEntry.getStyle();
        if (style != null && style.trim().length() != 0) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if ((styleClass = dateTimeEntry.getStyleClass()) != null && styleClass.trim().length() != 0) {
            writer.writeAttribute("class", (Object)styleClass, "class");
        }
        writer.writeAttribute("tabindex", (Object)dateTimeEntry.getTabindex(), "tabindex");
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeEnd(context, component);
        ResponseWriter writer = context.getResponseWriter();
        DateTimeEntry dateTimeEntry = (DateTimeEntry)component;
        String clientId = component.getClientId(context);
        DateTimeConverter converter = dateTimeEntry.resolveDateTimeConverter(context);
        TimeZone tz = dateTimeEntry.resolveTimeZone(context);
        Locale currentLocale = dateTimeEntry.resolveLocale(context);
        SimpleDateFormat formatter = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3, currentLocale);
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        Date date = "ice.ser".equals(paramMap.get("ice.submit.type")) ? (Date)converter.getAsObject(context, component, (String)dateTimeEntry.getSubmittedValue()) : (Date)dateTimeEntry.getValue();
        if (date == null) {
            Calendar calendar = Calendar.getInstance(tz, currentLocale);
            date = calendar.getTime();
        }
        String dateStr = converter.getAsString(context, (UIComponent)dateTimeEntry, (Object)date);
        formatter.setTimeZone(tz);
        formatter.applyPattern("MM/yyyy");
        String pageDate = formatter.format(date);
        formatter.applyPattern("MM/dd/yyyy");
        String selectedDate = formatter.format(date);
        formatter.applyPattern(DateTimeEntry.getDateTimeConverterPattern(converter));
        StringBuffer stringBuffer = new StringBuffer();
        DateFormat.Field[] hourFields = new DateFormat.Field[]{DateFormat.Field.HOUR0, DateFormat.Field.HOUR1, DateFormat.Field.HOUR_OF_DAY0, DateFormat.Field.HOUR_OF_DAY1};
        String[] hourFieldNames = new String[]{"HOUR0", "HOUR1", "HOUR_OF_DAY0", "HOUR_OF_DAY1"};
        String hourField = "";
        int savedBeginIndex = Integer.MAX_VALUE;
        int savedEndIndex = Integer.MAX_VALUE;
        for (int i = 0; i < hourFields.length; ++i) {
            stringBuffer.setLength(0);
            FieldPosition fieldPosition = new FieldPosition(hourFields[i]);
            formatter.format(date, stringBuffer, fieldPosition);
            int beginIndex = fieldPosition.getBeginIndex();
            int endIndex = fieldPosition.getEndIndex();
            if (beginIndex >= endIndex || beginIndex >= savedBeginIndex) continue;
            hourField = hourFieldNames[i];
            savedBeginIndex = beginIndex;
            savedEndIndex = endIndex;
        }
        String selectedHour = "";
        if (!hourField.equals("")) {
            selectedHour = stringBuffer.substring(savedBeginIndex, savedEndIndex);
        }
        String selectedMinute = String.valueOf(date.getMinutes());
        formatter.applyPattern("a");
        String amPmStr = formatter.format(date);
        DateFormatSymbols dateFormatSymbols = formatter.getDateFormatSymbols();
        String[] amPmStrings = dateFormatSymbols.getAmPmStrings();
        String[] longMonths = DateTimeEntryRenderer.mapMonths(dateFormatSymbols);
        String[] shortWeekdays = DateTimeEntryRenderer.mapWeekdays(dateFormatSymbols);
        StringBuffer unicodeLongMonths = new StringBuffer();
        StringBuffer unicodeShortWeekdays = new StringBuffer();
        for (String longMonth : longMonths) {
            unicodeLongMonths.append(",\"").append(DateTimeEntryRenderer.convertToEscapedUnicode(longMonth)).append("\"");
        }
        unicodeLongMonths.replace(0, 1, "[").append("]");
        for (String shortWeekday : shortWeekdays) {
            unicodeShortWeekdays.append(",\"").append(DateTimeEntryRenderer.convertToEscapedUnicode(shortWeekday)).append("\"");
        }
        unicodeShortWeekdays.replace(0, 1, "[").append("]");
        String params = "'" + clientId + "'," + JSONBuilder.create().beginMap().entry("pageDate", pageDate).entry("selectedDate", selectedDate).endMap().toString() + "," + JSONBuilder.create().beginMap().entry("dateStr", dateStr).entry("selectedHour", selectedHour).entry("selectedMinute", selectedMinute).entry("hourField", hourField).entry("amPmStr", amPmStr).entry("amStr", amPmStrings[0]).entry("pmStr", amPmStrings[1]).entry("renderAsPopup", dateTimeEntry.isRenderAsPopup()).entry("renderInputField", dateTimeEntry.isRenderInputField()).entry("singleSubmit", dateTimeEntry.isSingleSubmit()).entry("ariaEnabled", EnvUtils.isAriaEnabled((FacesContext)context)).entry("disabled", dateTimeEntry.isDisabled()).entry("longMonths", unicodeLongMonths.toString(), true).entry("shortWeekdays", unicodeShortWeekdays.toString(), true).endMap().toString();
        final UIComponent cal = component;
        final StringBuilder effect = new StringBuilder();
        Utils.iterateEffects(new AnimationBehavior.Iterator(component){

            public void next(String event, AnimationBehavior effectBehavior) {
                effectBehavior.encodeBegin(FacesContext.getCurrentInstance(), cal);
                effect.append(effectBehavior.getScript(new ClientBehaviorContextImpl(this.getUIComponent(), "transition"), false));
            }
        });
        effect.append(";");
        effect.append("ice.component.calendar.updateProperties(");
        effect.append(params);
        effect.append(");");
        ScriptWriter.insertScript(context, component, effect.toString());
        writer.endElement("div");
    }

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
        DateTimeEntry dateTimeEntry = (DateTimeEntry)component;
        String clientId = component.getClientId(context);
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        String dateString = (String)paramMap.get(clientId + "_value");
        if (null == dateString) {
            return;
        }
        DateTimeConverter converter = dateTimeEntry.resolveDateTimeConverter(context);
        SimpleDateFormat formatter = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3, dateTimeEntry.resolveLocale(context));
        formatter.setTimeZone(dateTimeEntry.resolveTimeZone(context));
        formatter.applyPattern("yyyy-M-d H:m");
        try {
            dateString = converter.getAsString(context, (UIComponent)dateTimeEntry, (Object)formatter.parse(dateString));
        }
        catch (ParseException e) {
            // empty catch block
        }
        dateTimeEntry.setSubmittedValue(dateString);
        if ("ice.ser".equals(paramMap.get("ice.submit.type"))) {
            context.renderResponse();
        }
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        super.getConvertedValue(context, component, submittedValue);
        DateTimeEntry dateTimeEntry = (DateTimeEntry)component;
        return dateTimeEntry.resolveDateTimeConverter(context).getAsObject(context, component, (String)submittedValue);
    }

    private void printParams() {
        Map paramValuesMap = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterValuesMap();
        for (Map.Entry entry : paramValuesMap.entrySet()) {
            String key = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            System.out.print(key);
            System.out.print(" = ");
            for (String value : values) {
                System.out.print(value);
                System.out.print(", ");
            }
            System.out.println();
        }
    }

    public static String convertToEscapedUnicode(String s) {
        char[] chars = s.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(chars.length * 6);
        String[] leadingZeros = new String[]{"0000", "000", "00", "0", ""};
        for (int i = 0; i < chars.length; ++i) {
            String hexStr = Integer.toHexString(chars[i]).toUpperCase();
            stringBuffer.append("\\u");
            stringBuffer.append(leadingZeros[hexStr.length()]);
            stringBuffer.append(hexStr);
        }
        return stringBuffer.toString();
    }

    public static String[] mapMonths(DateFormatSymbols symbols) {
        String[] months = new String[12];
        String[] localeMonths = symbols.getMonths();
        months[0] = localeMonths[0];
        months[1] = localeMonths[1];
        months[2] = localeMonths[2];
        months[3] = localeMonths[3];
        months[4] = localeMonths[4];
        months[5] = localeMonths[5];
        months[6] = localeMonths[6];
        months[7] = localeMonths[7];
        months[8] = localeMonths[8];
        months[9] = localeMonths[9];
        months[10] = localeMonths[10];
        months[11] = localeMonths[11];
        return months;
    }

    private static String[] mapWeekdays(DateFormatSymbols symbols) {
        String[] weekdays = new String[7];
        String[] localeWeekdays = symbols.getShortWeekdays();
        weekdays[0] = localeWeekdays[1];
        weekdays[1] = localeWeekdays[2];
        weekdays[2] = localeWeekdays[3];
        weekdays[3] = localeWeekdays[4];
        weekdays[4] = localeWeekdays[5];
        weekdays[5] = localeWeekdays[6];
        weekdays[6] = localeWeekdays[7];
        return weekdays;
    }
}

